/*
 * Decompiled with CFR 0.152.
 */
package android.net.util;

import android.os.Handler;
import android.os.Looper;
import android.os.MessageQueue;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import java.io.FileDescriptor;
import libcore.io.IoUtils;

public abstract class PacketReader {
    private static final int FD_EVENTS = 5;
    private static final int UNREGISTER_THIS_FD = 0;
    public static final int DEFAULT_RECV_BUF_SIZE = 2048;
    private final Handler mHandler;
    private final MessageQueue mQueue;
    private final byte[] mPacket;
    private FileDescriptor mFd;
    private long mPacketsReceived;

    protected static void closeFd(FileDescriptor fd) {
        IoUtils.closeQuietly(fd);
    }

    protected PacketReader(Handler h) {
        this(h, 2048);
    }

    protected PacketReader(Handler h, int recvbufsize) {
        this.mHandler = h;
        this.mQueue = this.mHandler.getLooper().getQueue();
        this.mPacket = new byte[Math.max(recvbufsize, 2048)];
    }

    public final void start() {
        if (this.onCorrectThread()) {
            this.createAndRegisterFd();
        } else {
            this.mHandler.post(() -> {
                this.logError("start() called from off-thread", null);
                this.createAndRegisterFd();
            });
        }
    }

    public final void stop() {
        if (this.onCorrectThread()) {
            this.unregisterAndDestroyFd();
        } else {
            this.mHandler.post(() -> {
                this.logError("stop() called from off-thread", null);
                this.unregisterAndDestroyFd();
            });
        }
    }

    public Handler getHandler() {
        return this.mHandler;
    }

    public final int recvBufSize() {
        return this.mPacket.length;
    }

    public final long numPacketsReceived() {
        return this.mPacketsReceived;
    }

    protected abstract FileDescriptor createFd();

    protected int readPacket(FileDescriptor fd, byte[] packetBuffer) throws Exception {
        return Os.read(fd, packetBuffer, 0, packetBuffer.length);
    }

    protected void handlePacket(byte[] recvbuf, int length) {
    }

    protected void logError(String msg, Exception e) {
    }

    protected void onStart() {
    }

    protected void onStop() {
    }

    private void createAndRegisterFd() {
        if (this.mFd != null) {
            return;
        }
        try {
            this.mFd = this.createFd();
            if (this.mFd != null) {
                IoUtils.setBlocking(this.mFd, false);
            }
        }
        catch (Exception e) {
            this.logError("Failed to create socket: ", e);
            PacketReader.closeFd(this.mFd);
            this.mFd = null;
            return;
        }
        if (this.mFd == null) {
            return;
        }
        this.mQueue.addOnFileDescriptorEventListener(this.mFd, 5, new MessageQueue.OnFileDescriptorEventListener(){

            @Override
            public int onFileDescriptorEvents(FileDescriptor fd, int events) {
                if (!PacketReader.this.isRunning() || !PacketReader.this.handleInput()) {
                    PacketReader.this.unregisterAndDestroyFd();
                    return 0;
                }
                return 5;
            }
        });
        this.onStart();
    }

    private boolean isRunning() {
        return this.mFd != null && this.mFd.valid();
    }

    private boolean handleInput() {
        while (this.isRunning()) {
            int bytesRead;
            try {
                bytesRead = this.readPacket(this.mFd, this.mPacket);
                if (bytesRead < 1) {
                    if (!this.isRunning()) break;
                    this.logError("Socket closed, exiting", null);
                    break;
                }
                ++this.mPacketsReceived;
            }
            catch (ErrnoException e) {
                if (e.errno == OsConstants.EAGAIN) {
                    return true;
                }
                if (e.errno == OsConstants.EINTR) continue;
                if (!this.isRunning()) break;
                this.logError("readPacket error: ", e);
                break;
            }
            catch (Exception e) {
                if (!this.isRunning()) break;
                this.logError("readPacket error: ", e);
                break;
            }
            try {
                this.handlePacket(this.mPacket, bytesRead);
            }
            catch (Exception e) {
                this.logError("handlePacket error: ", e);
                break;
            }
        }
        return false;
    }

    private void unregisterAndDestroyFd() {
        if (this.mFd == null) {
            return;
        }
        this.mQueue.removeOnFileDescriptorEventListener(this.mFd);
        PacketReader.closeFd(this.mFd);
        this.mFd = null;
        this.onStop();
    }

    private boolean onCorrectThread() {
        return this.mHandler.getLooper() == Looper.myLooper();
    }
}

