/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.rtt;

import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public final class LocationConfigurationInformation
implements Parcelable {
    public static final int ALTITUDE_UNKNOWN = 0;
    public static final int ALTITUDE_IN_METERS = 1;
    public static final int ALTITUDE_IN_FLOORS = 2;
    private final double mLatitude;
    private final double mLatitudeUncertainty;
    private final double mLongitude;
    private final double mLongitudeUncertainty;
    private final int mAltitudeType;
    private final double mAltitude;
    private final double mAltitudeUncertainty;
    public static final Parcelable.Creator<LocationConfigurationInformation> CREATOR = new Parcelable.Creator<LocationConfigurationInformation>(){

        public LocationConfigurationInformation[] newArray(int size) {
            return new LocationConfigurationInformation[size];
        }

        @Override
        public LocationConfigurationInformation createFromParcel(Parcel in) {
            double latitude = in.readDouble();
            double latitudeUnc = in.readDouble();
            double longitude = in.readDouble();
            double longitudeUnc = in.readDouble();
            int altitudeType = in.readInt();
            double altitude = in.readDouble();
            double altitudeUnc = in.readDouble();
            return new LocationConfigurationInformation(latitude, latitudeUnc, longitude, longitudeUnc, altitudeType, altitude, altitudeUnc);
        }
    };

    public static LocationConfigurationInformation parseInformationElement(byte id2, byte[] data) {
        return null;
    }

    public LocationConfigurationInformation(double latitude, double latitudeUncertainty, double longitude, double longitudeUncertainty, int altitudeType, double altitude, double altitudeUncertainty) {
        this.mLatitude = latitude;
        this.mLatitudeUncertainty = latitudeUncertainty;
        this.mLongitude = longitude;
        this.mLongitudeUncertainty = longitudeUncertainty;
        this.mAltitudeType = altitudeType;
        this.mAltitude = altitude;
        this.mAltitudeUncertainty = altitudeUncertainty;
    }

    public double getLatitude() {
        return this.mLatitude;
    }

    public double getLatitudeUncertainty() {
        return this.mLatitudeUncertainty;
    }

    public double getLongitude() {
        return this.mLongitude;
    }

    public double getLongitudeUncertainty() {
        return this.mLongitudeUncertainty;
    }

    public int getAltitudeType() {
        return this.mAltitudeType;
    }

    public double getAltitude() {
        if (this.mAltitudeType == 0) {
            throw new IllegalStateException("getAltitude(): invoked on an invalid type: getAltitudeType()==UNKNOWN");
        }
        return this.mAltitude;
    }

    public double getAltitudeUncertainty() {
        if (this.mAltitudeType != 1) {
            throw new IllegalStateException("getAltitude(): invoked on an invalid type: getAltitudeType()!=IN_METERS");
        }
        return this.mAltitudeUncertainty;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeDouble(this.mLatitude);
        dest.writeDouble(this.mLatitudeUncertainty);
        dest.writeDouble(this.mLongitude);
        dest.writeDouble(this.mLongitudeUncertainty);
        dest.writeInt(this.mAltitudeType);
        dest.writeDouble(this.mAltitude);
        dest.writeDouble(this.mAltitudeUncertainty);
    }

    public String toString() {
        return "LCI: latitude=" + this.mLatitude + ", latitudeUncertainty=" + this.mLatitudeUncertainty + ", longitude=" + this.mLongitude + ", longitudeUncertainty=" + this.mLongitudeUncertainty + ", altitudeType=" + this.mAltitudeType + ", altitude=" + this.mAltitude + ", altitudeUncertainty=" + this.mAltitudeUncertainty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocationConfigurationInformation)) {
            return false;
        }
        LocationConfigurationInformation lhs = (LocationConfigurationInformation)o;
        return this.mLatitude == lhs.mLatitude && this.mLatitudeUncertainty == lhs.mLatitudeUncertainty && this.mLongitude == lhs.mLongitude && this.mLongitudeUncertainty == lhs.mLongitudeUncertainty && this.mAltitudeType == lhs.mAltitudeType && this.mAltitude == lhs.mAltitude && this.mAltitudeUncertainty == lhs.mAltitudeUncertainty;
    }

    public int hashCode() {
        return Objects.hash(this.mLatitude, this.mLatitudeUncertainty, this.mLongitude, this.mLongitudeUncertainty, this.mAltitudeType, this.mAltitude, this.mAltitudeUncertainty);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AltitudeTypes {
    }
}

