/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.rtt;

import android.annotation.SystemApi;
import android.net.MacAddress;
import android.net.wifi.ScanResult;
import android.net.wifi.aware.PeerHandle;
import android.net.wifi.rtt.ResponderConfig;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

public final class RangingRequest
implements Parcelable {
    private static final int MAX_PEERS = 10;
    public final List<ResponderConfig> mRttPeers;
    public static final Parcelable.Creator<RangingRequest> CREATOR = new Parcelable.Creator<RangingRequest>(){

        public RangingRequest[] newArray(int size) {
            return new RangingRequest[size];
        }

        @Override
        public RangingRequest createFromParcel(Parcel in) {
            return new RangingRequest(in.readArrayList(null));
        }
    };

    public static int getMaxPeers() {
        return 10;
    }

    private RangingRequest(List<ResponderConfig> rttPeers) {
        this.mRttPeers = rttPeers;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeList(this.mRttPeers);
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(", ", "RangingRequest: mRttPeers=[", "]");
        for (ResponderConfig rc : this.mRttPeers) {
            sj.add(rc.toString());
        }
        return sj.toString();
    }

    public void enforceValidity(boolean awareSupported) {
        if (this.mRttPeers.size() > 10) {
            throw new IllegalArgumentException("Ranging to too many peers requested. Use getMaxPeers() API to get limit.");
        }
        for (ResponderConfig peer : this.mRttPeers) {
            if (peer.isValid(awareSupported)) continue;
            throw new IllegalArgumentException("Invalid Responder specification");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RangingRequest)) {
            return false;
        }
        RangingRequest lhs = (RangingRequest)o;
        return this.mRttPeers.size() == lhs.mRttPeers.size() && this.mRttPeers.containsAll(lhs.mRttPeers);
    }

    public int hashCode() {
        return this.mRttPeers.hashCode();
    }

    public static final class Builder {
        private List<ResponderConfig> mRttPeers = new ArrayList<ResponderConfig>();

        public Builder addAccessPoint(ScanResult apInfo) {
            if (apInfo == null) {
                throw new IllegalArgumentException("Null ScanResult!");
            }
            return this.addResponder(ResponderConfig.fromScanResult(apInfo));
        }

        public Builder addAccessPoints(List<ScanResult> apInfos) {
            if (apInfos == null) {
                throw new IllegalArgumentException("Null list of ScanResults!");
            }
            for (ScanResult scanResult : apInfos) {
                this.addAccessPoint(scanResult);
            }
            return this;
        }

        public Builder addWifiAwarePeer(MacAddress peerMacAddress) {
            if (peerMacAddress == null) {
                throw new IllegalArgumentException("Null peer MAC address");
            }
            return this.addResponder(ResponderConfig.fromWifiAwarePeerMacAddressWithDefaults(peerMacAddress));
        }

        public Builder addWifiAwarePeer(PeerHandle peerHandle) {
            if (peerHandle == null) {
                throw new IllegalArgumentException("Null peer handler (identifier)");
            }
            return this.addResponder(ResponderConfig.fromWifiAwarePeerHandleWithDefaults(peerHandle));
        }

        @SystemApi
        public Builder addResponder(ResponderConfig responder) {
            if (responder == null) {
                throw new IllegalArgumentException("Null Responder!");
            }
            this.mRttPeers.add(responder);
            return this;
        }

        public RangingRequest build() {
            return new RangingRequest(this.mRttPeers);
        }
    }
}

