/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.rtt;

import android.net.MacAddress;
import android.net.wifi.aware.PeerHandle;
import android.net.wifi.rtt.LocationCivic;
import android.net.wifi.rtt.LocationConfigurationInformation;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public final class RangingResult
implements Parcelable {
    private static final String TAG = "RangingResult";
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FAIL = 1;
    private final int mStatus;
    private final MacAddress mMac;
    private final PeerHandle mPeerHandle;
    private final int mDistanceMm;
    private final int mDistanceStdDevMm;
    private final int mRssi;
    private final LocationConfigurationInformation mLci;
    private final LocationCivic mLcr;
    private final long mTimestamp;
    public static final Parcelable.Creator<RangingResult> CREATOR = new Parcelable.Creator<RangingResult>(){

        public RangingResult[] newArray(int size) {
            return new RangingResult[size];
        }

        @Override
        public RangingResult createFromParcel(Parcel in) {
            int status = in.readInt();
            boolean macAddressPresent = in.readBoolean();
            MacAddress mac = null;
            if (macAddressPresent) {
                mac = MacAddress.CREATOR.createFromParcel(in);
            }
            boolean peerHandlePresent = in.readBoolean();
            PeerHandle peerHandle = null;
            if (peerHandlePresent) {
                peerHandle = new PeerHandle(in.readInt());
            }
            int distanceMm = in.readInt();
            int distanceStdDevMm = in.readInt();
            int rssi = in.readInt();
            boolean lciPresent = in.readBoolean();
            LocationConfigurationInformation lci = null;
            if (lciPresent) {
                lci = LocationConfigurationInformation.CREATOR.createFromParcel(in);
            }
            boolean lcrPresent = in.readBoolean();
            LocationCivic lcr = null;
            if (lcrPresent) {
                lcr = LocationCivic.CREATOR.createFromParcel(in);
            }
            long timestamp = in.readLong();
            if (peerHandlePresent) {
                return new RangingResult(status, peerHandle, distanceMm, distanceStdDevMm, rssi, lci, lcr, timestamp);
            }
            return new RangingResult(status, mac, distanceMm, distanceStdDevMm, rssi, lci, lcr, timestamp);
        }
    };

    public RangingResult(int status, MacAddress mac, int distanceMm, int distanceStdDevMm, int rssi, LocationConfigurationInformation lci, LocationCivic lcr, long timestamp) {
        this.mStatus = status;
        this.mMac = mac;
        this.mPeerHandle = null;
        this.mDistanceMm = distanceMm;
        this.mDistanceStdDevMm = distanceStdDevMm;
        this.mRssi = rssi;
        this.mLci = lci;
        this.mLcr = lcr;
        this.mTimestamp = timestamp;
    }

    public RangingResult(int status, PeerHandle peerHandle, int distanceMm, int distanceStdDevMm, int rssi, LocationConfigurationInformation lci, LocationCivic lcr, long timestamp) {
        this.mStatus = status;
        this.mMac = null;
        this.mPeerHandle = peerHandle;
        this.mDistanceMm = distanceMm;
        this.mDistanceStdDevMm = distanceStdDevMm;
        this.mRssi = rssi;
        this.mLci = lci;
        this.mLcr = lcr;
        this.mTimestamp = timestamp;
    }

    public int getStatus() {
        return this.mStatus;
    }

    public MacAddress getMacAddress() {
        return this.mMac;
    }

    public PeerHandle getPeerHandle() {
        return this.mPeerHandle;
    }

    public int getDistanceMm() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getDistanceMm(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mDistanceMm;
    }

    public int getDistanceStdDevMm() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getDistanceStdDevMm(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mDistanceStdDevMm;
    }

    public int getRssi() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getRssi(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mRssi;
    }

    public LocationConfigurationInformation getReportedLocationConfigurationInformation() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getReportedLocationConfigurationInformation(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mLci;
    }

    public LocationCivic getReportedLocationCivic() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getReportedLocationCivic(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mLcr;
    }

    public long getRangingTimestampUs() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getRangingTimestamp(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mTimestamp;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mStatus);
        if (this.mMac == null) {
            dest.writeBoolean(false);
        } else {
            dest.writeBoolean(true);
            this.mMac.writeToParcel(dest, flags);
        }
        if (this.mPeerHandle == null) {
            dest.writeBoolean(false);
        } else {
            dest.writeBoolean(true);
            dest.writeInt(this.mPeerHandle.peerId);
        }
        dest.writeInt(this.mDistanceMm);
        dest.writeInt(this.mDistanceStdDevMm);
        dest.writeInt(this.mRssi);
        if (this.mLci == null) {
            dest.writeBoolean(false);
        } else {
            dest.writeBoolean(true);
            this.mLci.writeToParcel(dest, flags);
        }
        if (this.mLcr == null) {
            dest.writeBoolean(false);
        } else {
            dest.writeBoolean(true);
            this.mLcr.writeToParcel(dest, flags);
        }
        dest.writeLong(this.mTimestamp);
    }

    public String toString() {
        return "RangingResult: [status=" + this.mStatus + ", mac=" + this.mMac + ", peerHandle=" + (this.mPeerHandle == null ? "<null>" : Integer.valueOf(this.mPeerHandle.peerId)) + ", distanceMm=" + this.mDistanceMm + ", distanceStdDevMm=" + this.mDistanceStdDevMm + ", rssi=" + this.mRssi + ", lci=" + this.mLci + ", lcr=" + this.mLcr + ", timestamp=" + this.mTimestamp + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RangingResult)) {
            return false;
        }
        RangingResult lhs = (RangingResult)o;
        return this.mStatus == lhs.mStatus && Objects.equals(this.mMac, lhs.mMac) && Objects.equals(this.mPeerHandle, lhs.mPeerHandle) && this.mDistanceMm == lhs.mDistanceMm && this.mDistanceStdDevMm == lhs.mDistanceStdDevMm && this.mRssi == lhs.mRssi && Objects.equals(this.mLci, lhs.mLci) && Objects.equals(this.mLcr, lhs.mLcr) && this.mTimestamp == lhs.mTimestamp;
    }

    public int hashCode() {
        return Objects.hash(this.mStatus, this.mMac, this.mPeerHandle, this.mDistanceMm, this.mDistanceStdDevMm, this.mRssi, this.mLci, this.mLcr, this.mTimestamp);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RangeResultStatus {
    }
}

