/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.rtt;

import android.annotation.SystemApi;
import android.content.Context;
import android.net.wifi.rtt.IRttCallback;
import android.net.wifi.rtt.IWifiRttManager;
import android.net.wifi.rtt.RangingRequest;
import android.net.wifi.rtt.RangingResult;
import android.net.wifi.rtt.RangingResultCallback;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.os.WorkSource;
import java.util.List;

public class WifiRttManager {
    private static final String TAG = "WifiRttManager";
    private static final boolean VDBG = false;
    private final Context mContext;
    private final IWifiRttManager mService;
    public static final String ACTION_WIFI_RTT_STATE_CHANGED = "android.net.wifi.rtt.action.WIFI_RTT_STATE_CHANGED";

    public WifiRttManager(Context context, IWifiRttManager service) {
        this.mContext = context;
        this.mService = service;
    }

    public boolean isAvailable() {
        try {
            return this.mService.isAvailable();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void startRanging(RangingRequest request, RangingResultCallback callback, Handler handler) {
        this.startRanging(null, request, callback, handler);
    }

    @SystemApi
    public void startRanging(WorkSource workSource, RangingRequest request, RangingResultCallback callback, Handler handler) {
        if (callback == null) {
            throw new IllegalArgumentException("Null callback provided");
        }
        Looper looper = handler == null ? Looper.getMainLooper() : handler.getLooper();
        Binder binder = new Binder();
        try {
            this.mService.startRanging(binder, this.mContext.getOpPackageName(), workSource, request, new RttCallbackProxy(looper, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public void cancelRanging(WorkSource workSource) {
        try {
            this.mService.cancelRanging(workSource);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static class RttCallbackProxy
    extends IRttCallback.Stub {
        private final Handler mHandler;
        private final RangingResultCallback mCallback;

        RttCallbackProxy(Looper looper, RangingResultCallback callback) {
            this.mHandler = new Handler(looper);
            this.mCallback = callback;
        }

        @Override
        public void onRangingFailure(int status) throws RemoteException {
            this.mHandler.post(() -> this.mCallback.onRangingFailure(status));
        }

        @Override
        public void onRangingResults(List<RangingResult> results) throws RemoteException {
            this.mHandler.post(() -> this.mCallback.onRangingResults(results));
        }
    }
}

