/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.SystemApi;
import android.content.Context;
import android.os.IBinder;
import android.os.IIncidentManager;
import android.os.IncidentReportArgs;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Settings;
import android.util.Slog;

@SystemApi
public class IncidentManager {
    private static final String TAG = "IncidentManager";
    private final Context mContext;
    private IIncidentManager mService;

    public IncidentManager(Context context) {
        this.mContext = context;
    }

    public void reportIncident(IncidentReportArgs args) {
        this.reportIncidentInternal(args);
    }

    public void reportIncident(String settingName, byte[] headerProto) {
        IncidentReportArgs args;
        String setting = Settings.Global.getString(this.mContext.getContentResolver(), settingName);
        try {
            args = IncidentReportArgs.parseSetting(setting);
        }
        catch (IllegalArgumentException ex) {
            Slog.w(TAG, "Bad value for incident report setting '" + settingName + "'", ex);
            return;
        }
        if (args == null) {
            Slog.i(TAG, String.format("Incident report requested but disabled with settings [name: %s, value: %s]", settingName, setting));
            return;
        }
        args.addHeader(headerProto);
        Slog.i(TAG, "Taking incident report: " + settingName);
        this.reportIncidentInternal(args);
    }

    private void reportIncidentInternal(IncidentReportArgs args) {
        try {
            IIncidentManager service = this.getIIncidentManagerLocked();
            if (service == null) {
                Slog.e(TAG, "reportIncident can't find incident binder service");
                return;
            }
            service.reportIncident(args);
        }
        catch (RemoteException ex) {
            Slog.e(TAG, "reportIncident failed", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IIncidentManager getIIncidentManagerLocked() throws RemoteException {
        if (this.mService != null) {
            return this.mService;
        }
        IncidentManager incidentManager = this;
        synchronized (incidentManager) {
            if (this.mService != null) {
                return this.mService;
            }
            this.mService = IIncidentManager.Stub.asInterface(ServiceManager.getService("incident"));
            if (this.mService != null) {
                this.mService.asBinder().linkToDeath(new IncidentdDeathRecipient(), 0);
            }
            return this.mService;
        }
    }

    private class IncidentdDeathRecipient
    implements IBinder.DeathRecipient {
        private IncidentdDeathRecipient() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            IncidentdDeathRecipient incidentdDeathRecipient = this;
            synchronized (incidentdDeathRecipient) {
                IncidentManager.this.mService = null;
            }
        }
    }
}

