/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.SharedMemory;
import android.system.ErrnoException;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class MemoryFile {
    private static String TAG = "MemoryFile";
    private SharedMemory mSharedMemory;
    private ByteBuffer mMapping;
    private boolean mAllowPurging = false;

    private static native boolean native_pin(FileDescriptor var0, boolean var1) throws IOException;

    private static native int native_get_size(FileDescriptor var0) throws IOException;

    public MemoryFile(String name, int length) throws IOException {
        try {
            this.mSharedMemory = SharedMemory.create(name, length);
            this.mMapping = this.mSharedMemory.mapReadWrite();
        }
        catch (ErrnoException ex) {
            ex.rethrowAsIOException();
        }
    }

    public void close() {
        this.deactivate();
        this.mSharedMemory.close();
    }

    void deactivate() {
        if (this.mMapping != null) {
            SharedMemory.unmap(this.mMapping);
            this.mMapping = null;
        }
    }

    private void checkActive() throws IOException {
        if (this.mMapping == null) {
            throw new IOException("MemoryFile has been deactivated");
        }
    }

    private void beginAccess() throws IOException {
        this.checkActive();
        if (this.mAllowPurging && MemoryFile.native_pin(this.mSharedMemory.getFileDescriptor(), true)) {
            throw new IOException("MemoryFile has been purged");
        }
    }

    private void endAccess() throws IOException {
        if (this.mAllowPurging) {
            MemoryFile.native_pin(this.mSharedMemory.getFileDescriptor(), false);
        }
    }

    public int length() {
        return this.mSharedMemory.getSize();
    }

    @Deprecated
    public boolean isPurgingAllowed() {
        return this.mAllowPurging;
    }

    @Deprecated
    public synchronized boolean allowPurging(boolean allowPurging) throws IOException {
        boolean oldValue = this.mAllowPurging;
        if (oldValue != allowPurging) {
            MemoryFile.native_pin(this.mSharedMemory.getFileDescriptor(), !allowPurging);
            this.mAllowPurging = allowPurging;
        }
        return oldValue;
    }

    public InputStream getInputStream() {
        return new MemoryInputStream();
    }

    public OutputStream getOutputStream() {
        return new MemoryOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytes(byte[] buffer, int srcOffset, int destOffset, int count) throws IOException {
        this.beginAccess();
        try {
            this.mMapping.position(srcOffset);
            this.mMapping.get(buffer, destOffset, count);
        }
        finally {
            this.endAccess();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBytes(byte[] buffer, int srcOffset, int destOffset, int count) throws IOException {
        this.beginAccess();
        try {
            this.mMapping.position(destOffset);
            this.mMapping.put(buffer, srcOffset, count);
        }
        finally {
            this.endAccess();
        }
    }

    public FileDescriptor getFileDescriptor() throws IOException {
        return this.mSharedMemory.getFileDescriptor();
    }

    public static int getSize(FileDescriptor fd) throws IOException {
        return MemoryFile.native_get_size(fd);
    }

    private class MemoryOutputStream
    extends OutputStream {
        private int mOffset = 0;
        private byte[] mSingleByte;

        private MemoryOutputStream() {
        }

        @Override
        public void write(byte[] buffer, int offset, int count) throws IOException {
            MemoryFile.this.writeBytes(buffer, offset, this.mOffset, count);
            this.mOffset += count;
        }

        @Override
        public void write(int oneByte) throws IOException {
            if (this.mSingleByte == null) {
                this.mSingleByte = new byte[1];
            }
            this.mSingleByte[0] = (byte)oneByte;
            this.write(this.mSingleByte, 0, 1);
        }
    }

    private class MemoryInputStream
    extends InputStream {
        private int mMark = 0;
        private int mOffset = 0;
        private byte[] mSingleByte;

        private MemoryInputStream() {
        }

        @Override
        public int available() throws IOException {
            if (this.mOffset >= MemoryFile.this.mSharedMemory.getSize()) {
                return 0;
            }
            return MemoryFile.this.mSharedMemory.getSize() - this.mOffset;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readlimit) {
            this.mMark = this.mOffset;
        }

        @Override
        public void reset() throws IOException {
            this.mOffset = this.mMark;
        }

        @Override
        public int read() throws IOException {
            int result;
            if (this.mSingleByte == null) {
                this.mSingleByte = new byte[1];
            }
            if ((result = this.read(this.mSingleByte, 0, 1)) != 1) {
                return -1;
            }
            return this.mSingleByte[0];
        }

        @Override
        public int read(byte[] buffer, int offset, int count) throws IOException {
            if (offset < 0 || count < 0 || offset + count > buffer.length) {
                throw new IndexOutOfBoundsException();
            }
            if ((count = Math.min(count, this.available())) < 1) {
                return -1;
            }
            int result = MemoryFile.this.readBytes(buffer, this.mOffset, offset, count);
            if (result > 0) {
                this.mOffset += result;
            }
            return result;
        }

        @Override
        public long skip(long n) throws IOException {
            if ((long)this.mOffset + n > (long)MemoryFile.this.mSharedMemory.getSize()) {
                n = MemoryFile.this.mSharedMemory.getSize() - this.mOffset;
            }
            this.mOffset = (int)((long)this.mOffset + n);
            return n;
        }
    }
}

