/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.PowerSaveState;
import java.util.function.Consumer;

public abstract class PowerManagerInternal {
    public static final int WAKEFULNESS_ASLEEP = 0;
    public static final int WAKEFULNESS_AWAKE = 1;
    public static final int WAKEFULNESS_DREAMING = 2;
    public static final int WAKEFULNESS_DOZING = 3;

    public static String wakefulnessToString(int wakefulness) {
        switch (wakefulness) {
            case 0: {
                return "Asleep";
            }
            case 1: {
                return "Awake";
            }
            case 2: {
                return "Dreaming";
            }
            case 3: {
                return "Dozing";
            }
        }
        return Integer.toString(wakefulness);
    }

    public static int wakefulnessToProtoEnum(int wakefulness) {
        switch (wakefulness) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return wakefulness;
    }

    public static boolean isInteractive(int wakefulness) {
        return wakefulness == 1 || wakefulness == 2;
    }

    public abstract void setScreenBrightnessOverrideFromWindowManager(int var1);

    public abstract void setUserActivityTimeoutOverrideFromWindowManager(long var1);

    public abstract void setUserInactiveOverrideFromWindowManager();

    public abstract void setMaximumScreenOffTimeoutFromDeviceAdmin(int var1, long var2);

    public abstract void setDozeOverrideFromDreamManager(int var1, int var2);

    public abstract PowerSaveState getLowPowerState(int var1);

    public abstract void registerLowPowerModeObserver(LowPowerModeListener var1);

    public void registerLowPowerModeObserver(final int serviceType, final Consumer<PowerSaveState> listener) {
        this.registerLowPowerModeObserver(new LowPowerModeListener(){

            @Override
            public int getServiceType() {
                return serviceType;
            }

            @Override
            public void onLowPowerModeChanged(PowerSaveState state) {
                listener.accept(state);
            }
        });
    }

    public abstract boolean setDeviceIdleMode(boolean var1);

    public abstract boolean setLightDeviceIdleMode(boolean var1);

    public abstract void setDeviceIdleWhitelist(int[] var1);

    public abstract void setDeviceIdleTempWhitelist(int[] var1);

    public abstract void startUidChanges();

    public abstract void finishUidChanges();

    public abstract void updateUidProcState(int var1, int var2);

    public abstract void uidGone(int var1);

    public abstract void uidActive(int var1);

    public abstract void uidIdle(int var1);

    public abstract void powerHint(int var1, int var2);

    public static interface LowPowerModeListener {
        public int getServiceType();

        public void onLowPowerModeChanged(PowerSaveState var1);
    }
}

