/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.app.ActivityThread;
import android.content.Context;
import android.media.AudioAttributes;
import android.os.Process;
import android.os.VibrationEffect;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class Vibrator {
    private static final String TAG = "Vibrator";
    public static final int VIBRATION_INTENSITY_OFF = 0;
    public static final int VIBRATION_INTENSITY_LOW = 1;
    public static final int VIBRATION_INTENSITY_MEDIUM = 2;
    public static final int VIBRATION_INTENSITY_HIGH = 3;
    private final String mPackageName;

    public Vibrator() {
        this.mPackageName = ActivityThread.currentPackageName();
    }

    protected Vibrator(Context context) {
        this.mPackageName = context.getOpPackageName();
    }

    public int getDefaultHapticFeedbackIntensity() {
        return 2;
    }

    public int getDefaultNotificationVibrationIntensity() {
        return 3;
    }

    public abstract boolean hasVibrator();

    public abstract boolean hasAmplitudeControl();

    @Deprecated
    public void vibrate(long milliseconds) {
        this.vibrate(milliseconds, null);
    }

    @Deprecated
    public void vibrate(long milliseconds, AudioAttributes attributes) {
        try {
            VibrationEffect effect = VibrationEffect.createOneShot(milliseconds, -1);
            this.vibrate(effect, attributes);
        }
        catch (IllegalArgumentException iae) {
            Log.e(TAG, "Failed to create VibrationEffect", iae);
        }
    }

    @Deprecated
    public void vibrate(long[] pattern, int repeat) {
        this.vibrate(pattern, repeat, null);
    }

    @Deprecated
    public void vibrate(long[] pattern, int repeat, AudioAttributes attributes) {
        if (repeat < -1 || repeat >= pattern.length) {
            Log.e(TAG, "vibrate called with repeat index out of bounds (pattern.length=" + pattern.length + ", index=" + repeat + ")");
            throw new ArrayIndexOutOfBoundsException();
        }
        try {
            this.vibrate(VibrationEffect.createWaveform(pattern, repeat), attributes);
        }
        catch (IllegalArgumentException iae) {
            Log.e(TAG, "Failed to create VibrationEffect", iae);
        }
    }

    public void vibrate(VibrationEffect vibe) {
        this.vibrate(vibe, null);
    }

    public void vibrate(VibrationEffect vibe, AudioAttributes attributes) {
        this.vibrate(Process.myUid(), this.mPackageName, vibe, attributes);
    }

    public abstract void vibrate(int var1, String var2, VibrationEffect var3, AudioAttributes var4);

    public abstract void cancel();

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VibrationIntensity {
    }
}

