/*
 * Decompiled with CFR 0.152.
 */
package android.privacy.internal.longitudinalreporting;

import android.privacy.DifferentialPrivacyEncoder;
import android.privacy.internal.longitudinalreporting.LongitudinalReportingConfig;
import android.privacy.internal.rappor.RapporConfig;
import android.privacy.internal.rappor.RapporEncoder;
import com.android.internal.annotations.VisibleForTesting;

public class LongitudinalReportingEncoder
implements DifferentialPrivacyEncoder {
    private static final String PRR1_ENCODER_ID = "prr1_encoder_id";
    private static final String PRR2_ENCODER_ID = "prr2_encoder_id";
    private final LongitudinalReportingConfig mConfig;
    private final RapporEncoder mIRREncoder;
    private final Boolean mFakeValue;
    private final boolean mIsSecure;

    public static LongitudinalReportingEncoder createEncoder(LongitudinalReportingConfig config, byte[] userSecret) {
        return new LongitudinalReportingEncoder(config, true, userSecret);
    }

    @VisibleForTesting
    public static LongitudinalReportingEncoder createInsecureEncoderForTest(LongitudinalReportingConfig config) {
        return new LongitudinalReportingEncoder(config, false, null);
    }

    private LongitudinalReportingEncoder(LongitudinalReportingConfig config, boolean secureEncoder, byte[] userSecret) {
        this.mConfig = config;
        this.mIsSecure = secureEncoder;
        boolean ignoreOriginalInput = LongitudinalReportingEncoder.getLongTermRandomizedResult(config.getProbabilityP(), secureEncoder, userSecret, config.getEncoderId() + PRR1_ENCODER_ID);
        this.mFakeValue = ignoreOriginalInput ? Boolean.valueOf(LongitudinalReportingEncoder.getLongTermRandomizedResult(config.getProbabilityQ(), secureEncoder, userSecret, config.getEncoderId() + PRR2_ENCODER_ID)) : null;
        RapporConfig irrConfig = config.getIRRConfig();
        this.mIRREncoder = secureEncoder ? RapporEncoder.createEncoder(irrConfig, userSecret) : RapporEncoder.createInsecureEncoderForTest(irrConfig);
    }

    @Override
    public byte[] encodeString(String original) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] encodeBoolean(boolean original) {
        if (this.mFakeValue != null) {
            original = this.mFakeValue;
        }
        return this.mIRREncoder.encodeBoolean(original);
    }

    @Override
    public byte[] encodeBits(byte[] bits) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LongitudinalReportingConfig getConfig() {
        return this.mConfig;
    }

    @Override
    public boolean isInsecureEncoderForTest() {
        return !this.mIsSecure;
    }

    @VisibleForTesting
    public static boolean getLongTermRandomizedResult(double p, boolean secureEncoder, byte[] userSecret, String encoderId) {
        double effectiveF = p < 0.5 ? p * 2.0 : (1.0 - p) * 2.0;
        boolean prrInput = !(p < 0.5);
        RapporConfig prrConfig = new RapporConfig(encoderId, 1, effectiveF, 0.0, 1.0, 1, 1);
        RapporEncoder encoder = secureEncoder ? RapporEncoder.createEncoder(prrConfig, userSecret) : RapporEncoder.createInsecureEncoderForTest(prrConfig);
        return encoder.encodeBoolean(prrInput)[0] > 0;
    }
}

