/*
 * Decompiled with CFR 0.152.
 */
package android.se.omapi;

import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.se.omapi.ISecureElementChannel;
import android.se.omapi.SEService;
import android.se.omapi.Session;
import android.util.Log;
import java.io.IOException;

public class Channel {
    private static final String TAG = "OMAPI.Channel";
    private Session mSession;
    private final ISecureElementChannel mChannel;
    private final SEService mService;
    private final Object mLock = new Object();

    Channel(SEService service, Session session, ISecureElementChannel channel) {
        if (service == null || session == null || channel == null) {
            throw new IllegalArgumentException("Parameters cannot be null");
        }
        this.mService = service;
        this.mSession = session;
        this.mChannel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.isClosed()) {
            Object object = this.mLock;
            synchronized (object) {
                try {
                    this.mChannel.close();
                }
                catch (Exception e) {
                    Log.e(TAG, "Error closing channel", e);
                }
            }
        }
    }

    public boolean isClosed() {
        if (!this.mService.isConnected()) {
            Log.e(TAG, "service not connected to system");
            return true;
        }
        try {
            return this.mChannel.isClosed();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Exception in isClosed()");
            return true;
        }
    }

    public boolean isBasicChannel() {
        if (!this.mService.isConnected()) {
            throw new IllegalStateException("service not connected to system");
        }
        try {
            return this.mChannel.isBasicChannel();
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public byte[] transmit(byte[] command) throws IOException {
        if (!this.mService.isConnected()) {
            throw new IllegalStateException("service not connected to system");
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                byte[] response = this.mChannel.transmit(command);
                if (response == null) {
                    throw new IOException("Error in communicating with Secure Element");
                }
                return response;
            }
            catch (ServiceSpecificException e) {
                throw new IOException(e.getMessage());
            }
            catch (RemoteException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
    }

    public Session getSession() {
        return this.mSession;
    }

    public byte[] getSelectResponse() {
        byte[] response;
        if (!this.mService.isConnected()) {
            throw new IllegalStateException("service not connected to system");
        }
        try {
            response = this.mChannel.getSelectResponse();
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e.getMessage());
        }
        if (response != null && response.length == 0) {
            response = null;
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean selectNext() throws IOException {
        if (!this.mService.isConnected()) {
            throw new IllegalStateException("service not connected to system");
        }
        try {
            Object object = this.mLock;
            synchronized (object) {
                return this.mChannel.selectNext();
            }
        }
        catch (ServiceSpecificException e) {
            throw new IOException(e.getMessage());
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }
}

