/*
 * Decompiled with CFR 0.152.
 */
package android.se.omapi;

import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.se.omapi.ISecureElementReader;
import android.se.omapi.ISecureElementSession;
import android.se.omapi.SEService;
import android.se.omapi.Session;
import android.util.Log;
import java.io.IOException;

public class Reader {
    private static final String TAG = "OMAPI.Reader";
    private final String mName;
    private final SEService mService;
    private ISecureElementReader mReader;
    private final Object mLock = new Object();

    Reader(SEService service, String name, ISecureElementReader reader) {
        if (reader == null || service == null || name == null) {
            throw new IllegalArgumentException("Parameters cannot be null");
        }
        this.mName = name;
        this.mService = service;
        this.mReader = reader;
    }

    public String getName() {
        return this.mName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session openSession() throws IOException {
        if (!this.mService.isConnected()) {
            throw new IllegalStateException("service is not connected");
        }
        Object object = this.mLock;
        synchronized (object) {
            ISecureElementSession session;
            try {
                session = this.mReader.openSession();
            }
            catch (ServiceSpecificException e) {
                throw new IOException(e.getMessage());
            }
            catch (RemoteException e) {
                throw new IllegalStateException(e.getMessage());
            }
            if (session == null) {
                throw new IOException("service session is null.");
            }
            return new Session(this.mService, session, this);
        }
    }

    public boolean isSecureElementPresent() {
        if (!this.mService.isConnected()) {
            throw new IllegalStateException("service is not connected");
        }
        try {
            return this.mReader.isSecureElementPresent();
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Error in isSecureElementPresent()");
        }
    }

    public SEService getSEService() {
        return this.mService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSessions() {
        if (!this.mService.isConnected()) {
            Log.e(TAG, "service is not connected");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mReader.closeSessions();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }
}

