/*
 * Decompiled with CFR 0.152.
 */
package android.se.omapi;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.se.omapi.ISecureElementListener;
import android.se.omapi.ISecureElementReader;
import android.se.omapi.ISecureElementService;
import android.se.omapi.Reader;
import android.util.Log;
import java.util.HashMap;

public class SEService {
    public static final int IO_ERROR = 1;
    public static final int NO_SUCH_ELEMENT_ERROR = 2;
    private static final String TAG = "OMAPI.SEService";
    private final Object mLock = new Object();
    private final Context mContext;
    private volatile ISecureElementService mSecureElementService;
    private ServiceConnection mConnection;
    private final HashMap<String, Reader> mReaders = new HashMap();
    private ISecureElementListener mSEListener;

    public SEService(Context context, ISecureElementListener listener) {
        if (context == null) {
            throw new NullPointerException("context must not be null");
        }
        this.mContext = context;
        this.mSEListener = listener;
        this.mConnection = new ServiceConnection(){

            @Override
            public synchronized void onServiceConnected(ComponentName className, IBinder service) {
                SEService.this.mSecureElementService = ISecureElementService.Stub.asInterface(service);
                if (SEService.this.mSEListener != null) {
                    try {
                        SEService.this.mSEListener.serviceConnected();
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                Log.i(SEService.TAG, "Service onServiceConnected");
            }

            @Override
            public void onServiceDisconnected(ComponentName className) {
                SEService.this.mSecureElementService = null;
                Log.i(SEService.TAG, "Service onServiceDisconnected");
            }
        };
        Intent intent = new Intent(ISecureElementService.class.getName());
        intent.setClassName("com.android.se", "com.android.se.SecureElementService");
        boolean bindingSuccessful = this.mContext.bindService(intent, this.mConnection, 1);
        if (bindingSuccessful) {
            Log.i(TAG, "bindService successful");
        }
    }

    public boolean isConnected() {
        return this.mSecureElementService != null;
    }

    public Reader[] getReaders() {
        String[] readerNames;
        if (this.mSecureElementService == null) {
            throw new IllegalStateException("service not connected to system");
        }
        try {
            readerNames = this.mSecureElementService.getReaders();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        Reader[] readers = new Reader[readerNames.length];
        int i = 0;
        for (String readerName : readerNames) {
            if (this.mReaders.get(readerName) == null) {
                try {
                    this.mReaders.put(readerName, new Reader(this, readerName, this.getReader(readerName)));
                    readers[i++] = this.mReaders.get(readerName);
                }
                catch (Exception e) {
                    Log.e(TAG, "Error adding Reader: " + readerName, e);
                }
                continue;
            }
            readers[i++] = this.mReaders.get(readerName);
        }
        return readers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSecureElementService != null) {
                for (Reader reader : this.mReaders.values()) {
                    try {
                        reader.closeSessions();
                    }
                    catch (Exception exception) {}
                }
            }
            try {
                this.mContext.unbindService(this.mConnection);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.mSecureElementService = null;
        }
    }

    public String getVersion() {
        return "3.2";
    }

    ISecureElementListener getListener() {
        return this.mSEListener;
    }

    private ISecureElementReader getReader(String name) {
        try {
            return this.mSecureElementService.getReader(name);
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }
}

