/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import android.security.ConfirmationAlreadyPresentingException;
import android.security.ConfirmationCallback;
import android.security.ConfirmationNotAvailableException;
import android.security.IConfirmationPromptCallback;
import android.security.KeyStore;
import android.text.TextUtils;
import android.util.Log;
import java.util.Locale;
import java.util.concurrent.Executor;

public class ConfirmationDialog {
    private static final String TAG = "ConfirmationDialog";
    private CharSequence mPromptText;
    private byte[] mExtraData;
    private ConfirmationCallback mCallback;
    private Executor mExecutor;
    private final KeyStore mKeyStore = KeyStore.getInstance();
    private final IBinder mCallbackBinder = new IConfirmationPromptCallback.Stub(){

        @Override
        public void onConfirmationPromptCompleted(final int responseCode, final byte[] dataThatWasConfirmed) throws RemoteException {
            if (ConfirmationDialog.this.mCallback != null) {
                final ConfirmationCallback callback = ConfirmationDialog.this.mCallback;
                Executor executor = ConfirmationDialog.this.mExecutor;
                ConfirmationDialog.this.mCallback = null;
                ConfirmationDialog.this.mExecutor = null;
                if (executor == null) {
                    ConfirmationDialog.this.doCallback(responseCode, dataThatWasConfirmed, callback);
                } else {
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            ConfirmationDialog.this.doCallback(responseCode, dataThatWasConfirmed, callback);
                        }
                    });
                }
            }
        }
    };

    private void doCallback(int responseCode, byte[] dataThatWasConfirmed, ConfirmationCallback callback) {
        switch (responseCode) {
            case 0: {
                callback.onConfirmedByUser(dataThatWasConfirmed);
                break;
            }
            case 1: {
                callback.onDismissedByUser();
                break;
            }
            case 2: {
                callback.onDismissedByApplication();
                break;
            }
            case 5: {
                callback.onError(new Exception("System error returned by ConfirmationUI."));
                break;
            }
            default: {
                callback.onError(new Exception("Unexpected responseCode=" + responseCode + " from onConfirmtionPromptCompleted() callback."));
            }
        }
    }

    private ConfirmationDialog(CharSequence promptText, byte[] extraData) {
        this.mPromptText = promptText;
        this.mExtraData = extraData;
    }

    public void presentPrompt(Executor executor, ConfirmationCallback callback) throws ConfirmationAlreadyPresentingException, ConfirmationNotAvailableException {
        if (this.mCallback != null) {
            throw new ConfirmationAlreadyPresentingException();
        }
        this.mCallback = callback;
        this.mExecutor = executor;
        int uiOptionsAsFlags = 0;
        String locale = Locale.getDefault().toLanguageTag();
        int responseCode = this.mKeyStore.presentConfirmationPrompt(this.mCallbackBinder, this.mPromptText.toString(), this.mExtraData, locale, uiOptionsAsFlags);
        switch (responseCode) {
            case 0: {
                return;
            }
            case 3: {
                throw new ConfirmationAlreadyPresentingException();
            }
            case 6: {
                throw new ConfirmationNotAvailableException();
            }
            case 65536: {
                throw new IllegalArgumentException();
            }
        }
        Log.w(TAG, "Unexpected responseCode=" + responseCode + " from presentConfirmationPrompt() call.");
        throw new IllegalArgumentException();
    }

    public void cancelPrompt() {
        int responseCode = this.mKeyStore.cancelConfirmationPrompt(this.mCallbackBinder);
        if (responseCode == 0) {
            return;
        }
        if (responseCode == 3) {
            throw new IllegalStateException();
        }
        Log.w(TAG, "Unexpected responseCode=" + responseCode + " from cancelConfirmationPrompt() call.");
        throw new IllegalStateException();
    }

    public static boolean isSupported() {
        return true;
    }

    public static class Builder {
        private CharSequence mPromptText;
        private byte[] mExtraData;

        public Builder setPromptText(CharSequence promptText) {
            this.mPromptText = promptText;
            return this;
        }

        public Builder setExtraData(byte[] extraData) {
            this.mExtraData = extraData;
            return this;
        }

        public ConfirmationDialog build(Context context) {
            if (TextUtils.isEmpty(this.mPromptText)) {
                throw new IllegalArgumentException("prompt text must be set and non-empty");
            }
            if (this.mExtraData == null) {
                throw new IllegalArgumentException("extraData must be set");
            }
            return new ConfirmationDialog(this.mPromptText, this.mExtraData);
        }
    }
}

