/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.security.keymaster.KeyCharacteristics;
import android.security.keymaster.KeymasterArguments;
import android.security.keystore.AndroidKeyStoreCipherSpiBase;
import android.security.keystore.AndroidKeyStoreKey;
import android.security.keystore.AndroidKeyStorePrivateKey;
import android.security.keystore.AndroidKeyStorePublicKey;
import android.security.keystore.KeyProperties;
import android.security.keystore.KeymasterUtils;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

abstract class AndroidKeyStoreRSACipherSpi
extends AndroidKeyStoreCipherSpiBase {
    private final int mKeymasterPadding;
    private int mKeymasterPaddingOverride;
    private int mModulusSizeBytes = -1;

    AndroidKeyStoreRSACipherSpi(int keymasterPadding) {
        this.mKeymasterPadding = keymasterPadding;
    }

    @Override
    protected final void initKey(int opmode, Key key) throws InvalidKeyException {
        AndroidKeyStoreKey keystoreKey;
        block19: {
            block18: {
                if (key == null) {
                    throw new InvalidKeyException("Unsupported key: null");
                }
                if (!"RSA".equalsIgnoreCase(key.getAlgorithm())) {
                    throw new InvalidKeyException("Unsupported key algorithm: " + key.getAlgorithm() + ". Only " + "RSA" + " supported");
                }
                if (key instanceof AndroidKeyStorePrivateKey) {
                    keystoreKey = (AndroidKeyStoreKey)key;
                } else if (key instanceof AndroidKeyStorePublicKey) {
                    keystoreKey = (AndroidKeyStoreKey)key;
                } else {
                    throw new InvalidKeyException("Unsupported key type: " + key);
                }
                if (!(keystoreKey instanceof PrivateKey)) break block18;
                switch (opmode) {
                    case 2: 
                    case 4: {
                        break block19;
                    }
                    case 1: 
                    case 3: {
                        if (!this.adjustConfigForEncryptingWithPrivateKey()) {
                            throw new InvalidKeyException("RSA private keys cannot be used with " + AndroidKeyStoreRSACipherSpi.opmodeToString(opmode) + " and padding " + KeyProperties.EncryptionPadding.fromKeymaster(this.mKeymasterPadding) + ". Only RSA public keys supported for this mode");
                        }
                        break block19;
                    }
                    default: {
                        throw new InvalidKeyException("RSA private keys cannot be used with opmode: " + opmode);
                    }
                }
            }
            switch (opmode) {
                case 1: 
                case 3: {
                    break;
                }
                case 2: 
                case 4: {
                    throw new InvalidKeyException("RSA public keys cannot be used with " + AndroidKeyStoreRSACipherSpi.opmodeToString(opmode) + " and padding " + KeyProperties.EncryptionPadding.fromKeymaster(this.mKeymasterPadding) + ". Only RSA private keys supported for this opmode.");
                }
                default: {
                    throw new InvalidKeyException("RSA public keys cannot be used with " + AndroidKeyStoreRSACipherSpi.opmodeToString(opmode));
                }
            }
        }
        KeyCharacteristics keyCharacteristics = new KeyCharacteristics();
        int errorCode = this.getKeyStore().getKeyCharacteristics(keystoreKey.getAlias(), null, null, keystoreKey.getUid(), keyCharacteristics);
        if (errorCode != 1) {
            throw this.getKeyStore().getInvalidKeyException(keystoreKey.getAlias(), keystoreKey.getUid(), errorCode);
        }
        long keySizeBits = keyCharacteristics.getUnsignedInt(0x30000003, -1L);
        if (keySizeBits == -1L) {
            throw new InvalidKeyException("Size of key not known");
        }
        if (keySizeBits > Integer.MAX_VALUE) {
            throw new InvalidKeyException("Key too large: " + keySizeBits + " bits");
        }
        this.mModulusSizeBytes = (int)((keySizeBits + 7L) / 8L);
        this.setKey(keystoreKey);
    }

    protected boolean adjustConfigForEncryptingWithPrivateKey() {
        return false;
    }

    @Override
    protected final void resetAll() {
        this.mModulusSizeBytes = -1;
        this.mKeymasterPaddingOverride = -1;
        super.resetAll();
    }

    @Override
    protected final void resetWhilePreservingInitState() {
        super.resetWhilePreservingInitState();
    }

    @Override
    protected void addAlgorithmSpecificParametersToBegin(KeymasterArguments keymasterArgs) {
        keymasterArgs.addEnum(0x10000002, 1);
        int keymasterPadding = this.getKeymasterPaddingOverride();
        if (keymasterPadding == -1) {
            keymasterPadding = this.mKeymasterPadding;
        }
        keymasterArgs.addEnum(0x20000006, keymasterPadding);
        int purposeOverride = this.getKeymasterPurposeOverride();
        if (purposeOverride != -1 && (purposeOverride == 2 || purposeOverride == 3)) {
            keymasterArgs.addEnum(0x20000005, 0);
        }
    }

    @Override
    protected void loadAlgorithmSpecificParametersFromBeginResult(KeymasterArguments keymasterArgs) {
    }

    @Override
    protected final int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected final byte[] engineGetIV() {
        return null;
    }

    @Override
    protected final int engineGetOutputSize(int inputLen) {
        return this.getModulusSizeBytes();
    }

    protected final int getModulusSizeBytes() {
        if (this.mModulusSizeBytes == -1) {
            throw new IllegalStateException("Not initialized");
        }
        return this.mModulusSizeBytes;
    }

    protected final void setKeymasterPaddingOverride(int keymasterPadding) {
        this.mKeymasterPaddingOverride = keymasterPadding;
    }

    protected final int getKeymasterPaddingOverride() {
        return this.mKeymasterPaddingOverride;
    }

    public static class OAEPWithSHA512AndMGF1Padding
    extends OAEPWithMGF1Padding {
        public OAEPWithSHA512AndMGF1Padding() {
            super(6);
        }
    }

    public static class OAEPWithSHA384AndMGF1Padding
    extends OAEPWithMGF1Padding {
        public OAEPWithSHA384AndMGF1Padding() {
            super(5);
        }
    }

    public static class OAEPWithSHA256AndMGF1Padding
    extends OAEPWithMGF1Padding {
        public OAEPWithSHA256AndMGF1Padding() {
            super(4);
        }
    }

    public static class OAEPWithSHA224AndMGF1Padding
    extends OAEPWithMGF1Padding {
        public OAEPWithSHA224AndMGF1Padding() {
            super(3);
        }
    }

    public static class OAEPWithSHA1AndMGF1Padding
    extends OAEPWithMGF1Padding {
        public OAEPWithSHA1AndMGF1Padding() {
            super(2);
        }
    }

    static abstract class OAEPWithMGF1Padding
    extends AndroidKeyStoreRSACipherSpi {
        private static final String MGF_ALGORITGM_MGF1 = "MGF1";
        private int mKeymasterDigest = -1;
        private int mDigestOutputSizeBytes;

        OAEPWithMGF1Padding(int keymasterDigest) {
            super(2);
            this.mKeymasterDigest = keymasterDigest;
            this.mDigestOutputSizeBytes = (KeymasterUtils.getDigestOutputSizeBits(keymasterDigest) + 7) / 8;
        }

        @Override
        protected final void initAlgorithmSpecificParameters() throws InvalidKeyException {
        }

        @Override
        protected final void initAlgorithmSpecificParameters(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            int keymasterDigest;
            if (params == null) {
                return;
            }
            if (!(params instanceof OAEPParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Unsupported parameter spec: " + params + ". Only OAEPParameterSpec supported");
            }
            OAEPParameterSpec spec = (OAEPParameterSpec)params;
            if (!MGF_ALGORITGM_MGF1.equalsIgnoreCase(spec.getMGFAlgorithm())) {
                throw new InvalidAlgorithmParameterException("Unsupported MGF: " + spec.getMGFAlgorithm() + ". Only " + MGF_ALGORITGM_MGF1 + " supported");
            }
            String jcaDigest = spec.getDigestAlgorithm();
            try {
                keymasterDigest = KeyProperties.Digest.toKeymaster(jcaDigest);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidAlgorithmParameterException("Unsupported digest: " + jcaDigest, e);
            }
            switch (keymasterDigest) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                default: {
                    throw new InvalidAlgorithmParameterException("Unsupported digest: " + jcaDigest);
                }
            }
            AlgorithmParameterSpec mgfParams = spec.getMGFParameters();
            if (mgfParams == null) {
                throw new InvalidAlgorithmParameterException("MGF parameters must be provided");
            }
            if (!(mgfParams instanceof MGF1ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Unsupported MGF parameters: " + mgfParams + ". Only MGF1ParameterSpec supported");
            }
            MGF1ParameterSpec mgfSpec = (MGF1ParameterSpec)mgfParams;
            String mgf1JcaDigest = mgfSpec.getDigestAlgorithm();
            if (!"SHA-1".equalsIgnoreCase(mgf1JcaDigest)) {
                throw new InvalidAlgorithmParameterException("Unsupported MGF1 digest: " + mgf1JcaDigest + ". Only " + "SHA-1" + " supported");
            }
            PSource pSource = spec.getPSource();
            if (!(pSource instanceof PSource.PSpecified)) {
                throw new InvalidAlgorithmParameterException("Unsupported source of encoding input P: " + pSource + ". Only pSpecifiedEmpty (PSource.PSpecified.DEFAULT) supported");
            }
            PSource.PSpecified pSourceSpecified = (PSource.PSpecified)pSource;
            byte[] pSourceValue = pSourceSpecified.getValue();
            if (pSourceValue != null && pSourceValue.length > 0) {
                throw new InvalidAlgorithmParameterException("Unsupported source of encoding input P: " + pSource + ". Only pSpecifiedEmpty (PSource.PSpecified.DEFAULT) supported");
            }
            this.mKeymasterDigest = keymasterDigest;
            this.mDigestOutputSizeBytes = (KeymasterUtils.getDigestOutputSizeBits(keymasterDigest) + 7) / 8;
        }

        @Override
        protected final void initAlgorithmSpecificParameters(AlgorithmParameters params) throws InvalidAlgorithmParameterException {
            OAEPParameterSpec spec;
            if (params == null) {
                return;
            }
            try {
                spec = params.getParameterSpec(OAEPParameterSpec.class);
            }
            catch (InvalidParameterSpecException e) {
                throw new InvalidAlgorithmParameterException("OAEP parameters required, but not found in parameters: " + params, e);
            }
            if (spec == null) {
                throw new InvalidAlgorithmParameterException("OAEP parameters required, but not provided in parameters: " + params);
            }
            this.initAlgorithmSpecificParameters(spec);
        }

        @Override
        protected final AlgorithmParameters engineGetParameters() {
            OAEPParameterSpec spec = new OAEPParameterSpec(KeyProperties.Digest.fromKeymaster(this.mKeymasterDigest), MGF_ALGORITGM_MGF1, MGF1ParameterSpec.SHA1, PSource.PSpecified.DEFAULT);
            try {
                AlgorithmParameters params = AlgorithmParameters.getInstance("OAEP");
                params.init(spec);
                return params;
            }
            catch (NoSuchAlgorithmException e) {
                throw new ProviderException("Failed to obtain OAEP AlgorithmParameters", e);
            }
            catch (InvalidParameterSpecException e) {
                throw new ProviderException("Failed to initialize OAEP AlgorithmParameters with an IV", e);
            }
        }

        @Override
        protected final void addAlgorithmSpecificParametersToBegin(KeymasterArguments keymasterArgs) {
            super.addAlgorithmSpecificParametersToBegin(keymasterArgs);
            keymasterArgs.addEnum(0x20000005, this.mKeymasterDigest);
        }

        @Override
        protected final void loadAlgorithmSpecificParametersFromBeginResult(KeymasterArguments keymasterArgs) {
            super.loadAlgorithmSpecificParametersFromBeginResult(keymasterArgs);
        }

        @Override
        protected final int getAdditionalEntropyAmountForBegin() {
            return 0;
        }

        @Override
        protected final int getAdditionalEntropyAmountForFinish() {
            return this.isEncrypting() ? this.mDigestOutputSizeBytes : 0;
        }
    }

    public static final class PKCS1Padding
    extends AndroidKeyStoreRSACipherSpi {
        public PKCS1Padding() {
            super(4);
        }

        @Override
        protected boolean adjustConfigForEncryptingWithPrivateKey() {
            this.setKeymasterPurposeOverride(2);
            this.setKeymasterPaddingOverride(5);
            return true;
        }

        @Override
        protected void initAlgorithmSpecificParameters() throws InvalidKeyException {
        }

        @Override
        protected void initAlgorithmSpecificParameters(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            if (params != null) {
                throw new InvalidAlgorithmParameterException("Unexpected parameters: " + params + ". No parameters supported");
            }
        }

        @Override
        protected void initAlgorithmSpecificParameters(AlgorithmParameters params) throws InvalidAlgorithmParameterException {
            if (params != null) {
                throw new InvalidAlgorithmParameterException("Unexpected parameters: " + params + ". No parameters supported");
            }
        }

        @Override
        protected AlgorithmParameters engineGetParameters() {
            return null;
        }

        @Override
        protected final int getAdditionalEntropyAmountForBegin() {
            return 0;
        }

        @Override
        protected final int getAdditionalEntropyAmountForFinish() {
            return this.isEncrypting() ? this.getModulusSizeBytes() : 0;
        }
    }

    public static final class NoPadding
    extends AndroidKeyStoreRSACipherSpi {
        public NoPadding() {
            super(1);
        }

        @Override
        protected boolean adjustConfigForEncryptingWithPrivateKey() {
            this.setKeymasterPurposeOverride(2);
            return true;
        }

        @Override
        protected void initAlgorithmSpecificParameters() throws InvalidKeyException {
        }

        @Override
        protected void initAlgorithmSpecificParameters(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            if (params != null) {
                throw new InvalidAlgorithmParameterException("Unexpected parameters: " + params + ". No parameters supported");
            }
        }

        @Override
        protected void initAlgorithmSpecificParameters(AlgorithmParameters params) throws InvalidAlgorithmParameterException {
            if (params != null) {
                throw new InvalidAlgorithmParameterException("Unexpected parameters: " + params + ". No parameters supported");
            }
        }

        @Override
        protected AlgorithmParameters engineGetParameters() {
            return null;
        }

        @Override
        protected final int getAdditionalEntropyAmountForBegin() {
            return 0;
        }

        @Override
        protected final int getAdditionalEntropyAmountForFinish() {
            return 0;
        }
    }
}

