/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.security.keystore.KeychainProtectionParams;
import android.security.keystore.KeychainSnapshot;
import android.security.keystore.WrappedApplicationKey;
import android.security.keystore.recovery.KeyChainProtectionParams;
import android.security.keystore.recovery.KeyChainSnapshot;
import android.security.keystore.recovery.KeyDerivationParams;
import android.security.keystore.recovery.WrappedApplicationKey;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

class BackwardsCompat {
    BackwardsCompat() {
    }

    static KeychainProtectionParams toLegacyKeychainProtectionParams(KeyChainProtectionParams keychainProtectionParams) {
        return new KeychainProtectionParams.Builder().setUserSecretType(keychainProtectionParams.getUserSecretType()).setSecret(keychainProtectionParams.getSecret()).setLockScreenUiFormat(keychainProtectionParams.getLockScreenUiFormat()).setKeyDerivationParams(BackwardsCompat.toLegacyKeyDerivationParams(keychainProtectionParams.getKeyDerivationParams())).build();
    }

    static android.security.keystore.KeyDerivationParams toLegacyKeyDerivationParams(KeyDerivationParams keyDerivationParams) {
        return new android.security.keystore.KeyDerivationParams(keyDerivationParams.getAlgorithm(), keyDerivationParams.getSalt());
    }

    static WrappedApplicationKey toLegacyWrappedApplicationKey(android.security.keystore.recovery.WrappedApplicationKey wrappedApplicationKey) {
        return new WrappedApplicationKey.Builder().setAlias(wrappedApplicationKey.getAlias()).setEncryptedKeyMaterial(wrappedApplicationKey.getEncryptedKeyMaterial()).build();
    }

    static KeyDerivationParams fromLegacyKeyDerivationParams(android.security.keystore.KeyDerivationParams keyDerivationParams) {
        return new KeyDerivationParams(keyDerivationParams.getAlgorithm(), keyDerivationParams.getSalt());
    }

    static android.security.keystore.recovery.WrappedApplicationKey fromLegacyWrappedApplicationKey(WrappedApplicationKey wrappedApplicationKey) {
        return new WrappedApplicationKey.Builder().setAlias(wrappedApplicationKey.getAlias()).setEncryptedKeyMaterial(wrappedApplicationKey.getEncryptedKeyMaterial()).build();
    }

    static List<android.security.keystore.recovery.WrappedApplicationKey> fromLegacyWrappedApplicationKeys(List<WrappedApplicationKey> wrappedApplicationKeys) {
        return BackwardsCompat.map(wrappedApplicationKeys, BackwardsCompat::fromLegacyWrappedApplicationKey);
    }

    static List<KeyChainProtectionParams> fromLegacyKeychainProtectionParams(List<KeychainProtectionParams> keychainProtectionParams) {
        return BackwardsCompat.map(keychainProtectionParams, BackwardsCompat::fromLegacyKeychainProtectionParam);
    }

    static KeyChainProtectionParams fromLegacyKeychainProtectionParam(KeychainProtectionParams keychainProtectionParams) {
        return new KeyChainProtectionParams.Builder().setUserSecretType(keychainProtectionParams.getUserSecretType()).setSecret(keychainProtectionParams.getSecret()).setLockScreenUiFormat(keychainProtectionParams.getLockScreenUiFormat()).setKeyDerivationParams(BackwardsCompat.fromLegacyKeyDerivationParams(keychainProtectionParams.getKeyDerivationParams())).build();
    }

    static KeychainSnapshot toLegacyKeychainSnapshot(KeyChainSnapshot keychainSnapshot) {
        return new KeychainSnapshot.Builder().setCounterId(keychainSnapshot.getCounterId()).setEncryptedRecoveryKeyBlob(keychainSnapshot.getEncryptedRecoveryKeyBlob()).setTrustedHardwarePublicKey(keychainSnapshot.getTrustedHardwarePublicKey()).setSnapshotVersion(keychainSnapshot.getSnapshotVersion()).setMaxAttempts(keychainSnapshot.getMaxAttempts()).setServerParams(keychainSnapshot.getServerParams()).setKeychainProtectionParams(BackwardsCompat.map(keychainSnapshot.getKeyChainProtectionParams(), BackwardsCompat::toLegacyKeychainProtectionParams)).setWrappedApplicationKeys(BackwardsCompat.map(keychainSnapshot.getWrappedApplicationKeys(), BackwardsCompat::toLegacyWrappedApplicationKey)).build();
    }

    static <A, B> List<B> map(List<A> as, Function<A, B> f) {
        ArrayList<B> bs = new ArrayList<B>(as.size());
        for (A a : as) {
            bs.add(f.apply(a));
        }
        return bs;
    }
}

