/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.os.Parcel;
import android.os.Parcelable;
import android.security.keystore.KeyDerivationParams;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;

public final class KeychainProtectionParams
implements Parcelable {
    public static final int TYPE_LOCKSCREEN = 100;
    public static final int TYPE_CUSTOM_PASSWORD = 101;
    public static final int TYPE_PIN = 1;
    public static final int TYPE_PASSWORD = 2;
    public static final int TYPE_PATTERN = 3;
    private Integer mUserSecretType;
    private Integer mLockScreenUiFormat;
    private KeyDerivationParams mKeyDerivationParams;
    private byte[] mSecret;
    public static final Parcelable.Creator<KeychainProtectionParams> CREATOR = new Parcelable.Creator<KeychainProtectionParams>(){

        @Override
        public KeychainProtectionParams createFromParcel(Parcel in) {
            return new KeychainProtectionParams(in);
        }

        public KeychainProtectionParams[] newArray(int length) {
            return new KeychainProtectionParams[length];
        }
    };

    public KeychainProtectionParams(int userSecretType, int lockScreenUiFormat, KeyDerivationParams keyDerivationParams, byte[] secret) {
        this.mUserSecretType = userSecretType;
        this.mLockScreenUiFormat = lockScreenUiFormat;
        this.mKeyDerivationParams = Preconditions.checkNotNull(keyDerivationParams);
        this.mSecret = Preconditions.checkNotNull(secret);
    }

    private KeychainProtectionParams() {
    }

    public int getUserSecretType() {
        return this.mUserSecretType;
    }

    public int getLockScreenUiFormat() {
        return this.mLockScreenUiFormat;
    }

    public KeyDerivationParams getKeyDerivationParams() {
        return this.mKeyDerivationParams;
    }

    public byte[] getSecret() {
        return this.mSecret;
    }

    protected void finalize() throws Throwable {
        this.clearSecret();
        super.finalize();
    }

    public void clearSecret() {
        Arrays.fill(this.mSecret, (byte)0);
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mUserSecretType);
        out.writeInt(this.mLockScreenUiFormat);
        out.writeTypedObject(this.mKeyDerivationParams, flags);
        out.writeByteArray(this.mSecret);
    }

    protected KeychainProtectionParams(Parcel in) {
        this.mUserSecretType = in.readInt();
        this.mLockScreenUiFormat = in.readInt();
        this.mKeyDerivationParams = in.readTypedObject(KeyDerivationParams.CREATOR);
        this.mSecret = in.createByteArray();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    static /* synthetic */ byte[] access$402(KeychainProtectionParams x0, byte[] x1) {
        x0.mSecret = x1;
        return x1;
    }

    public static class Builder {
        private KeychainProtectionParams mInstance = new KeychainProtectionParams();

        public Builder setUserSecretType(int userSecretType) {
            this.mInstance.mUserSecretType = userSecretType;
            return this;
        }

        public Builder setLockScreenUiFormat(int lockScreenUiFormat) {
            this.mInstance.mLockScreenUiFormat = lockScreenUiFormat;
            return this;
        }

        public Builder setKeyDerivationParams(KeyDerivationParams keyDerivationParams) {
            this.mInstance.mKeyDerivationParams = keyDerivationParams;
            return this;
        }

        public Builder setSecret(byte[] secret) {
            KeychainProtectionParams.access$402(this.mInstance, secret);
            return this;
        }

        public KeychainProtectionParams build() {
            if (this.mInstance.mUserSecretType == null) {
                this.mInstance.mUserSecretType = 100;
            }
            Preconditions.checkNotNull(this.mInstance.mLockScreenUiFormat);
            Preconditions.checkNotNull(this.mInstance.mKeyDerivationParams);
            if (this.mInstance.mSecret == null) {
                KeychainProtectionParams.access$402(this.mInstance, new byte[0]);
            }
            return this.mInstance;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LockScreenUiFormat {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UserSecretType {
    }
}

