/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.os.Parcel;
import android.os.Parcelable;
import android.security.keystore.KeychainProtectionParams;
import android.security.keystore.WrappedApplicationKey;
import com.android.internal.util.Preconditions;
import java.util.List;

public final class KeychainSnapshot
implements Parcelable {
    private static final int DEFAULT_MAX_ATTEMPTS = 10;
    private static final long DEFAULT_COUNTER_ID = 1L;
    private int mSnapshotVersion;
    private int mMaxAttempts = 10;
    private long mCounterId = 1L;
    private byte[] mServerParams;
    private byte[] mPublicKey;
    private List<KeychainProtectionParams> mKeychainProtectionParams;
    private List<WrappedApplicationKey> mEntryRecoveryData;
    private byte[] mEncryptedRecoveryKeyBlob;
    public static final Parcelable.Creator<KeychainSnapshot> CREATOR = new Parcelable.Creator<KeychainSnapshot>(){

        @Override
        public KeychainSnapshot createFromParcel(Parcel in) {
            return new KeychainSnapshot(in);
        }

        public KeychainSnapshot[] newArray(int length) {
            return new KeychainSnapshot[length];
        }
    };

    public KeychainSnapshot(int snapshotVersion, List<KeychainProtectionParams> keychainProtectionParams, List<WrappedApplicationKey> wrappedApplicationKeys, byte[] encryptedRecoveryKeyBlob) {
        this.mSnapshotVersion = snapshotVersion;
        this.mKeychainProtectionParams = Preconditions.checkCollectionElementsNotNull(keychainProtectionParams, "keychainProtectionParams");
        this.mEntryRecoveryData = Preconditions.checkCollectionElementsNotNull(wrappedApplicationKeys, "wrappedApplicationKeys");
        this.mEncryptedRecoveryKeyBlob = Preconditions.checkNotNull(encryptedRecoveryKeyBlob);
    }

    private KeychainSnapshot() {
    }

    public int getSnapshotVersion() {
        return this.mSnapshotVersion;
    }

    public int getMaxAttempts() {
        return this.mMaxAttempts;
    }

    public long getCounterId() {
        return this.mCounterId;
    }

    public byte[] getServerParams() {
        return this.mServerParams;
    }

    public byte[] getTrustedHardwarePublicKey() {
        return this.mPublicKey;
    }

    public List<KeychainProtectionParams> getKeychainProtectionParams() {
        return this.mKeychainProtectionParams;
    }

    public List<WrappedApplicationKey> getWrappedApplicationKeys() {
        return this.mEntryRecoveryData;
    }

    public byte[] getEncryptedRecoveryKeyBlob() {
        return this.mEncryptedRecoveryKeyBlob;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mSnapshotVersion);
        out.writeTypedList(this.mKeychainProtectionParams);
        out.writeByteArray(this.mEncryptedRecoveryKeyBlob);
        out.writeTypedList(this.mEntryRecoveryData);
    }

    protected KeychainSnapshot(Parcel in) {
        this.mSnapshotVersion = in.readInt();
        this.mKeychainProtectionParams = in.createTypedArrayList(KeychainProtectionParams.CREATOR);
        this.mEncryptedRecoveryKeyBlob = in.createByteArray();
        this.mEntryRecoveryData = in.createTypedArrayList(WrappedApplicationKey.CREATOR);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    static /* synthetic */ byte[] access$402(KeychainSnapshot x0, byte[] x1) {
        x0.mServerParams = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$502(KeychainSnapshot x0, byte[] x1) {
        x0.mPublicKey = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$802(KeychainSnapshot x0, byte[] x1) {
        x0.mEncryptedRecoveryKeyBlob = x1;
        return x1;
    }

    public static class Builder {
        private KeychainSnapshot mInstance = new KeychainSnapshot();

        public Builder setSnapshotVersion(int snapshotVersion) {
            this.mInstance.mSnapshotVersion = snapshotVersion;
            return this;
        }

        public Builder setMaxAttempts(int maxAttempts) {
            this.mInstance.mMaxAttempts = maxAttempts;
            return this;
        }

        public Builder setCounterId(long counterId) {
            this.mInstance.mCounterId = counterId;
            return this;
        }

        public Builder setServerParams(byte[] serverParams) {
            KeychainSnapshot.access$402(this.mInstance, serverParams);
            return this;
        }

        public Builder setTrustedHardwarePublicKey(byte[] publicKey) {
            KeychainSnapshot.access$502(this.mInstance, publicKey);
            return this;
        }

        public Builder setKeychainProtectionParams(List<KeychainProtectionParams> recoveryMetadata) {
            this.mInstance.mKeychainProtectionParams = recoveryMetadata;
            return this;
        }

        public Builder setWrappedApplicationKeys(List<WrappedApplicationKey> entryRecoveryData) {
            this.mInstance.mEntryRecoveryData = entryRecoveryData;
            return this;
        }

        public Builder setEncryptedRecoveryKeyBlob(byte[] encryptedRecoveryKeyBlob) {
            KeychainSnapshot.access$802(this.mInstance, encryptedRecoveryKeyBlob);
            return this;
        }

        public KeychainSnapshot build() {
            Preconditions.checkCollectionElementsNotNull(this.mInstance.mKeychainProtectionParams, "recoveryMetadata");
            Preconditions.checkCollectionElementsNotNull(this.mInstance.mEntryRecoveryData, "entryRecoveryData");
            Preconditions.checkNotNull(this.mInstance.mEncryptedRecoveryKeyBlob);
            Preconditions.checkNotNull(this.mInstance.mServerParams);
            Preconditions.checkNotNull(this.mInstance.mPublicKey);
            return this.mInstance;
        }
    }
}

