/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.hardware.fingerprint.FingerprintManager;
import android.security.GateKeeper;
import android.security.KeyStore;
import android.security.keymaster.KeymasterArguments;
import android.security.keystore.KeyProperties;
import com.android.internal.util.ArrayUtils;
import java.security.ProviderException;

public abstract class KeymasterUtils {
    private KeymasterUtils() {
    }

    public static int getDigestOutputSizeBits(int keymasterDigest) {
        switch (keymasterDigest) {
            case 0: {
                return -1;
            }
            case 1: {
                return 128;
            }
            case 2: {
                return 160;
            }
            case 3: {
                return 224;
            }
            case 4: {
                return 256;
            }
            case 5: {
                return 384;
            }
            case 6: {
                return 512;
            }
        }
        throw new IllegalArgumentException("Unknown digest: " + keymasterDigest);
    }

    public static boolean isKeymasterBlockModeIndCpaCompatibleWithSymmetricCrypto(int keymasterBlockMode) {
        switch (keymasterBlockMode) {
            case 1: {
                return false;
            }
            case 2: 
            case 3: 
            case 32: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unsupported block mode: " + keymasterBlockMode);
    }

    public static boolean isKeymasterPaddingSchemeIndCpaCompatibleWithAsymmetricCrypto(int keymasterPadding) {
        switch (keymasterPadding) {
            case 1: {
                return false;
            }
            case 2: 
            case 4: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unsupported asymmetric encryption padding scheme: " + keymasterPadding);
    }

    public static void addUserAuthArgs(KeymasterArguments args, boolean userAuthenticationRequired, int userAuthenticationValidityDurationSeconds, boolean userAuthenticationValidWhileOnBody, boolean invalidatedByBiometricEnrollment, long boundToSpecificSecureUserId, boolean userConfirmationRequired) {
        if (userConfirmationRequired) {
            args.addBoolean(1879048700);
        }
        if (!userAuthenticationRequired) {
            args.addBoolean(1879048695);
            return;
        }
        if (userAuthenticationValidityDurationSeconds == -1) {
            long fingerprintOnlySid;
            FingerprintManager fingerprintManager = KeyStore.getApplicationContext().getSystemService(FingerprintManager.class);
            long l = fingerprintOnlySid = fingerprintManager != null ? fingerprintManager.getAuthenticatorId() : 0L;
            if (fingerprintOnlySid == 0L) {
                throw new IllegalStateException("At least one fingerprint must be enrolled to create keys requiring user authentication for every use");
            }
            long sid = boundToSpecificSecureUserId != 0L ? boundToSpecificSecureUserId : (invalidatedByBiometricEnrollment ? fingerprintOnlySid : KeymasterUtils.getRootSid());
            args.addUnsignedLong(-1610612234, KeymasterArguments.toUint64(sid));
            args.addEnum(268435960, 2);
            if (userAuthenticationValidWhileOnBody) {
                throw new ProviderException("Key validity extension while device is on-body is not supported for keys requiring fingerprint authentication");
            }
        } else {
            long sid = boundToSpecificSecureUserId != 0L ? boundToSpecificSecureUserId : KeymasterUtils.getRootSid();
            args.addUnsignedLong(-1610612234, KeymasterArguments.toUint64(sid));
            args.addEnum(268435960, 3);
            args.addUnsignedInt(805306873, userAuthenticationValidityDurationSeconds);
            if (userAuthenticationValidWhileOnBody) {
                args.addBoolean(1879048698);
            }
        }
    }

    public static void addMinMacLengthAuthorizationIfNecessary(KeymasterArguments args, int keymasterAlgorithm, int[] keymasterBlockModes, int[] keymasterDigests) {
        switch (keymasterAlgorithm) {
            case 32: {
                if (!ArrayUtils.contains(keymasterBlockModes, 32)) break;
                args.addUnsignedInt(0x30000008, 96L);
                break;
            }
            case 128: {
                if (keymasterDigests.length != 1) {
                    throw new ProviderException("Unsupported number of authorized digests for HMAC key: " + keymasterDigests.length + ". Exactly one digest must be authorized");
                }
                int keymasterDigest = keymasterDigests[0];
                int digestOutputSizeBits = KeymasterUtils.getDigestOutputSizeBits(keymasterDigest);
                if (digestOutputSizeBits == -1) {
                    throw new ProviderException("HMAC key authorized for unsupported digest: " + KeyProperties.Digest.fromKeymaster(keymasterDigest));
                }
                args.addUnsignedInt(0x30000008, digestOutputSizeBits);
            }
        }
    }

    private static long getRootSid() {
        long rootSid = GateKeeper.getSecureUserId();
        if (rootSid == 0L) {
            throw new IllegalStateException("Secure lock screen must be enabled to create keys requiring user authentication");
        }
        return rootSid;
    }
}

