/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.app.PendingIntent;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.ServiceSpecificException;
import android.security.keystore.BackwardsCompat;
import android.security.keystore.BadCertificateFormatException;
import android.security.keystore.DecryptionFailedException;
import android.security.keystore.InternalRecoveryServiceException;
import android.security.keystore.KeychainProtectionParams;
import android.security.keystore.KeychainSnapshot;
import android.security.keystore.LockScreenRequiredException;
import android.security.keystore.RecoveryClaim;
import android.security.keystore.RecoverySession;
import android.security.keystore.SessionExpiredException;
import android.security.keystore.WrappedApplicationKey;
import android.util.Log;
import com.android.internal.widget.ILockSettings;
import java.util.List;
import java.util.Map;

public class RecoveryController {
    private static final String TAG = "RecoveryController";
    public static final int RECOVERY_STATUS_SYNCED = 0;
    public static final int RECOVERY_STATUS_SYNC_IN_PROGRESS = 1;
    public static final int RECOVERY_STATUS_MISSING_ACCOUNT = 2;
    public static final int RECOVERY_STATUS_PERMANENT_FAILURE = 3;
    public static final int ERROR_NO_SNAPSHOT_PENDING = 21;
    public static final int ERROR_SERVICE_INTERNAL_ERROR = 22;
    public static final int ERROR_INSECURE_USER = 23;
    public static final int ERROR_SESSION_EXPIRED = 24;
    public static final int ERROR_BAD_CERTIFICATE_FORMAT = 25;
    public static final int ERROR_DECRYPTION_FAILED = 26;
    private final ILockSettings mBinder;

    private RecoveryController(ILockSettings binder) {
        this.mBinder = binder;
    }

    public static RecoveryController getInstance() {
        ILockSettings lockSettings = ILockSettings.Stub.asInterface(ServiceManager.getService("lock_settings"));
        return new RecoveryController(lockSettings);
    }

    public void initRecoveryService(String rootCertificateAlias, byte[] signedPublicKeyList) throws BadCertificateFormatException, InternalRecoveryServiceException {
        try {
            this.mBinder.initRecoveryService(rootCertificateAlias, signedPublicKeyList);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 25) {
                throw new BadCertificateFormatException(e.getMessage());
            }
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public KeychainSnapshot getRecoveryData(byte[] account) throws InternalRecoveryServiceException {
        try {
            return BackwardsCompat.toLegacyKeychainSnapshot(this.mBinder.getKeyChainSnapshot());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 21) {
                return null;
            }
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public void setSnapshotCreatedPendingIntent(PendingIntent intent) throws InternalRecoveryServiceException {
        try {
            this.mBinder.setSnapshotCreatedPendingIntent(intent);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public Map<byte[], Integer> getRecoverySnapshotVersions() throws InternalRecoveryServiceException {
        try {
            Map result = this.mBinder.getRecoverySnapshotVersions();
            return result;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public void setServerParams(byte[] serverParams) throws InternalRecoveryServiceException {
        try {
            this.mBinder.setServerParams(serverParams);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public void setRecoveryStatus(String packageName, String[] aliases, int status) throws PackageManager.NameNotFoundException, InternalRecoveryServiceException {
        try {
            this.mBinder.setRecoveryStatus(packageName, aliases, status);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public Map<String, Integer> getRecoveryStatus() throws InternalRecoveryServiceException {
        try {
            Map result = this.mBinder.getRecoveryStatus(null);
            return result;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public void setRecoverySecretTypes(int[] secretTypes) throws InternalRecoveryServiceException {
        try {
            this.mBinder.setRecoverySecretTypes(secretTypes);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public int[] getRecoverySecretTypes() throws InternalRecoveryServiceException {
        try {
            return this.mBinder.getRecoverySecretTypes();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public int[] getPendingRecoverySecretTypes() throws InternalRecoveryServiceException {
        try {
            return this.mBinder.getPendingRecoverySecretTypes();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public RecoveryClaim startRecoverySession(byte[] verifierPublicKey, byte[] vaultParams, byte[] vaultChallenge, List<KeychainProtectionParams> secrets) throws BadCertificateFormatException, InternalRecoveryServiceException {
        try {
            RecoverySession recoverySession = RecoverySession.newInstance(this);
            byte[] recoveryClaim = this.mBinder.startRecoverySession(recoverySession.getSessionId(), verifierPublicKey, vaultParams, vaultChallenge, BackwardsCompat.fromLegacyKeychainProtectionParams(secrets));
            return new RecoveryClaim(recoverySession, recoveryClaim);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 25) {
                throw new BadCertificateFormatException(e.getMessage());
            }
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public Map<String, byte[]> recoverKeys(RecoverySession session, byte[] recoveryKeyBlob, List<WrappedApplicationKey> applicationKeys) throws SessionExpiredException, DecryptionFailedException, InternalRecoveryServiceException {
        try {
            return this.mBinder.recoverKeys(session.getSessionId(), recoveryKeyBlob, BackwardsCompat.fromLegacyWrappedApplicationKeys(applicationKeys));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 26) {
                throw new DecryptionFailedException(e.getMessage());
            }
            if (e.errorCode == 24) {
                throw new SessionExpiredException(e.getMessage());
            }
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    void closeSession(RecoverySession session) {
        try {
            this.mBinder.closeSession(session.getSessionId());
        }
        catch (RemoteException | ServiceSpecificException e) {
            Log.e(TAG, "Unexpected error trying to close session", e);
        }
    }

    public byte[] generateAndStoreKey(String alias) throws InternalRecoveryServiceException, LockScreenRequiredException {
        try {
            return this.mBinder.generateAndStoreKey(alias);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 23) {
                throw new LockScreenRequiredException(e.getMessage());
            }
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public void removeKey(String alias) throws InternalRecoveryServiceException {
        try {
            this.mBinder.removeKey(alias);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    private InternalRecoveryServiceException wrapUnexpectedServiceSpecificException(ServiceSpecificException e) {
        if (e.errorCode == 22) {
            return new InternalRecoveryServiceException(e.getMessage());
        }
        return new InternalRecoveryServiceException("Unexpected error code for method: " + e.errorCode, e);
    }
}

