/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.security.keystore.RecoveryController;
import java.security.SecureRandom;

public class RecoverySession
implements AutoCloseable {
    private static final int SESSION_ID_LENGTH_BYTES = 16;
    private final String mSessionId;
    private final RecoveryController mRecoveryController;

    private RecoverySession(RecoveryController recoveryController, String sessionId) {
        this.mRecoveryController = recoveryController;
        this.mSessionId = sessionId;
    }

    static RecoverySession newInstance(RecoveryController recoveryController) {
        return new RecoverySession(recoveryController, RecoverySession.newSessionId());
    }

    private static String newSessionId() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] sessionId = new byte[16];
        secureRandom.nextBytes(sessionId);
        StringBuilder sb = new StringBuilder();
        for (byte b : sessionId) {
            sb.append(Byte.toHexString((byte)b, (boolean)false));
        }
        return sb.toString();
    }

    String getSessionId() {
        return this.mSessionId;
    }

    @Override
    public void close() {
        this.mRecoveryController.closeSession(this);
    }
}

