/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore.recovery;

import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.ServiceSpecificException;
import android.security.KeyStore;
import android.security.keystore.AndroidKeyStoreKey;
import android.security.keystore.AndroidKeyStoreProvider;
import android.security.keystore.recovery.InternalRecoveryServiceException;
import android.security.keystore.recovery.KeyChainProtectionParams;
import android.security.keystore.recovery.KeyChainSnapshot;
import android.security.keystore.recovery.LockScreenRequiredException;
import com.android.internal.widget.ILockSettings;
import java.security.Key;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@SystemApi
public class RecoveryController {
    private static final String TAG = "RecoveryController";
    public static final int RECOVERY_STATUS_SYNCED = 0;
    public static final int RECOVERY_STATUS_SYNC_IN_PROGRESS = 1;
    public static final int RECOVERY_STATUS_MISSING_ACCOUNT = 2;
    public static final int RECOVERY_STATUS_PERMANENT_FAILURE = 3;
    public static final int ERROR_NO_SNAPSHOT_PENDING = 21;
    public static final int ERROR_SERVICE_INTERNAL_ERROR = 22;
    public static final int ERROR_INSECURE_USER = 23;
    public static final int ERROR_SESSION_EXPIRED = 24;
    public static final int ERROR_BAD_CERTIFICATE_FORMAT = 25;
    public static final int ERROR_DECRYPTION_FAILED = 26;
    private final ILockSettings mBinder;
    private final KeyStore mKeyStore;

    private RecoveryController(ILockSettings binder, KeyStore keystore) {
        this.mBinder = binder;
        this.mKeyStore = keystore;
    }

    ILockSettings getBinder() {
        return this.mBinder;
    }

    public static RecoveryController getInstance(Context context) {
        ILockSettings lockSettings = ILockSettings.Stub.asInterface(ServiceManager.getService("lock_settings"));
        return new RecoveryController(lockSettings, KeyStore.getInstance());
    }

    public void initRecoveryService(String rootCertificateAlias, byte[] signedPublicKeyList) throws CertificateException, InternalRecoveryServiceException {
        try {
            this.mBinder.initRecoveryService(rootCertificateAlias, signedPublicKeyList);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 25) {
                throw new CertificateException(e.getMessage());
            }
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public KeyChainSnapshot getRecoveryData() throws InternalRecoveryServiceException {
        try {
            return this.mBinder.getKeyChainSnapshot();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 21) {
                return null;
            }
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public KeyChainSnapshot getKeyChainSnapshot() throws InternalRecoveryServiceException {
        try {
            return this.mBinder.getKeyChainSnapshot();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 21) {
                return null;
            }
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public void setSnapshotCreatedPendingIntent(PendingIntent intent) throws InternalRecoveryServiceException {
        try {
            this.mBinder.setSnapshotCreatedPendingIntent(intent);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public void setServerParams(byte[] serverParams) throws InternalRecoveryServiceException {
        try {
            this.mBinder.setServerParams(serverParams);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public List<String> getAliases(String packageName) throws InternalRecoveryServiceException {
        try {
            Map allStatuses = this.mBinder.getRecoveryStatus(packageName);
            return new ArrayList<String>(allStatuses.keySet());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public void setRecoveryStatus(String packageName, String alias, int status) throws PackageManager.NameNotFoundException, InternalRecoveryServiceException {
        try {
            String[] stringArray;
            if (alias == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = alias;
            }
            String[] aliases = stringArray;
            this.mBinder.setRecoveryStatus(packageName, aliases, status);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public int getRecoveryStatus(String packageName, String alias) throws InternalRecoveryServiceException {
        try {
            Map allStatuses = this.mBinder.getRecoveryStatus(packageName);
            Integer status = (Integer)allStatuses.get(alias);
            if (status == null) {
                return 3;
            }
            return status;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public void setRecoverySecretTypes(int[] secretTypes) throws InternalRecoveryServiceException {
        try {
            this.mBinder.setRecoverySecretTypes(secretTypes);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public int[] getRecoverySecretTypes() throws InternalRecoveryServiceException {
        try {
            return this.mBinder.getRecoverySecretTypes();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public int[] getPendingRecoverySecretTypes() throws InternalRecoveryServiceException {
        try {
            return this.mBinder.getPendingRecoverySecretTypes();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public void recoverySecretAvailable(KeyChainProtectionParams recoverySecret) throws InternalRecoveryServiceException {
        try {
            this.mBinder.recoverySecretAvailable(recoverySecret);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public byte[] generateAndStoreKey(String alias, byte[] account) throws InternalRecoveryServiceException, LockScreenRequiredException {
        try {
            return this.mBinder.generateAndStoreKey(alias);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 23) {
                throw new LockScreenRequiredException(e.getMessage());
            }
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public Key generateKey(String alias, byte[] account) throws InternalRecoveryServiceException, LockScreenRequiredException {
        try {
            String grantAlias = this.mBinder.generateKey(alias, account);
            if (grantAlias == null) {
                return null;
            }
            AndroidKeyStoreKey result = AndroidKeyStoreProvider.loadAndroidKeyStoreKeyFromKeystore(this.mKeyStore, grantAlias, -1);
            return result;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (UnrecoverableKeyException e) {
            throw new InternalRecoveryServiceException("Access to newly generated key failed for");
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 23) {
                throw new LockScreenRequiredException(e.getMessage());
            }
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public Key getKey(String alias) throws InternalRecoveryServiceException, UnrecoverableKeyException {
        try {
            String grantAlias = this.mBinder.getKey(alias);
            if (grantAlias == null) {
                return null;
            }
            return AndroidKeyStoreProvider.loadAndroidKeyStoreKeyFromKeystore(this.mKeyStore, grantAlias, -1);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public void removeKey(String alias) throws InternalRecoveryServiceException {
        try {
            this.mBinder.removeKey(alias);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    InternalRecoveryServiceException wrapUnexpectedServiceSpecificException(ServiceSpecificException e) {
        if (e.errorCode == 22) {
            return new InternalRecoveryServiceException(e.getMessage());
        }
        return new InternalRecoveryServiceException("Unexpected error code for method: " + e.errorCode, e);
    }
}

