/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore.recovery;

import android.annotation.SystemApi;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.security.keystore.recovery.DecryptionFailedException;
import android.security.keystore.recovery.InternalRecoveryServiceException;
import android.security.keystore.recovery.KeyChainProtectionParams;
import android.security.keystore.recovery.RecoveryController;
import android.security.keystore.recovery.SessionExpiredException;
import android.security.keystore.recovery.WrappedApplicationKey;
import android.util.Log;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Map;

@SystemApi
public class RecoverySession
implements AutoCloseable {
    private static final String TAG = "RecoverySession";
    private static final int SESSION_ID_LENGTH_BYTES = 16;
    private final String mSessionId;
    private final RecoveryController mRecoveryController;

    private RecoverySession(RecoveryController recoveryController, String sessionId) {
        this.mRecoveryController = recoveryController;
        this.mSessionId = sessionId;
    }

    static RecoverySession newInstance(RecoveryController recoveryController) {
        return new RecoverySession(recoveryController, RecoverySession.newSessionId());
    }

    private static String newSessionId() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] sessionId = new byte[16];
        secureRandom.nextBytes(sessionId);
        StringBuilder sb = new StringBuilder();
        for (byte b : sessionId) {
            sb.append(Byte.toHexString((byte)b, (boolean)false));
        }
        return sb.toString();
    }

    public byte[] start(byte[] verifierPublicKey, byte[] vaultParams, byte[] vaultChallenge, List<KeyChainProtectionParams> secrets) throws CertificateException, InternalRecoveryServiceException {
        try {
            byte[] recoveryClaim = this.mRecoveryController.getBinder().startRecoverySession(this.mSessionId, verifierPublicKey, vaultParams, vaultChallenge, secrets);
            return recoveryClaim;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 25) {
                throw new CertificateException(e.getMessage());
            }
            throw this.mRecoveryController.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public Map<String, byte[]> recoverKeys(byte[] recoveryKeyBlob, List<WrappedApplicationKey> applicationKeys) throws SessionExpiredException, DecryptionFailedException, InternalRecoveryServiceException {
        try {
            return this.mRecoveryController.getBinder().recoverKeys(this.mSessionId, recoveryKeyBlob, applicationKeys);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 26) {
                throw new DecryptionFailedException(e.getMessage());
            }
            if (e.errorCode == 24) {
                throw new SessionExpiredException(e.getMessage());
            }
            throw this.mRecoveryController.wrapUnexpectedServiceSpecificException(e);
        }
    }

    String getSessionId() {
        return this.mSessionId;
    }

    @Override
    public void close() {
        try {
            this.mRecoveryController.getBinder().closeSession(this.mSessionId);
        }
        catch (RemoteException | ServiceSpecificException e) {
            Log.e(TAG, "Unexpected error trying to close session", e);
        }
    }
}

