/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore.recovery;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;

@SystemApi
public final class WrappedApplicationKey
implements Parcelable {
    private String mAlias;
    private byte[] mEncryptedKeyMaterial;
    private byte[] mAccount;
    public static final Parcelable.Creator<WrappedApplicationKey> CREATOR = new Parcelable.Creator<WrappedApplicationKey>(){

        @Override
        public WrappedApplicationKey createFromParcel(Parcel in) {
            return new WrappedApplicationKey(in);
        }

        public WrappedApplicationKey[] newArray(int length) {
            return new WrappedApplicationKey[length];
        }
    };

    private WrappedApplicationKey() {
    }

    public WrappedApplicationKey(String alias, byte[] encryptedKeyMaterial) {
        this.mAlias = Preconditions.checkNotNull(alias);
        this.mEncryptedKeyMaterial = Preconditions.checkNotNull(encryptedKeyMaterial);
    }

    public String getAlias() {
        return this.mAlias;
    }

    public byte[] getEncryptedKeyMaterial() {
        return this.mEncryptedKeyMaterial;
    }

    public byte[] getAccount() {
        if (this.mAccount == null) {
            return new byte[0];
        }
        return this.mAccount;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.mAlias);
        out.writeByteArray(this.mEncryptedKeyMaterial);
        out.writeByteArray(this.mAccount);
    }

    protected WrappedApplicationKey(Parcel in) {
        this.mAlias = in.readString();
        this.mEncryptedKeyMaterial = in.createByteArray();
        this.mAccount = in.createByteArray();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    static /* synthetic */ byte[] access$202(WrappedApplicationKey x0, byte[] x1) {
        x0.mAccount = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$302(WrappedApplicationKey x0, byte[] x1) {
        x0.mEncryptedKeyMaterial = x1;
        return x1;
    }

    public static class Builder {
        private WrappedApplicationKey mInstance = new WrappedApplicationKey();

        public Builder setAlias(String alias) {
            this.mInstance.mAlias = alias;
            return this;
        }

        public Builder setAccount(byte[] account) {
            WrappedApplicationKey.access$202(this.mInstance, account);
            return this;
        }

        public Builder setEncryptedKeyMaterial(byte[] encryptedKeyMaterial) {
            WrappedApplicationKey.access$302(this.mInstance, encryptedKeyMaterial);
            return this;
        }

        public WrappedApplicationKey build() {
            Preconditions.checkNotNull(this.mInstance.mAlias);
            Preconditions.checkNotNull(this.mInstance.mEncryptedKeyMaterial);
            if (this.mInstance.mAccount == null) {
                WrappedApplicationKey.access$202(this.mInstance, new byte[0]);
            }
            return this.mInstance;
        }
    }
}

