/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.annotation.SystemApi;
import android.app.Service;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.service.autofill.IAutofillFieldClassificationService;
import android.util.Log;
import android.view.autofill.AutofillValue;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.SomeArgs;
import java.util.Arrays;
import java.util.List;

@SystemApi
public abstract class AutofillFieldClassificationService
extends Service {
    private static final String TAG = "AutofillFieldClassificationService";
    private static final int MSG_GET_SCORES = 1;
    public static final String SERVICE_INTERFACE = "android.service.autofill.AutofillFieldClassificationService";
    public static final String SERVICE_META_DATA_KEY_DEFAULT_ALGORITHM = "android.autofill.field_classification.default_algorithm";
    public static final String SERVICE_META_DATA_KEY_AVAILABLE_ALGORITHMS = "android.autofill.field_classification.available_algorithms";
    public static final String EXTRA_SCORES = "scores";
    private AutofillFieldClassificationServiceWrapper mWrapper;
    private final HandlerCaller.Callback mHandlerCallback = msg -> {
        RemoteCallback callback;
        int action = msg.what;
        Bundle data = new Bundle();
        switch (action) {
            case 1: {
                SomeArgs args = (SomeArgs)msg.obj;
                callback = (RemoteCallback)args.arg1;
                String algorithmName = (String)args.arg2;
                Bundle algorithmArgs = (Bundle)args.arg3;
                List actualValues = (List)args.arg4;
                String[] userDataValues = (String[])args.arg5;
                float[][] scores = this.onGetScores(algorithmName, algorithmArgs, actualValues, Arrays.asList(userDataValues));
                if (scores == null) break;
                data.putParcelable(EXTRA_SCORES, new Scores(scores));
                break;
            }
            default: {
                Log.w(TAG, "Handling unknown message: " + action);
                return;
            }
        }
        callback.sendResult(data);
    };
    private final HandlerCaller mHandlerCaller = new HandlerCaller(null, Looper.getMainLooper(), this.mHandlerCallback, true);

    @Override
    public void onCreate() {
        super.onCreate();
        this.mWrapper = new AutofillFieldClassificationServiceWrapper();
    }

    @Override
    public IBinder onBind(Intent intent) {
        return this.mWrapper;
    }

    @SystemApi
    public float[][] onGetScores(String algorithm, Bundle args, List<AutofillValue> actualValues, List<String> userDataValues) {
        Log.e(TAG, "service implementation (" + this.getClass() + " does not implement onGetScore()");
        return null;
    }

    public static final class Scores
    implements Parcelable {
        public final float[][] scores;
        public static final Parcelable.Creator<Scores> CREATOR = new Parcelable.Creator<Scores>(){

            @Override
            public Scores createFromParcel(Parcel parcel) {
                return new Scores(parcel);
            }

            public Scores[] newArray(int size) {
                return new Scores[size];
            }
        };

        private Scores(Parcel parcel) {
            int size1 = parcel.readInt();
            int size2 = parcel.readInt();
            this.scores = new float[size1][size2];
            for (int i = 0; i < size1; ++i) {
                for (int j = 0; j < size2; ++j) {
                    this.scores[i][j] = parcel.readFloat();
                }
            }
        }

        private Scores(float[][] scores) {
            this.scores = scores;
        }

        public String toString() {
            int size1 = this.scores.length;
            int size2 = size1 > 0 ? this.scores[0].length : 0;
            StringBuilder builder = new StringBuilder("Scores [").append(size1).append("x").append(size2).append("] ");
            for (int i = 0; i < size1; ++i) {
                builder.append(i).append(": ").append(Arrays.toString(this.scores[i])).append(' ');
            }
            return builder.toString();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int flags) {
            int size1 = this.scores.length;
            int size2 = this.scores[0].length;
            parcel.writeInt(size1);
            parcel.writeInt(size2);
            for (int i = 0; i < size1; ++i) {
                for (int j = 0; j < size2; ++j) {
                    parcel.writeFloat(this.scores[i][j]);
                }
            }
        }
    }

    private final class AutofillFieldClassificationServiceWrapper
    extends IAutofillFieldClassificationService.Stub {
        private AutofillFieldClassificationServiceWrapper() {
        }

        @Override
        public void getScores(RemoteCallback callback, String algorithmName, Bundle algorithmArgs, List<AutofillValue> actualValues, String[] userDataValues) throws RemoteException {
            AutofillFieldClassificationService.this.mHandlerCaller.obtainMessageOOOOO(1, callback, algorithmName, algorithmArgs, actualValues, userDataValues).sendToTarget();
        }
    }
}

