/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.os.Parcel;
import android.os.Parcelable;
import android.service.autofill.BatchUpdates;
import android.service.autofill.InternalTransformation;
import android.service.autofill.InternalValidator;
import android.service.autofill.Transformation;
import android.service.autofill.Validator;
import android.util.Pair;
import android.view.autofill.Helper;
import android.widget.RemoteViews;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;

public final class CustomDescription
implements Parcelable {
    private final RemoteViews mPresentation;
    private final ArrayList<Pair<Integer, InternalTransformation>> mTransformations;
    private final ArrayList<Pair<InternalValidator, BatchUpdates>> mUpdates;
    public static final Parcelable.Creator<CustomDescription> CREATOR = new Parcelable.Creator<CustomDescription>(){

        @Override
        public CustomDescription createFromParcel(Parcel parcel) {
            InternalValidator[] conditions;
            RemoteViews parentPresentation = (RemoteViews)parcel.readParcelable(null);
            if (parentPresentation == null) {
                return null;
            }
            Builder builder = new Builder(parentPresentation);
            int[] ids = parcel.createIntArray();
            if (ids != null) {
                InternalTransformation[] values = (InternalTransformation[])parcel.readParcelableArray(null, InternalTransformation.class);
                int size = ids.length;
                for (int i = 0; i < size; ++i) {
                    builder.addChild(ids[i], values[i]);
                }
            }
            if ((conditions = (InternalValidator[])parcel.readParcelableArray(null, InternalValidator.class)) != null) {
                BatchUpdates[] updates = (BatchUpdates[])parcel.readParcelableArray(null, BatchUpdates.class);
                int size = conditions.length;
                for (int i = 0; i < size; ++i) {
                    builder.batchUpdate(conditions[i], updates[i]);
                }
            }
            return builder.build();
        }

        public CustomDescription[] newArray(int size) {
            return new CustomDescription[size];
        }
    };

    private CustomDescription(Builder builder) {
        this.mPresentation = builder.mPresentation;
        this.mTransformations = builder.mTransformations;
        this.mUpdates = builder.mUpdates;
    }

    public RemoteViews getPresentation() {
        return this.mPresentation;
    }

    public ArrayList<Pair<Integer, InternalTransformation>> getTransformations() {
        return this.mTransformations;
    }

    public ArrayList<Pair<InternalValidator, BatchUpdates>> getUpdates() {
        return this.mUpdates;
    }

    public String toString() {
        if (!Helper.sDebug) {
            return super.toString();
        }
        return "CustomDescription: [presentation=" + this.mPresentation + ", transformations=" + (this.mTransformations == null ? "N/A" : Integer.valueOf(this.mTransformations.size())) + ", updates=" + (this.mUpdates == null ? "N/A" : Integer.valueOf(this.mUpdates.size())) + "]";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Pair<Object, Parcelable> pair;
        int i;
        int size;
        dest.writeParcelable(this.mPresentation, flags);
        if (this.mPresentation == null) {
            return;
        }
        if (this.mTransformations == null) {
            dest.writeIntArray(null);
        } else {
            size = this.mTransformations.size();
            int[] ids = new int[size];
            Parcelable[] values = new InternalTransformation[size];
            for (i = 0; i < size; ++i) {
                pair = this.mTransformations.get(i);
                ids[i] = (Integer)pair.first;
                values[i] = (InternalTransformation)pair.second;
            }
            dest.writeIntArray(ids);
            dest.writeParcelableArray(values, flags);
        }
        if (this.mUpdates == null) {
            dest.writeParcelableArray(null, flags);
        } else {
            size = this.mUpdates.size();
            Parcelable[] conditions = new InternalValidator[size];
            Parcelable[] updates = new BatchUpdates[size];
            for (i = 0; i < size; ++i) {
                pair = this.mUpdates.get(i);
                conditions[i] = (InternalValidator)pair.first;
                updates[i] = (BatchUpdates)pair.second;
            }
            dest.writeParcelableArray(conditions, flags);
            dest.writeParcelableArray(updates, flags);
        }
    }

    public static class Builder {
        private final RemoteViews mPresentation;
        private boolean mDestroyed;
        private ArrayList<Pair<Integer, InternalTransformation>> mTransformations;
        private ArrayList<Pair<InternalValidator, BatchUpdates>> mUpdates;

        public Builder(RemoteViews parentPresentation) {
            this.mPresentation = Preconditions.checkNotNull(parentPresentation);
        }

        public Builder addChild(int id2, Transformation transformation) {
            this.throwIfDestroyed();
            Preconditions.checkArgument(transformation instanceof InternalTransformation, "not provided by Android System: " + transformation);
            if (this.mTransformations == null) {
                this.mTransformations = new ArrayList();
            }
            this.mTransformations.add(new Pair<Integer, InternalTransformation>(id2, (InternalTransformation)transformation));
            return this;
        }

        public Builder batchUpdate(Validator condition, BatchUpdates updates) {
            this.throwIfDestroyed();
            Preconditions.checkArgument(condition instanceof InternalValidator, "not provided by Android System: " + condition);
            Preconditions.checkNotNull(updates);
            if (this.mUpdates == null) {
                this.mUpdates = new ArrayList();
            }
            this.mUpdates.add(new Pair<InternalValidator, BatchUpdates>((InternalValidator)condition, updates));
            return this;
        }

        public CustomDescription build() {
            this.throwIfDestroyed();
            this.mDestroyed = true;
            return new CustomDescription(this);
        }

        private void throwIfDestroyed() {
            if (this.mDestroyed) {
                throw new IllegalStateException("Already called #build()");
            }
        }
    }
}

