/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.os.Parcel;
import android.os.Parcelable;
import android.service.autofill.InternalTransformation;
import android.service.autofill.Transformation;
import android.service.autofill.ValueFinder;
import android.util.Log;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillValue;
import android.view.autofill.Helper;
import android.widget.RemoteViews;
import com.android.internal.util.Preconditions;
import java.text.DateFormat;
import java.util.Date;

public final class DateTransformation
extends InternalTransformation
implements Transformation,
Parcelable {
    private static final String TAG = "DateTransformation";
    private final AutofillId mFieldId;
    private final DateFormat mDateFormat;
    public static final Parcelable.Creator<DateTransformation> CREATOR = new Parcelable.Creator<DateTransformation>(){

        @Override
        public DateTransformation createFromParcel(Parcel parcel) {
            return new DateTransformation((AutofillId)parcel.readParcelable(null), (DateFormat)parcel.readSerializable());
        }

        public DateTransformation[] newArray(int size) {
            return new DateTransformation[size];
        }
    };

    public DateTransformation(AutofillId id2, DateFormat dateFormat) {
        this.mFieldId = Preconditions.checkNotNull(id2);
        this.mDateFormat = Preconditions.checkNotNull(dateFormat);
    }

    @Override
    public void apply(ValueFinder finder, RemoteViews parentTemplate, int childViewId) throws Exception {
        AutofillValue value = finder.findRawValueByAutofillId(this.mFieldId);
        if (value == null) {
            Log.w(TAG, "No value for id " + this.mFieldId);
            return;
        }
        if (!value.isDate()) {
            Log.w(TAG, "Value for " + this.mFieldId + " is not date: " + value);
            return;
        }
        try {
            Date date = new Date(value.getDateValue());
            String transformed = this.mDateFormat.format(date);
            if (Helper.sDebug) {
                Log.d(TAG, "Transformed " + date + " to " + transformed);
            }
            parentTemplate.setCharSequence(childViewId, "setText", transformed);
        }
        catch (Exception e) {
            Log.w(TAG, "Could not apply " + this.mDateFormat + " to " + value + ": " + e);
        }
    }

    public String toString() {
        if (!Helper.sDebug) {
            return super.toString();
        }
        return "DateTransformation: [id=" + this.mFieldId + ", format=" + this.mDateFormat + "]";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeParcelable(this.mFieldId, flags);
        parcel.writeSerializable(this.mDateFormat);
    }
}

