/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.os.Parcel;
import android.os.Parcelable;
import android.service.autofill.InternalSanitizer;
import android.service.autofill.Sanitizer;
import android.util.Log;
import android.view.autofill.AutofillValue;
import android.view.autofill.Helper;
import com.android.internal.util.Preconditions;
import java.text.DateFormat;
import java.util.Date;

public final class DateValueSanitizer
extends InternalSanitizer
implements Sanitizer,
Parcelable {
    private static final String TAG = "DateValueSanitizer";
    private final DateFormat mDateFormat;
    public static final Parcelable.Creator<DateValueSanitizer> CREATOR = new Parcelable.Creator<DateValueSanitizer>(){

        @Override
        public DateValueSanitizer createFromParcel(Parcel parcel) {
            return new DateValueSanitizer((DateFormat)parcel.readSerializable());
        }

        public DateValueSanitizer[] newArray(int size) {
            return new DateValueSanitizer[size];
        }
    };

    public DateValueSanitizer(DateFormat dateFormat) {
        this.mDateFormat = Preconditions.checkNotNull(dateFormat);
    }

    @Override
    public AutofillValue sanitize(AutofillValue value) {
        if (value == null) {
            Log.w(TAG, "sanitize() called with null value");
            return null;
        }
        if (!value.isDate()) {
            if (Helper.sDebug) {
                Log.d(TAG, value + " is not a date");
            }
            return null;
        }
        try {
            Date date = new Date(value.getDateValue());
            String converted = this.mDateFormat.format(date);
            if (Helper.sDebug) {
                Log.d(TAG, "Transformed " + date + " to " + converted);
            }
            Date sanitized = this.mDateFormat.parse(converted);
            if (Helper.sDebug) {
                Log.d(TAG, "Sanitized to " + sanitized);
            }
            return AutofillValue.forDate(sanitized.getTime());
        }
        catch (Exception e) {
            Log.w(TAG, "Could not apply " + this.mDateFormat + " to " + value + ": " + e);
            return null;
        }
    }

    public String toString() {
        if (!Helper.sDebug) {
            return super.toString();
        }
        return "DateValueSanitizer: [dateFormat=" + this.mDateFormat + "]";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeSerializable(this.mDateFormat);
    }
}

