/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.app.assist.AssistStructure;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.util.SparseIntArray;
import android.view.autofill.AutofillId;
import android.view.autofill.Helper;
import java.util.LinkedList;

public final class FillContext
implements Parcelable {
    private final int mRequestId;
    private final AssistStructure mStructure;
    private ArrayMap<AutofillId, AssistStructure.ViewNode> mViewNodeLookupTable;
    public static final Parcelable.Creator<FillContext> CREATOR = new Parcelable.Creator<FillContext>(){

        @Override
        public FillContext createFromParcel(Parcel parcel) {
            return new FillContext(parcel);
        }

        public FillContext[] newArray(int size) {
            return new FillContext[size];
        }
    };

    public FillContext(int requestId, AssistStructure structure) {
        this.mRequestId = requestId;
        this.mStructure = structure;
    }

    private FillContext(Parcel parcel) {
        this(parcel.readInt(), (AssistStructure)parcel.readParcelable(null));
    }

    public int getRequestId() {
        return this.mRequestId;
    }

    public AssistStructure getStructure() {
        return this.mStructure;
    }

    public String toString() {
        if (!Helper.sDebug) {
            return super.toString();
        }
        return "FillContext [reqId=" + this.mRequestId + "]";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mRequestId);
        parcel.writeParcelable(this.mStructure, flags);
    }

    public AssistStructure.ViewNode[] findViewNodesByAutofillIds(AutofillId[] ids) {
        LinkedList<AssistStructure.ViewNode> nodesToProcess = new LinkedList<AssistStructure.ViewNode>();
        AssistStructure.ViewNode[] foundNodes = new AssistStructure.ViewNode[ids.length];
        SparseIntArray missingNodeIndexes = new SparseIntArray(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            if (this.mViewNodeLookupTable != null) {
                int lookupTableIndex = this.mViewNodeLookupTable.indexOfKey(ids[i]);
                if (lookupTableIndex >= 0) {
                    foundNodes[i] = this.mViewNodeLookupTable.valueAt(lookupTableIndex);
                    continue;
                }
                missingNodeIndexes.put(i, 0);
                continue;
            }
            missingNodeIndexes.put(i, 0);
        }
        int numWindowNodes = this.mStructure.getWindowNodeCount();
        for (int i = 0; i < numWindowNodes; ++i) {
            nodesToProcess.add(this.mStructure.getWindowNodeAt(i).getRootViewNode());
        }
        while (missingNodeIndexes.size() > 0 && !nodesToProcess.isEmpty()) {
            int i;
            AssistStructure.ViewNode node = (AssistStructure.ViewNode)nodesToProcess.removeFirst();
            for (i = 0; i < missingNodeIndexes.size(); ++i) {
                int index = missingNodeIndexes.keyAt(i);
                AutofillId id2 = ids[index];
                if (!id2.equals(node.getAutofillId())) continue;
                foundNodes[index] = node;
                if (this.mViewNodeLookupTable == null) {
                    this.mViewNodeLookupTable = new ArrayMap(ids.length);
                }
                this.mViewNodeLookupTable.put(id2, node);
                missingNodeIndexes.removeAt(i);
                break;
            }
            for (i = 0; i < node.getChildCount(); ++i) {
                nodesToProcess.addLast(node.getChildAt(i));
            }
        }
        for (int i = 0; i < missingNodeIndexes.size(); ++i) {
            if (this.mViewNodeLookupTable == null) {
                this.mViewNodeLookupTable = new ArrayMap(missingNodeIndexes.size());
            }
            this.mViewNodeLookupTable.put(ids[missingNodeIndexes.keyAt(i)], null);
        }
        return foundNodes;
    }
}

