/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.os.Parcel;
import android.os.Parcelable;
import android.service.autofill.InternalValidator;
import android.service.autofill.ValueFinder;
import android.util.Log;
import android.view.autofill.Helper;
import com.android.internal.util.Preconditions;

final class RequiredValidators
extends InternalValidator {
    private static final String TAG = "RequiredValidators";
    private final InternalValidator[] mValidators;
    public static final Parcelable.Creator<RequiredValidators> CREATOR = new Parcelable.Creator<RequiredValidators>(){

        @Override
        public RequiredValidators createFromParcel(Parcel parcel) {
            return new RequiredValidators((InternalValidator[])parcel.readParcelableArray(null, InternalValidator.class));
        }

        public RequiredValidators[] newArray(int size) {
            return new RequiredValidators[size];
        }
    };

    RequiredValidators(InternalValidator[] validators) {
        this.mValidators = Preconditions.checkArrayElementsNotNull(validators, "validators");
    }

    @Override
    public boolean isValid(ValueFinder finder) {
        for (InternalValidator validator : this.mValidators) {
            boolean valid = validator.isValid(finder);
            if (Helper.sDebug) {
                Log.d(TAG, "isValid(" + validator + "): " + valid);
            }
            if (valid) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (!Helper.sDebug) {
            return super.toString();
        }
        return "RequiredValidators: [validators=" + this.mValidators + "]";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelableArray(this.mValidators, flags);
    }
}

