/*
 * Decompiled with CFR 0.152.
 */
package android.service.euicc;

import android.os.Parcel;
import android.os.Parcelable;
import android.service.carrier.CarrierIdentifier;
import android.telephony.UiccAccessRule;
import android.text.TextUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Objects;

public final class EuiccProfileInfo
implements Parcelable {
    public static final int POLICY_RULE_DO_NOT_DISABLE = 1;
    public static final int POLICY_RULE_DO_NOT_DELETE = 2;
    public static final int POLICY_RULE_DELETE_AFTER_DISABLING = 4;
    public static final int PROFILE_CLASS_TESTING = 0;
    public static final int PROFILE_CLASS_PROVISIONING = 1;
    public static final int PROFILE_CLASS_OPERATIONAL = 2;
    public static final int PROFILE_CLASS_UNSET = -1;
    public static final int PROFILE_STATE_DISABLED = 0;
    public static final int PROFILE_STATE_ENABLED = 1;
    public static final int PROFILE_STATE_UNSET = -1;
    public final String iccid;
    public final String nickname;
    public final String serviceProviderName;
    public final String profileName;
    public final int profileClass;
    public final int state;
    public final CarrierIdentifier carrierIdentifier;
    public final int policyRules;
    public final UiccAccessRule[] accessRules;
    public static final Parcelable.Creator<EuiccProfileInfo> CREATOR = new Parcelable.Creator<EuiccProfileInfo>(){

        @Override
        public EuiccProfileInfo createFromParcel(Parcel in) {
            return new EuiccProfileInfo(in);
        }

        public EuiccProfileInfo[] newArray(int size) {
            return new EuiccProfileInfo[size];
        }
    };

    @Deprecated
    public EuiccProfileInfo(String iccid, UiccAccessRule[] accessRules, String nickname) {
        if (!TextUtils.isDigitsOnly(iccid)) {
            throw new IllegalArgumentException("iccid contains invalid characters: " + iccid);
        }
        this.iccid = iccid;
        this.accessRules = accessRules;
        this.nickname = nickname;
        this.serviceProviderName = null;
        this.profileName = null;
        this.profileClass = -1;
        this.state = -1;
        this.carrierIdentifier = null;
        this.policyRules = 0;
    }

    private EuiccProfileInfo(Parcel in) {
        this.iccid = in.readString();
        this.nickname = in.readString();
        this.serviceProviderName = in.readString();
        this.profileName = in.readString();
        this.profileClass = in.readInt();
        this.state = in.readInt();
        byte exist = in.readByte();
        this.carrierIdentifier = exist == 1 ? CarrierIdentifier.CREATOR.createFromParcel(in) : null;
        this.policyRules = in.readInt();
        this.accessRules = in.createTypedArray(UiccAccessRule.CREATOR);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.iccid);
        dest.writeString(this.nickname);
        dest.writeString(this.serviceProviderName);
        dest.writeString(this.profileName);
        dest.writeInt(this.profileClass);
        dest.writeInt(this.state);
        if (this.carrierIdentifier != null) {
            dest.writeByte((byte)1);
            this.carrierIdentifier.writeToParcel(dest, flags);
        } else {
            dest.writeByte((byte)0);
        }
        dest.writeInt(this.policyRules);
        dest.writeTypedArray(this.accessRules, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private EuiccProfileInfo(String iccid, String nickname, String serviceProviderName, String profileName, int profileClass, int state, CarrierIdentifier carrierIdentifier, int policyRules, UiccAccessRule[] accessRules) {
        this.iccid = iccid;
        this.nickname = nickname;
        this.serviceProviderName = serviceProviderName;
        this.profileName = profileName;
        this.profileClass = profileClass;
        this.state = state;
        this.carrierIdentifier = carrierIdentifier;
        this.policyRules = policyRules;
        this.accessRules = accessRules;
    }

    public String getIccid() {
        return this.iccid;
    }

    public UiccAccessRule[] getUiccAccessRules() {
        return this.accessRules;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getServiceProviderName() {
        return this.serviceProviderName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public int getProfileClass() {
        return this.profileClass;
    }

    public int getState() {
        return this.state;
    }

    public CarrierIdentifier getCarrierIdentifier() {
        return this.carrierIdentifier;
    }

    public int getPolicyRules() {
        return this.policyRules;
    }

    public boolean hasPolicyRules() {
        return this.policyRules != 0;
    }

    public boolean hasPolicyRule(int policy) {
        return (this.policyRules & policy) != 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EuiccProfileInfo that = (EuiccProfileInfo)obj;
        return Objects.equals(this.iccid, that.iccid) && Objects.equals(this.nickname, that.nickname) && Objects.equals(this.serviceProviderName, that.serviceProviderName) && Objects.equals(this.profileName, that.profileName) && this.profileClass == that.profileClass && this.state == that.state && Objects.equals(this.carrierIdentifier, that.carrierIdentifier) && this.policyRules == that.policyRules && Arrays.equals(this.accessRules, that.accessRules);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.iccid);
        result = 31 * result + Objects.hashCode(this.nickname);
        result = 31 * result + Objects.hashCode(this.serviceProviderName);
        result = 31 * result + Objects.hashCode(this.profileName);
        result = 31 * result + this.profileClass;
        result = 31 * result + this.state;
        result = 31 * result + Objects.hashCode(this.carrierIdentifier);
        result = 31 * result + this.policyRules;
        result = 31 * result + Arrays.hashCode(this.accessRules);
        return result;
    }

    public String toString() {
        return "EuiccProfileInfo (nickname=" + this.nickname + ", serviceProviderName=" + this.serviceProviderName + ", profileName=" + this.profileName + ", profileClass=" + this.profileClass + ", state=" + this.state + ", CarrierIdentifier=" + this.carrierIdentifier.toString() + ", policyRules=" + this.policyRules + ", accessRules=" + Arrays.toString(this.accessRules) + ")";
    }

    public static final class Builder {
        public String iccid;
        public UiccAccessRule[] accessRules;
        public String nickname;
        public String serviceProviderName;
        public String profileName;
        public int profileClass;
        public int state;
        public CarrierIdentifier carrierIdentifier;
        public int policyRules;

        public Builder() {
        }

        public Builder(EuiccProfileInfo baseProfile) {
            this.iccid = baseProfile.iccid;
            this.nickname = baseProfile.nickname;
            this.serviceProviderName = baseProfile.serviceProviderName;
            this.profileName = baseProfile.profileName;
            this.profileClass = baseProfile.profileClass;
            this.state = baseProfile.state;
            this.carrierIdentifier = baseProfile.carrierIdentifier;
            this.policyRules = baseProfile.policyRules;
            this.accessRules = baseProfile.accessRules;
        }

        public EuiccProfileInfo build() {
            if (this.iccid == null) {
                throw new IllegalStateException("ICCID must be set for a profile.");
            }
            return new EuiccProfileInfo(this.iccid, this.nickname, this.serviceProviderName, this.profileName, this.profileClass, this.state, this.carrierIdentifier, this.policyRules, this.accessRules);
        }

        public Builder setIccid(String value) {
            if (!TextUtils.isDigitsOnly(value)) {
                throw new IllegalArgumentException("iccid contains invalid characters: " + value);
            }
            this.iccid = value;
            return this;
        }

        public Builder setNickname(String value) {
            this.nickname = value;
            return this;
        }

        public Builder setServiceProviderName(String value) {
            this.serviceProviderName = value;
            return this;
        }

        public Builder setProfileName(String value) {
            this.profileName = value;
            return this;
        }

        public Builder setProfileClass(int value) {
            this.profileClass = value;
            return this;
        }

        public Builder setState(int value) {
            this.state = value;
            return this;
        }

        public Builder setCarrierIdentifier(CarrierIdentifier value) {
            this.carrierIdentifier = value;
            return this;
        }

        public Builder setPolicyRules(int value) {
            this.policyRules = value;
            return this;
        }

        public Builder setUiccAccessRule(UiccAccessRule[] value) {
            this.accessRules = value;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProfileState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProfileClass {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PolicyRule {
    }
}

