/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.annotation.SystemApi;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.service.notification.Adjustment;
import android.service.notification.IStatusBarNotificationHolder;
import android.service.notification.NotificationListenerService;
import android.service.notification.NotificationStats;
import android.service.notification.StatusBarNotification;
import android.util.Log;
import com.android.internal.os.SomeArgs;
import java.util.List;

@SystemApi
public abstract class NotificationAssistantService
extends NotificationListenerService {
    private static final String TAG = "NotificationAssistants";
    public static final String SERVICE_INTERFACE = "android.service.notification.NotificationAssistantService";
    private Handler mHandler;

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        this.mHandler = new MyHandler(this.getContext().getMainLooper());
    }

    @Override
    public final IBinder onBind(Intent intent) {
        if (this.mWrapper == null) {
            this.mWrapper = new NotificationAssistantServiceWrapper();
        }
        return this.mWrapper;
    }

    public abstract void onNotificationSnoozedUntilContext(StatusBarNotification var1, String var2);

    public abstract Adjustment onNotificationEnqueued(StatusBarNotification var1);

    @Override
    public void onNotificationRemoved(StatusBarNotification sbn, NotificationListenerService.RankingMap rankingMap, NotificationStats stats, int reason) {
        this.onNotificationRemoved(sbn, rankingMap, reason);
    }

    public final void adjustNotification(Adjustment adjustment) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().applyAdjustmentFromAssistant(this.mWrapper, adjustment);
        }
        catch (RemoteException ex) {
            Log.v(TAG, "Unable to contact notification manager", ex);
            throw ex.rethrowFromSystemServer();
        }
    }

    public final void adjustNotifications(List<Adjustment> adjustments) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().applyAdjustmentsFromAssistant(this.mWrapper, adjustments);
        }
        catch (RemoteException ex) {
            Log.v(TAG, "Unable to contact notification manager", ex);
            throw ex.rethrowFromSystemServer();
        }
    }

    public final void unsnoozeNotification(String key) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().unsnoozeNotificationFromAssistant(this.mWrapper, key);
        }
        catch (RemoteException ex) {
            Log.v(TAG, "Unable to contact notification manager", ex);
        }
    }

    private final class MyHandler
    extends Handler {
        public static final int MSG_ON_NOTIFICATION_ENQUEUED = 1;
        public static final int MSG_ON_NOTIFICATION_SNOOZED = 2;

        public MyHandler(Looper looper) {
            super(looper, null, false);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    StatusBarNotification sbn = (StatusBarNotification)args.arg1;
                    args.recycle();
                    Adjustment adjustment = NotificationAssistantService.this.onNotificationEnqueued(sbn);
                    if (adjustment == null) break;
                    if (!NotificationAssistantService.this.isBound()) {
                        return;
                    }
                    try {
                        NotificationAssistantService.this.getNotificationInterface().applyEnqueuedAdjustmentFromAssistant(NotificationAssistantService.this.mWrapper, adjustment);
                        break;
                    }
                    catch (RemoteException ex) {
                        Log.v(NotificationAssistantService.TAG, "Unable to contact notification manager", ex);
                        throw ex.rethrowFromSystemServer();
                    }
                }
                case 2: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    StatusBarNotification sbn = (StatusBarNotification)args.arg1;
                    String snoozeCriterionId = (String)args.arg2;
                    args.recycle();
                    NotificationAssistantService.this.onNotificationSnoozedUntilContext(sbn, snoozeCriterionId);
                    break;
                }
            }
        }
    }

    private class NotificationAssistantServiceWrapper
    extends NotificationListenerService.NotificationListenerWrapper {
        private NotificationAssistantServiceWrapper() {
        }

        @Override
        public void onNotificationEnqueued(IStatusBarNotificationHolder sbnHolder) {
            StatusBarNotification sbn;
            try {
                sbn = sbnHolder.get();
            }
            catch (RemoteException e) {
                Log.w(NotificationAssistantService.TAG, "onNotificationEnqueued: Error receiving StatusBarNotification", e);
                return;
            }
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = sbn;
            NotificationAssistantService.this.mHandler.obtainMessage(1, args).sendToTarget();
        }

        @Override
        public void onNotificationSnoozedUntilContext(IStatusBarNotificationHolder sbnHolder, String snoozeCriterionId) throws RemoteException {
            StatusBarNotification sbn;
            try {
                sbn = sbnHolder.get();
            }
            catch (RemoteException e) {
                Log.w(NotificationAssistantService.TAG, "onNotificationSnoozed: Error receiving StatusBarNotification", e);
                return;
            }
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = sbn;
            args.arg2 = snoozeCriterionId;
            NotificationAssistantService.this.mHandler.obtainMessage(2, args).sendToTarget();
        }
    }
}

