/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.annotation.SystemApi;
import android.app.INotificationManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ParceledListSlice;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.service.notification.INotificationListener;
import android.service.notification.IStatusBarNotificationHolder;
import android.service.notification.NotificationRankingUpdate;
import android.service.notification.NotificationStats;
import android.service.notification.SnoozeCriterion;
import android.service.notification.StatusBarNotification;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.widget.RemoteViews;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.SomeArgs;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class NotificationListenerService
extends Service {
    private final String TAG = this.getClass().getSimpleName();
    public static final int INTERRUPTION_FILTER_ALL = 1;
    public static final int INTERRUPTION_FILTER_PRIORITY = 2;
    public static final int INTERRUPTION_FILTER_NONE = 3;
    public static final int INTERRUPTION_FILTER_ALARMS = 4;
    public static final int INTERRUPTION_FILTER_UNKNOWN = 0;
    public static final int HINT_HOST_DISABLE_EFFECTS = 1;
    public static final int HINT_HOST_DISABLE_NOTIFICATION_EFFECTS = 2;
    public static final int HINT_HOST_DISABLE_CALL_EFFECTS = 4;
    public static final int SUPPRESSED_EFFECT_SCREEN_OFF = 1;
    public static final int SUPPRESSED_EFFECT_SCREEN_ON = 2;
    public static final int REASON_CLICK = 1;
    public static final int REASON_CANCEL = 2;
    public static final int REASON_CANCEL_ALL = 3;
    public static final int REASON_ERROR = 4;
    public static final int REASON_PACKAGE_CHANGED = 5;
    public static final int REASON_USER_STOPPED = 6;
    public static final int REASON_PACKAGE_BANNED = 7;
    public static final int REASON_APP_CANCEL = 8;
    public static final int REASON_APP_CANCEL_ALL = 9;
    public static final int REASON_LISTENER_CANCEL = 10;
    public static final int REASON_LISTENER_CANCEL_ALL = 11;
    public static final int REASON_GROUP_SUMMARY_CANCELED = 12;
    public static final int REASON_GROUP_OPTIMIZATION = 13;
    public static final int REASON_PACKAGE_SUSPENDED = 14;
    public static final int REASON_PROFILE_TURNED_OFF = 15;
    public static final int REASON_UNAUTOBUNDLED = 16;
    public static final int REASON_CHANNEL_BANNED = 17;
    public static final int REASON_SNOOZED = 18;
    public static final int REASON_TIMEOUT = 19;
    @SystemApi
    public static final int TRIM_FULL = 0;
    @SystemApi
    public static final int TRIM_LIGHT = 1;
    public static final int NOTIFICATION_CHANNEL_OR_GROUP_ADDED = 1;
    public static final int NOTIFICATION_CHANNEL_OR_GROUP_UPDATED = 2;
    public static final int NOTIFICATION_CHANNEL_OR_GROUP_DELETED = 3;
    private final Object mLock = new Object();
    private Handler mHandler;
    protected NotificationListenerWrapper mWrapper = null;
    private boolean isConnected = false;
    @GuardedBy(value="mLock")
    private RankingMap mRankingMap;
    protected INotificationManager mNoMan;
    protected int mCurrentUser;
    protected Context mSystemContext;
    public static final String SERVICE_INTERFACE = "android.service.notification.NotificationListenerService";

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        this.mHandler = new MyHandler(this.getMainLooper());
    }

    public void onNotificationPosted(StatusBarNotification sbn) {
    }

    public void onNotificationPosted(StatusBarNotification sbn, RankingMap rankingMap) {
        this.onNotificationPosted(sbn);
    }

    public void onNotificationRemoved(StatusBarNotification sbn) {
    }

    public void onNotificationRemoved(StatusBarNotification sbn, RankingMap rankingMap) {
        this.onNotificationRemoved(sbn);
    }

    public void onNotificationRemoved(StatusBarNotification sbn, RankingMap rankingMap, int reason) {
        this.onNotificationRemoved(sbn, rankingMap);
    }

    public void onNotificationRemoved(StatusBarNotification sbn, RankingMap rankingMap, NotificationStats stats, int reason) {
        this.onNotificationRemoved(sbn, rankingMap, reason);
    }

    public void onListenerConnected() {
    }

    public void onListenerDisconnected() {
    }

    public void onNotificationRankingUpdate(RankingMap rankingMap) {
    }

    public void onListenerHintsChanged(int hints) {
    }

    public void onNotificationChannelModified(String pkg, UserHandle user, NotificationChannel channel, int modificationType) {
    }

    public void onNotificationChannelGroupModified(String pkg, UserHandle user, NotificationChannelGroup group, int modificationType) {
    }

    public void onInterruptionFilterChanged(int interruptionFilter) {
    }

    protected final INotificationManager getNotificationInterface() {
        if (this.mNoMan == null) {
            this.mNoMan = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
        }
        return this.mNoMan;
    }

    @Deprecated
    public final void cancelNotification(String pkg, String tag, int id2) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().cancelNotificationFromListener(this.mWrapper, pkg, tag, id2);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    public final void cancelNotification(String key) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().cancelNotificationsFromListener(this.mWrapper, new String[]{key});
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    public final void cancelAllNotifications() {
        this.cancelNotifications(null);
    }

    public final void cancelNotifications(String[] keys) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().cancelNotificationsFromListener(this.mWrapper, keys);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    @SystemApi
    public final void snoozeNotification(String key, String snoozeCriterionId) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().snoozeNotificationUntilContextFromListener(this.mWrapper, key, snoozeCriterionId);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    public final void snoozeNotification(String key, long durationMs) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().snoozeNotificationUntilFromListener(this.mWrapper, key, durationMs);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    public final void setNotificationsShown(String[] keys) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().setNotificationsShownFromListener(this.mWrapper, keys);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    public final void updateNotificationChannel(String pkg, UserHandle user, NotificationChannel channel) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().updateNotificationChannelFromPrivilegedListener(this.mWrapper, pkg, user, channel);
        }
        catch (RemoteException e) {
            Log.v(this.TAG, "Unable to contact notification manager", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public final List<NotificationChannel> getNotificationChannels(String pkg, UserHandle user) {
        if (!this.isBound()) {
            return null;
        }
        try {
            return this.getNotificationInterface().getNotificationChannelsFromPrivilegedListener(this.mWrapper, pkg, user).getList();
        }
        catch (RemoteException e) {
            Log.v(this.TAG, "Unable to contact notification manager", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public final List<NotificationChannelGroup> getNotificationChannelGroups(String pkg, UserHandle user) {
        if (!this.isBound()) {
            return null;
        }
        try {
            return this.getNotificationInterface().getNotificationChannelGroupsFromPrivilegedListener(this.mWrapper, pkg, user).getList();
        }
        catch (RemoteException e) {
            Log.v(this.TAG, "Unable to contact notification manager", e);
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public final void setOnNotificationPostedTrim(int trim) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().setOnNotificationPostedTrimFromListener(this.mWrapper, trim);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    public StatusBarNotification[] getActiveNotifications() {
        return this.getActiveNotifications(null, 0);
    }

    public final StatusBarNotification[] getSnoozedNotifications() {
        try {
            ParceledListSlice parceledList = this.getNotificationInterface().getSnoozedNotificationsFromListener(this.mWrapper, 0);
            return this.cleanUpNotificationList(parceledList);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
            return null;
        }
    }

    @SystemApi
    public StatusBarNotification[] getActiveNotifications(int trim) {
        return this.getActiveNotifications(null, trim);
    }

    public StatusBarNotification[] getActiveNotifications(String[] keys) {
        return this.getActiveNotifications(keys, 0);
    }

    @SystemApi
    public StatusBarNotification[] getActiveNotifications(String[] keys, int trim) {
        if (!this.isBound()) {
            return null;
        }
        try {
            ParceledListSlice parceledList = this.getNotificationInterface().getActiveNotificationsFromListener(this.mWrapper, keys, trim);
            return this.cleanUpNotificationList(parceledList);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
            return null;
        }
    }

    private StatusBarNotification[] cleanUpNotificationList(ParceledListSlice<StatusBarNotification> parceledList) {
        List list = parceledList.getList();
        ArrayList<StatusBarNotification> corruptNotifications = null;
        int N = list.size();
        for (int i = 0; i < N; ++i) {
            StatusBarNotification sbn = (StatusBarNotification)list.get(i);
            Notification notification = sbn.getNotification();
            try {
                this.createLegacyIconExtras(notification);
                this.maybePopulateRemoteViews(notification);
                this.maybePopulatePeople(notification);
                continue;
            }
            catch (IllegalArgumentException e) {
                if (corruptNotifications == null) {
                    corruptNotifications = new ArrayList<StatusBarNotification>(N);
                }
                corruptNotifications.add(sbn);
                Log.w(this.TAG, "get(Active/Snoozed)Notifications: can't rebuild notification from " + sbn.getPackageName());
            }
        }
        if (corruptNotifications != null) {
            list.removeAll(corruptNotifications);
        }
        return list.toArray(new StatusBarNotification[list.size()]);
    }

    public final int getCurrentListenerHints() {
        if (!this.isBound()) {
            return 0;
        }
        try {
            return this.getNotificationInterface().getHintsFromListener(this.mWrapper);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
            return 0;
        }
    }

    public final int getCurrentInterruptionFilter() {
        if (!this.isBound()) {
            return 0;
        }
        try {
            return this.getNotificationInterface().getInterruptionFilterFromListener(this.mWrapper);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
            return 0;
        }
    }

    public final void requestListenerHints(int hints) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().requestHintsFromListener(this.mWrapper, hints);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    public final void requestInterruptionFilter(int interruptionFilter) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().requestInterruptionFilterFromListener(this.mWrapper, interruptionFilter);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RankingMap getCurrentRanking() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRankingMap;
        }
    }

    @Override
    public IBinder onBind(Intent intent) {
        if (this.mWrapper == null) {
            this.mWrapper = new NotificationListenerWrapper();
        }
        return this.mWrapper;
    }

    protected boolean isBound() {
        if (this.mWrapper == null) {
            Log.w(this.TAG, "Notification listener service not yet bound.");
            return false;
        }
        return true;
    }

    @Override
    public void onDestroy() {
        this.onListenerDisconnected();
        super.onDestroy();
    }

    @SystemApi
    public void registerAsSystemService(Context context, ComponentName componentName, int currentUser) throws RemoteException {
        if (this.mWrapper == null) {
            this.mWrapper = new NotificationListenerWrapper();
        }
        this.mSystemContext = context;
        INotificationManager noMan = this.getNotificationInterface();
        this.mHandler = new MyHandler(context.getMainLooper());
        this.mCurrentUser = currentUser;
        noMan.registerListener(this.mWrapper, componentName, currentUser);
    }

    @SystemApi
    public void unregisterAsSystemService() throws RemoteException {
        if (this.mWrapper != null) {
            INotificationManager noMan = this.getNotificationInterface();
            noMan.unregisterListener(this.mWrapper, this.mCurrentUser);
        }
    }

    public static void requestRebind(ComponentName componentName) {
        INotificationManager noMan = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
        try {
            noMan.requestBindListener(componentName);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public final void requestUnbind() {
        if (this.mWrapper != null) {
            INotificationManager noMan = this.getNotificationInterface();
            try {
                noMan.requestUnbindListener(this.mWrapper);
                this.isConnected = false;
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
        }
    }

    private void createLegacyIconExtras(Notification n) {
        Drawable d;
        Icon smallIcon = n.getSmallIcon();
        Icon largeIcon = n.getLargeIcon();
        if (smallIcon != null && smallIcon.getType() == 2) {
            n.extras.putInt("android.icon", smallIcon.getResId());
            n.icon = smallIcon.getResId();
        }
        if (largeIcon != null && (d = largeIcon.loadDrawable(this.getContext())) != null && d instanceof BitmapDrawable) {
            Bitmap largeIconBits = ((BitmapDrawable)d).getBitmap();
            n.extras.putParcelable("android.largeIcon", largeIconBits);
            n.largeIcon = largeIconBits;
        }
    }

    private void maybePopulateRemoteViews(Notification notification) {
        if (this.getContext().getApplicationInfo().targetSdkVersion < 24) {
            Notification.Builder builder = Notification.Builder.recoverBuilder(this.getContext(), notification);
            RemoteViews content = builder.createContentView();
            RemoteViews big = builder.createBigContentView();
            RemoteViews headsUp = builder.createHeadsUpContentView();
            notification.contentView = content;
            notification.bigContentView = big;
            notification.headsUpContentView = headsUp;
        }
    }

    private void maybePopulatePeople(Notification notification) {
        ArrayList people;
        if (this.getContext().getApplicationInfo().targetSdkVersion < 10000 && (people = notification.extras.getParcelableArrayList("android.people.list")) != null && people.isEmpty()) {
            int size = people.size();
            String[] peopleArray = new String[size];
            for (int i = 0; i < size; ++i) {
                Notification.Person person = (Notification.Person)people.get(i);
                peopleArray[i] = person.resolveToLegacyUri();
            }
            notification.extras.putStringArray("android.people", peopleArray);
        }
    }

    public final void applyUpdateLocked(NotificationRankingUpdate update) {
        this.mRankingMap = new RankingMap(update);
    }

    protected Context getContext() {
        if (this.mSystemContext != null) {
            return this.mSystemContext;
        }
        return this;
    }

    private final class MyHandler
    extends Handler {
        public static final int MSG_ON_NOTIFICATION_POSTED = 1;
        public static final int MSG_ON_NOTIFICATION_REMOVED = 2;
        public static final int MSG_ON_LISTENER_CONNECTED = 3;
        public static final int MSG_ON_NOTIFICATION_RANKING_UPDATE = 4;
        public static final int MSG_ON_LISTENER_HINTS_CHANGED = 5;
        public static final int MSG_ON_INTERRUPTION_FILTER_CHANGED = 6;
        public static final int MSG_ON_NOTIFICATION_CHANNEL_MODIFIED = 7;
        public static final int MSG_ON_NOTIFICATION_CHANNEL_GROUP_MODIFIED = 8;

        public MyHandler(Looper looper) {
            super(looper, null, false);
        }

        @Override
        public void handleMessage(Message msg) {
            if (!NotificationListenerService.this.isConnected) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    StatusBarNotification sbn = (StatusBarNotification)args.arg1;
                    RankingMap rankingMap = (RankingMap)args.arg2;
                    args.recycle();
                    NotificationListenerService.this.onNotificationPosted(sbn, rankingMap);
                    break;
                }
                case 2: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    StatusBarNotification sbn = (StatusBarNotification)args.arg1;
                    RankingMap rankingMap = (RankingMap)args.arg2;
                    int reason = (Integer)args.arg3;
                    NotificationStats stats = (NotificationStats)args.arg4;
                    args.recycle();
                    NotificationListenerService.this.onNotificationRemoved(sbn, rankingMap, stats, reason);
                    break;
                }
                case 3: {
                    NotificationListenerService.this.onListenerConnected();
                    break;
                }
                case 4: {
                    RankingMap rankingMap = (RankingMap)msg.obj;
                    NotificationListenerService.this.onNotificationRankingUpdate(rankingMap);
                    break;
                }
                case 5: {
                    int hints = msg.arg1;
                    NotificationListenerService.this.onListenerHintsChanged(hints);
                    break;
                }
                case 6: {
                    int interruptionFilter = msg.arg1;
                    NotificationListenerService.this.onInterruptionFilterChanged(interruptionFilter);
                    break;
                }
                case 7: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    String pkgName = (String)args.arg1;
                    UserHandle user = (UserHandle)args.arg2;
                    NotificationChannel channel = (NotificationChannel)args.arg3;
                    int modificationType = (Integer)args.arg4;
                    NotificationListenerService.this.onNotificationChannelModified(pkgName, user, channel, modificationType);
                    break;
                }
                case 8: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    String pkgName = (String)args.arg1;
                    UserHandle user = (UserHandle)args.arg2;
                    NotificationChannelGroup group = (NotificationChannelGroup)args.arg3;
                    int modificationType = (Integer)args.arg4;
                    NotificationListenerService.this.onNotificationChannelGroupModified(pkgName, user, group, modificationType);
                }
            }
        }
    }

    public static class RankingMap
    implements Parcelable {
        private final NotificationRankingUpdate mRankingUpdate;
        private ArrayMap<String, Integer> mRanks;
        private ArraySet<Object> mIntercepted;
        private ArrayMap<String, Integer> mVisibilityOverrides;
        private ArrayMap<String, Integer> mSuppressedVisualEffects;
        private ArrayMap<String, Integer> mImportance;
        private ArrayMap<String, String> mImportanceExplanation;
        private ArrayMap<String, String> mOverrideGroupKeys;
        private ArrayMap<String, NotificationChannel> mChannels;
        private ArrayMap<String, ArrayList<String>> mOverridePeople;
        private ArrayMap<String, ArrayList<SnoozeCriterion>> mSnoozeCriteria;
        private ArrayMap<String, Boolean> mShowBadge;
        private ArrayMap<String, Integer> mUserSentiment;
        public static final Parcelable.Creator<RankingMap> CREATOR = new Parcelable.Creator<RankingMap>(){

            @Override
            public RankingMap createFromParcel(Parcel source) {
                NotificationRankingUpdate rankingUpdate = (NotificationRankingUpdate)source.readParcelable(null);
                return new RankingMap(rankingUpdate);
            }

            public RankingMap[] newArray(int size) {
                return new RankingMap[size];
            }
        };

        private RankingMap(NotificationRankingUpdate rankingUpdate) {
            this.mRankingUpdate = rankingUpdate;
        }

        public String[] getOrderedKeys() {
            return this.mRankingUpdate.getOrderedKeys();
        }

        public boolean getRanking(String key, Ranking outRanking) {
            int rank = this.getRank(key);
            outRanking.populate(key, rank, !this.isIntercepted(key), this.getVisibilityOverride(key), this.getSuppressedVisualEffects(key), this.getImportance(key), this.getImportanceExplanation(key), this.getOverrideGroupKey(key), this.getChannel(key), this.getOverridePeople(key), this.getSnoozeCriteria(key), this.getShowBadge(key), this.getUserSentiment(key));
            return rank >= 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getRank(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mRanks == null) {
                    this.buildRanksLocked();
                }
            }
            Integer rank = this.mRanks.get(key);
            return rank != null ? rank : -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isIntercepted(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mIntercepted == null) {
                    this.buildInterceptedSetLocked();
                }
            }
            return this.mIntercepted.contains(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getVisibilityOverride(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mVisibilityOverrides == null) {
                    this.buildVisibilityOverridesLocked();
                }
            }
            Integer override = this.mVisibilityOverrides.get(key);
            if (override == null) {
                return -1000;
            }
            return override;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getSuppressedVisualEffects(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mSuppressedVisualEffects == null) {
                    this.buildSuppressedVisualEffectsLocked();
                }
            }
            Integer suppressed = this.mSuppressedVisualEffects.get(key);
            if (suppressed == null) {
                return 0;
            }
            return suppressed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getImportance(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mImportance == null) {
                    this.buildImportanceLocked();
                }
            }
            Integer importance = this.mImportance.get(key);
            if (importance == null) {
                return 3;
            }
            return importance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getImportanceExplanation(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mImportanceExplanation == null) {
                    this.buildImportanceExplanationLocked();
                }
            }
            return this.mImportanceExplanation.get(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getOverrideGroupKey(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mOverrideGroupKeys == null) {
                    this.buildOverrideGroupKeys();
                }
            }
            return this.mOverrideGroupKeys.get(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private NotificationChannel getChannel(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mChannels == null) {
                    this.buildChannelsLocked();
                }
            }
            return this.mChannels.get(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ArrayList<String> getOverridePeople(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mOverridePeople == null) {
                    this.buildOverridePeopleLocked();
                }
            }
            return this.mOverridePeople.get(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ArrayList<SnoozeCriterion> getSnoozeCriteria(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mSnoozeCriteria == null) {
                    this.buildSnoozeCriteriaLocked();
                }
            }
            return this.mSnoozeCriteria.get(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean getShowBadge(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mShowBadge == null) {
                    this.buildShowBadgeLocked();
                }
            }
            Boolean showBadge = this.mShowBadge.get(key);
            return showBadge == null ? false : showBadge;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getUserSentiment(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mUserSentiment == null) {
                    this.buildUserSentimentLocked();
                }
            }
            Integer userSentiment = this.mUserSentiment.get(key);
            return userSentiment == null ? 0 : userSentiment;
        }

        private void buildRanksLocked() {
            String[] orderedKeys = this.mRankingUpdate.getOrderedKeys();
            this.mRanks = new ArrayMap(orderedKeys.length);
            for (int i = 0; i < orderedKeys.length; ++i) {
                String key = orderedKeys[i];
                this.mRanks.put(key, i);
            }
        }

        private void buildInterceptedSetLocked() {
            String[] dndInterceptedKeys = this.mRankingUpdate.getInterceptedKeys();
            this.mIntercepted = new ArraySet(dndInterceptedKeys.length);
            Collections.addAll(this.mIntercepted, dndInterceptedKeys);
        }

        private void buildVisibilityOverridesLocked() {
            Bundle visibilityBundle = this.mRankingUpdate.getVisibilityOverrides();
            this.mVisibilityOverrides = new ArrayMap(visibilityBundle.size());
            for (String key : visibilityBundle.keySet()) {
                this.mVisibilityOverrides.put(key, visibilityBundle.getInt(key));
            }
        }

        private void buildSuppressedVisualEffectsLocked() {
            Bundle suppressedBundle = this.mRankingUpdate.getSuppressedVisualEffects();
            this.mSuppressedVisualEffects = new ArrayMap(suppressedBundle.size());
            for (String key : suppressedBundle.keySet()) {
                this.mSuppressedVisualEffects.put(key, suppressedBundle.getInt(key));
            }
        }

        private void buildImportanceLocked() {
            String[] orderedKeys = this.mRankingUpdate.getOrderedKeys();
            int[] importance = this.mRankingUpdate.getImportance();
            this.mImportance = new ArrayMap(orderedKeys.length);
            for (int i = 0; i < orderedKeys.length; ++i) {
                String key = orderedKeys[i];
                this.mImportance.put(key, importance[i]);
            }
        }

        private void buildImportanceExplanationLocked() {
            Bundle explanationBundle = this.mRankingUpdate.getImportanceExplanation();
            this.mImportanceExplanation = new ArrayMap(explanationBundle.size());
            for (String key : explanationBundle.keySet()) {
                this.mImportanceExplanation.put(key, explanationBundle.getString(key));
            }
        }

        private void buildOverrideGroupKeys() {
            Bundle overrideGroupKeys = this.mRankingUpdate.getOverrideGroupKeys();
            this.mOverrideGroupKeys = new ArrayMap(overrideGroupKeys.size());
            for (String key : overrideGroupKeys.keySet()) {
                this.mOverrideGroupKeys.put(key, overrideGroupKeys.getString(key));
            }
        }

        private void buildChannelsLocked() {
            Bundle channels = this.mRankingUpdate.getChannels();
            this.mChannels = new ArrayMap(channels.size());
            for (String key : channels.keySet()) {
                this.mChannels.put(key, (NotificationChannel)channels.getParcelable(key));
            }
        }

        private void buildOverridePeopleLocked() {
            Bundle overridePeople = this.mRankingUpdate.getOverridePeople();
            this.mOverridePeople = new ArrayMap(overridePeople.size());
            for (String key : overridePeople.keySet()) {
                this.mOverridePeople.put(key, overridePeople.getStringArrayList(key));
            }
        }

        private void buildSnoozeCriteriaLocked() {
            Bundle snoozeCriteria = this.mRankingUpdate.getSnoozeCriteria();
            this.mSnoozeCriteria = new ArrayMap(snoozeCriteria.size());
            for (String key : snoozeCriteria.keySet()) {
                this.mSnoozeCriteria.put(key, snoozeCriteria.getParcelableArrayList(key));
            }
        }

        private void buildShowBadgeLocked() {
            Bundle showBadge = this.mRankingUpdate.getShowBadge();
            this.mShowBadge = new ArrayMap(showBadge.size());
            for (String key : showBadge.keySet()) {
                this.mShowBadge.put(key, showBadge.getBoolean(key));
            }
        }

        private void buildUserSentimentLocked() {
            Bundle userSentiment = this.mRankingUpdate.getUserSentiment();
            this.mUserSentiment = new ArrayMap(userSentiment.size());
            for (String key : userSentiment.keySet()) {
                this.mUserSentiment.put(key, userSentiment.getInt(key));
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeParcelable(this.mRankingUpdate, flags);
        }
    }

    public static class Ranking {
        public static final int VISIBILITY_NO_OVERRIDE = -1000;
        public static final int USER_SENTIMENT_NEGATIVE = -1;
        public static final int USER_SENTIMENT_NEUTRAL = 0;
        public static final int USER_SENTIMENT_POSITIVE = 1;
        private String mKey;
        private int mRank = -1;
        private boolean mIsAmbient;
        private boolean mMatchesInterruptionFilter;
        private int mVisibilityOverride;
        private int mSuppressedVisualEffects;
        private int mImportance;
        private CharSequence mImportanceExplanation;
        private String mOverrideGroupKey;
        private NotificationChannel mChannel;
        private ArrayList<String> mOverridePeople;
        private ArrayList<SnoozeCriterion> mSnoozeCriteria;
        private boolean mShowBadge;
        private int mUserSentiment = 0;

        public String getKey() {
            return this.mKey;
        }

        public int getRank() {
            return this.mRank;
        }

        public boolean isAmbient() {
            return this.mIsAmbient;
        }

        public int getVisibilityOverride() {
            return this.mVisibilityOverride;
        }

        public int getSuppressedVisualEffects() {
            return this.mSuppressedVisualEffects;
        }

        public boolean matchesInterruptionFilter() {
            return this.mMatchesInterruptionFilter;
        }

        public int getImportance() {
            return this.mImportance;
        }

        public CharSequence getImportanceExplanation() {
            return this.mImportanceExplanation;
        }

        public String getOverrideGroupKey() {
            return this.mOverrideGroupKey;
        }

        public NotificationChannel getChannel() {
            return this.mChannel;
        }

        public int getUserSentiment() {
            return this.mUserSentiment;
        }

        @SystemApi
        public List<String> getAdditionalPeople() {
            return this.mOverridePeople;
        }

        @SystemApi
        public List<SnoozeCriterion> getSnoozeCriteria() {
            return this.mSnoozeCriteria;
        }

        public boolean canShowBadge() {
            return this.mShowBadge;
        }

        @VisibleForTesting
        public void populate(String key, int rank, boolean matchesInterruptionFilter, int visibilityOverride, int suppressedVisualEffects, int importance, CharSequence explanation, String overrideGroupKey, NotificationChannel channel, ArrayList<String> overridePeople, ArrayList<SnoozeCriterion> snoozeCriteria, boolean showBadge, int userSentiment) {
            this.mKey = key;
            this.mRank = rank;
            this.mIsAmbient = importance < 2;
            this.mMatchesInterruptionFilter = matchesInterruptionFilter;
            this.mVisibilityOverride = visibilityOverride;
            this.mSuppressedVisualEffects = suppressedVisualEffects;
            this.mImportance = importance;
            this.mImportanceExplanation = explanation;
            this.mOverrideGroupKey = overrideGroupKey;
            this.mChannel = channel;
            this.mOverridePeople = overridePeople;
            this.mSnoozeCriteria = snoozeCriteria;
            this.mShowBadge = showBadge;
            this.mUserSentiment = userSentiment;
        }

        public static String importanceToString(int importance) {
            switch (importance) {
                case -1000: {
                    return "UNSPECIFIED";
                }
                case 0: {
                    return "NONE";
                }
                case 1: {
                    return "MIN";
                }
                case 2: {
                    return "LOW";
                }
                case 3: {
                    return "DEFAULT";
                }
                case 4: 
                case 5: {
                    return "HIGH";
                }
            }
            return "UNKNOWN(" + String.valueOf(importance) + ")";
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface UserSentiment {
        }
    }

    protected class NotificationListenerWrapper
    extends INotificationListener.Stub {
        protected NotificationListenerWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNotificationPosted(IStatusBarNotificationHolder sbnHolder, NotificationRankingUpdate update) {
            StatusBarNotification sbn;
            try {
                sbn = sbnHolder.get();
            }
            catch (RemoteException e) {
                Log.w(NotificationListenerService.this.TAG, "onNotificationPosted: Error receiving StatusBarNotification", e);
                return;
            }
            try {
                NotificationListenerService.this.createLegacyIconExtras(sbn.getNotification());
                NotificationListenerService.this.maybePopulateRemoteViews(sbn.getNotification());
            }
            catch (IllegalArgumentException e) {
                Log.w(NotificationListenerService.this.TAG, "onNotificationPosted: can't rebuild notification from " + sbn.getPackageName());
                sbn = null;
            }
            Object object = NotificationListenerService.this.mLock;
            synchronized (object) {
                NotificationListenerService.this.applyUpdateLocked(update);
                if (sbn != null) {
                    SomeArgs args = SomeArgs.obtain();
                    args.arg1 = sbn;
                    args.arg2 = NotificationListenerService.this.mRankingMap;
                    NotificationListenerService.this.mHandler.obtainMessage(1, args).sendToTarget();
                } else {
                    NotificationListenerService.this.mHandler.obtainMessage(4, NotificationListenerService.this.mRankingMap).sendToTarget();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNotificationRemoved(IStatusBarNotificationHolder sbnHolder, NotificationRankingUpdate update, NotificationStats stats, int reason) {
            StatusBarNotification sbn;
            try {
                sbn = sbnHolder.get();
            }
            catch (RemoteException e) {
                Log.w(NotificationListenerService.this.TAG, "onNotificationRemoved: Error receiving StatusBarNotification", e);
                return;
            }
            Object object = NotificationListenerService.this.mLock;
            synchronized (object) {
                NotificationListenerService.this.applyUpdateLocked(update);
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = sbn;
                args.arg2 = NotificationListenerService.this.mRankingMap;
                args.arg3 = reason;
                args.arg4 = stats;
                NotificationListenerService.this.mHandler.obtainMessage(2, args).sendToTarget();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onListenerConnected(NotificationRankingUpdate update) {
            Object object = NotificationListenerService.this.mLock;
            synchronized (object) {
                NotificationListenerService.this.applyUpdateLocked(update);
            }
            NotificationListenerService.this.isConnected = true;
            NotificationListenerService.this.mHandler.obtainMessage(3).sendToTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNotificationRankingUpdate(NotificationRankingUpdate update) throws RemoteException {
            Object object = NotificationListenerService.this.mLock;
            synchronized (object) {
                NotificationListenerService.this.applyUpdateLocked(update);
                NotificationListenerService.this.mHandler.obtainMessage(4, NotificationListenerService.this.mRankingMap).sendToTarget();
            }
        }

        @Override
        public void onListenerHintsChanged(int hints) throws RemoteException {
            NotificationListenerService.this.mHandler.obtainMessage(5, hints, 0).sendToTarget();
        }

        @Override
        public void onInterruptionFilterChanged(int interruptionFilter) throws RemoteException {
            NotificationListenerService.this.mHandler.obtainMessage(6, interruptionFilter, 0).sendToTarget();
        }

        @Override
        public void onNotificationEnqueued(IStatusBarNotificationHolder notificationHolder) throws RemoteException {
        }

        @Override
        public void onNotificationSnoozedUntilContext(IStatusBarNotificationHolder notificationHolder, String snoozeCriterionId) throws RemoteException {
        }

        @Override
        public void onNotificationChannelModification(String pkgName, UserHandle user, NotificationChannel channel, int modificationType) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = pkgName;
            args.arg2 = user;
            args.arg3 = channel;
            args.arg4 = modificationType;
            NotificationListenerService.this.mHandler.obtainMessage(7, args).sendToTarget();
        }

        @Override
        public void onNotificationChannelGroupModification(String pkgName, UserHandle user, NotificationChannelGroup group, int modificationType) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = pkgName;
            args.arg2 = user;
            args.arg3 = group;
            args.arg4 = modificationType;
            NotificationListenerService.this.mHandler.obtainMessage(8, args).sendToTarget();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ChannelOrGroupModificationTypes {
    }
}

