/*
 * Decompiled with CFR 0.152.
 */
package android.service.textclassifier;

import android.annotation.SystemApi;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.CancellationSignal;
import android.os.IBinder;
import android.os.RemoteException;
import android.service.textclassifier.ITextClassificationCallback;
import android.service.textclassifier.ITextClassifierService;
import android.service.textclassifier.ITextLinksCallback;
import android.service.textclassifier.ITextSelectionCallback;
import android.text.TextUtils;
import android.util.Slog;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextLinks;
import android.view.textclassifier.TextSelection;

@SystemApi
public abstract class TextClassifierService
extends Service {
    private static final String LOG_TAG = "TextClassifierService";
    @SystemApi
    public static final String SERVICE_INTERFACE = "android.service.textclassifier.TextClassifierService";
    private final ITextClassifierService.Stub mBinder = new ITextClassifierService.Stub(){
        private final CancellationSignal mCancellationSignal = new CancellationSignal();

        @Override
        public void onSuggestSelection(CharSequence text, int selectionStartIndex, int selectionEndIndex, TextSelection.Options options, final ITextSelectionCallback callback) throws RemoteException {
            TextClassifierService.this.onSuggestSelection(text, selectionStartIndex, selectionEndIndex, options, this.mCancellationSignal, new Callback<TextSelection>(){

                @Override
                public void onSuccess(TextSelection result) {
                    try {
                        callback.onSuccess(result);
                    }
                    catch (RemoteException e) {
                        Slog.d(TextClassifierService.LOG_TAG, "Error calling callback");
                    }
                }

                @Override
                public void onFailure(CharSequence error) {
                    try {
                        if (callback.asBinder().isBinderAlive()) {
                            callback.onFailure();
                        }
                    }
                    catch (RemoteException e) {
                        Slog.d(TextClassifierService.LOG_TAG, "Error calling callback");
                    }
                }
            });
        }

        @Override
        public void onClassifyText(CharSequence text, int startIndex, int endIndex, TextClassification.Options options, final ITextClassificationCallback callback) throws RemoteException {
            TextClassifierService.this.onClassifyText(text, startIndex, endIndex, options, this.mCancellationSignal, new Callback<TextClassification>(){

                @Override
                public void onSuccess(TextClassification result) {
                    try {
                        callback.onSuccess(result);
                    }
                    catch (RemoteException e) {
                        Slog.d(TextClassifierService.LOG_TAG, "Error calling callback");
                    }
                }

                @Override
                public void onFailure(CharSequence error) {
                    try {
                        callback.onFailure();
                    }
                    catch (RemoteException e) {
                        Slog.d(TextClassifierService.LOG_TAG, "Error calling callback");
                    }
                }
            });
        }

        @Override
        public void onGenerateLinks(CharSequence text, TextLinks.Options options, final ITextLinksCallback callback) throws RemoteException {
            TextClassifierService.this.onGenerateLinks(text, options, this.mCancellationSignal, new Callback<TextLinks>(){

                @Override
                public void onSuccess(TextLinks result) {
                    try {
                        callback.onSuccess(result);
                    }
                    catch (RemoteException e) {
                        Slog.d(TextClassifierService.LOG_TAG, "Error calling callback");
                    }
                }

                @Override
                public void onFailure(CharSequence error) {
                    try {
                        callback.onFailure();
                    }
                    catch (RemoteException e) {
                        Slog.d(TextClassifierService.LOG_TAG, "Error calling callback");
                    }
                }
            });
        }
    };

    @Override
    public final IBinder onBind(Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            return this.mBinder;
        }
        return null;
    }

    public abstract void onSuggestSelection(CharSequence var1, int var2, int var3, TextSelection.Options var4, CancellationSignal var5, Callback<TextSelection> var6);

    public abstract void onClassifyText(CharSequence var1, int var2, int var3, TextClassification.Options var4, CancellationSignal var5, Callback<TextClassification> var6);

    public abstract void onGenerateLinks(CharSequence var1, TextLinks.Options var2, CancellationSignal var3, Callback<TextLinks> var4);

    public static ComponentName getServiceComponentName(Context context) {
        String str = context.getString(17039653);
        if (!TextUtils.isEmpty(str)) {
            try {
                String permission2;
                ComponentName componentName = ComponentName.unflattenFromString(str);
                Intent intent = new Intent(SERVICE_INTERFACE).setComponent(componentName);
                ServiceInfo si = context.getPackageManager().getServiceInfo(intent.getComponent(), 0);
                String string2 = permission2 = si == null ? null : si.permission;
                if ("android.permission.BIND_TEXTCLASSIFIER_SERVICE".equals(permission2)) {
                    return componentName;
                }
                Slog.w(LOG_TAG, String.format("Service %s should require %s permission. Found %s permission", intent.getComponent().flattenToString(), "android.permission.BIND_TEXTCLASSIFIER_SERVICE", si.permission));
            }
            catch (PackageManager.NameNotFoundException e) {
                Slog.w(LOG_TAG, String.format("Service %s not found", str));
            }
        } else {
            Slog.d(LOG_TAG, "No configured system TextClassifierService");
        }
        return null;
    }

    @SystemApi
    public static interface Callback<T> {
        public void onSuccess(T var1);

        public void onFailure(CharSequence var1);
    }
}

