/*
 * Decompiled with CFR 0.152.
 */
package android.service.voice;

import android.R;
import android.app.Dialog;
import android.app.Instrumentation;
import android.app.VoiceInteractor;
import android.app.assist.AssistContent;
import android.app.assist.AssistStructure;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.Region;
import android.inputmethodservice.SoftInputWindow;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.UserHandle;
import android.service.voice.IVoiceInteractionSession;
import android.util.ArrayMap;
import android.util.DebugUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.android.internal.app.IVoiceInteractionManagerService;
import com.android.internal.app.IVoiceInteractionSessionShowCallback;
import com.android.internal.app.IVoiceInteractor;
import com.android.internal.app.IVoiceInteractorCallback;
import com.android.internal.app.IVoiceInteractorRequest;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.SomeArgs;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;

public class VoiceInteractionSession
implements KeyEvent.Callback,
ComponentCallbacks2 {
    static final String TAG = "VoiceInteractionSession";
    static final boolean DEBUG = false;
    public static final int SHOW_WITH_ASSIST = 1;
    public static final int SHOW_WITH_SCREENSHOT = 2;
    public static final int SHOW_SOURCE_ASSIST_GESTURE = 4;
    public static final int SHOW_SOURCE_APPLICATION = 8;
    public static final int SHOW_SOURCE_ACTIVITY = 16;
    final Context mContext;
    final HandlerCaller mHandlerCaller;
    final KeyEvent.DispatcherState mDispatcherState = new KeyEvent.DispatcherState();
    IVoiceInteractionManagerService mSystemService;
    IBinder mToken;
    int mTheme = 0;
    LayoutInflater mInflater;
    TypedArray mThemeAttrs;
    View mRootView;
    FrameLayout mContentFrame;
    SoftInputWindow mWindow;
    boolean mUiEnabled = true;
    boolean mInitialized;
    boolean mWindowAdded;
    boolean mWindowVisible;
    boolean mWindowWasVisible;
    boolean mInShowWindow;
    final ArrayMap<IBinder, Request> mActiveRequests = new ArrayMap();
    final Insets mTmpInsets = new Insets();
    final WeakReference<VoiceInteractionSession> mWeakRef = new WeakReference<VoiceInteractionSession>(this);
    final IVoiceInteractor mInteractor = new IVoiceInteractor.Stub(){

        @Override
        public IVoiceInteractorRequest startConfirmation(String callingPackage, IVoiceInteractorCallback callback, VoiceInteractor.Prompt prompt, Bundle extras) {
            ConfirmationRequest request = new ConfirmationRequest(callingPackage, Binder.getCallingUid(), callback, VoiceInteractionSession.this, prompt, extras);
            VoiceInteractionSession.this.addRequest(request);
            VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessageO(1, request));
            return request.mInterface;
        }

        @Override
        public IVoiceInteractorRequest startPickOption(String callingPackage, IVoiceInteractorCallback callback, VoiceInteractor.Prompt prompt, VoiceInteractor.PickOptionRequest.Option[] options, Bundle extras) {
            PickOptionRequest request = new PickOptionRequest(callingPackage, Binder.getCallingUid(), callback, VoiceInteractionSession.this, prompt, options, extras);
            VoiceInteractionSession.this.addRequest(request);
            VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessageO(2, request));
            return request.mInterface;
        }

        @Override
        public IVoiceInteractorRequest startCompleteVoice(String callingPackage, IVoiceInteractorCallback callback, VoiceInteractor.Prompt message, Bundle extras) {
            CompleteVoiceRequest request = new CompleteVoiceRequest(callingPackage, Binder.getCallingUid(), callback, VoiceInteractionSession.this, message, extras);
            VoiceInteractionSession.this.addRequest(request);
            VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessageO(3, request));
            return request.mInterface;
        }

        @Override
        public IVoiceInteractorRequest startAbortVoice(String callingPackage, IVoiceInteractorCallback callback, VoiceInteractor.Prompt message, Bundle extras) {
            AbortVoiceRequest request = new AbortVoiceRequest(callingPackage, Binder.getCallingUid(), callback, VoiceInteractionSession.this, message, extras);
            VoiceInteractionSession.this.addRequest(request);
            VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessageO(4, request));
            return request.mInterface;
        }

        @Override
        public IVoiceInteractorRequest startCommand(String callingPackage, IVoiceInteractorCallback callback, String command, Bundle extras) {
            CommandRequest request = new CommandRequest(callingPackage, Binder.getCallingUid(), callback, VoiceInteractionSession.this, command, extras);
            VoiceInteractionSession.this.addRequest(request);
            VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessageO(5, request));
            return request.mInterface;
        }

        @Override
        public boolean[] supportsCommands(String callingPackage, String[] commands) {
            Message msg = VoiceInteractionSession.this.mHandlerCaller.obtainMessageIOO(6, 0, commands, null);
            SomeArgs args = VoiceInteractionSession.this.mHandlerCaller.sendMessageAndWait(msg);
            if (args != null) {
                boolean[] res = (boolean[])args.arg1;
                args.recycle();
                return res;
            }
            return new boolean[commands.length];
        }
    };
    final IVoiceInteractionSession mSession = new IVoiceInteractionSession.Stub(){

        @Override
        public void show(Bundle sessionArgs, int flags, IVoiceInteractionSessionShowCallback showCallback) {
            VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessageIOO(106, flags, sessionArgs, showCallback));
        }

        @Override
        public void hide() {
            VoiceInteractionSession.this.mHandlerCaller.removeMessages(106);
            VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessage(107));
        }

        @Override
        public void handleAssist(final Bundle data, final AssistStructure structure, final AssistContent content, final int index, final int count) {
            Thread retriever = new Thread("AssistStructure retriever"){

                @Override
                public void run() {
                    Throwable failure = null;
                    if (structure != null) {
                        try {
                            structure.ensureData();
                        }
                        catch (Throwable e) {
                            Log.w(VoiceInteractionSession.TAG, "Failure retrieving AssistStructure", e);
                            failure = e;
                        }
                    }
                    VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessageOOOOII(104, data, failure == null ? structure : null, failure, content, index, count));
                }
            };
            retriever.start();
        }

        @Override
        public void handleScreenshot(Bitmap screenshot) {
            VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessageO(105, screenshot));
        }

        @Override
        public void taskStarted(Intent intent, int taskId) {
            VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessageIO(100, taskId, intent));
        }

        @Override
        public void taskFinished(Intent intent, int taskId) {
            VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessageIO(101, taskId, intent));
        }

        @Override
        public void closeSystemDialogs() {
            VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessage(102));
        }

        @Override
        public void onLockscreenShown() {
            VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessage(108));
        }

        @Override
        public void destroy() {
            VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessage(103));
        }
    };
    static final int MSG_START_CONFIRMATION = 1;
    static final int MSG_START_PICK_OPTION = 2;
    static final int MSG_START_COMPLETE_VOICE = 3;
    static final int MSG_START_ABORT_VOICE = 4;
    static final int MSG_START_COMMAND = 5;
    static final int MSG_SUPPORTS_COMMANDS = 6;
    static final int MSG_CANCEL = 7;
    static final int MSG_TASK_STARTED = 100;
    static final int MSG_TASK_FINISHED = 101;
    static final int MSG_CLOSE_SYSTEM_DIALOGS = 102;
    static final int MSG_DESTROY = 103;
    static final int MSG_HANDLE_ASSIST = 104;
    static final int MSG_HANDLE_SCREENSHOT = 105;
    static final int MSG_SHOW = 106;
    static final int MSG_HIDE = 107;
    static final int MSG_ON_LOCKSCREEN_SHOWN = 108;
    final MyCallbacks mCallbacks = new MyCallbacks();
    final ViewTreeObserver.OnComputeInternalInsetsListener mInsetsComputer = new ViewTreeObserver.OnComputeInternalInsetsListener(){

        @Override
        public void onComputeInternalInsets(ViewTreeObserver.InternalInsetsInfo info) {
            VoiceInteractionSession.this.onComputeInsets(VoiceInteractionSession.this.mTmpInsets);
            info.contentInsets.set(VoiceInteractionSession.this.mTmpInsets.contentInsets);
            info.visibleInsets.set(VoiceInteractionSession.this.mTmpInsets.contentInsets);
            info.touchableRegion.set(VoiceInteractionSession.this.mTmpInsets.touchableRegion);
            info.setTouchableInsets(VoiceInteractionSession.this.mTmpInsets.touchableInsets);
        }
    };

    public VoiceInteractionSession(Context context) {
        this(context, new Handler());
    }

    public VoiceInteractionSession(Context context, Handler handler) {
        this.mContext = context;
        this.mHandlerCaller = new HandlerCaller(context, handler.getLooper(), this.mCallbacks, true);
    }

    public Context getContext() {
        return this.mContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRequest(Request req) {
        VoiceInteractionSession voiceInteractionSession = this;
        synchronized (voiceInteractionSession) {
            this.mActiveRequests.put(req.mInterface.asBinder(), req);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isRequestActive(IBinder reqInterface) {
        VoiceInteractionSession voiceInteractionSession = this;
        synchronized (voiceInteractionSession) {
            return this.mActiveRequests.containsKey(reqInterface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Request removeRequest(IBinder reqInterface) {
        VoiceInteractionSession voiceInteractionSession = this;
        synchronized (voiceInteractionSession) {
            return this.mActiveRequests.remove(reqInterface);
        }
    }

    void doCreate(IVoiceInteractionManagerService service, IBinder token) {
        this.mSystemService = service;
        this.mToken = token;
        this.onCreate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doShow(Bundle args, int flags, final IVoiceInteractionSessionShowCallback showCallback) {
        if (this.mInShowWindow) {
            Log.w(TAG, "Re-entrance in to showWindow");
            return;
        }
        try {
            this.mInShowWindow = true;
            this.onPrepareShow(args, flags);
            if (!this.mWindowVisible) {
                this.ensureWindowAdded();
            }
            this.onShow(args, flags);
            if (!this.mWindowVisible) {
                this.mWindowVisible = true;
                if (this.mUiEnabled) {
                    this.mWindow.show();
                }
            }
            if (showCallback != null) {
                if (this.mUiEnabled) {
                    this.mRootView.invalidate();
                    this.mRootView.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                        @Override
                        public boolean onPreDraw() {
                            VoiceInteractionSession.this.mRootView.getViewTreeObserver().removeOnPreDrawListener(this);
                            try {
                                showCallback.onShown();
                            }
                            catch (RemoteException e) {
                                Log.w(VoiceInteractionSession.TAG, "Error calling onShown", e);
                            }
                            return true;
                        }
                    });
                } else {
                    try {
                        showCallback.onShown();
                    }
                    catch (RemoteException e) {
                        Log.w(TAG, "Error calling onShown", e);
                    }
                }
            }
        }
        finally {
            this.mWindowWasVisible = true;
            this.mInShowWindow = false;
        }
    }

    void doHide() {
        if (this.mWindowVisible) {
            this.ensureWindowHidden();
            this.mWindowVisible = false;
            this.onHide();
        }
    }

    void doDestroy() {
        this.onDestroy();
        if (this.mInitialized) {
            this.mRootView.getViewTreeObserver().removeOnComputeInternalInsetsListener(this.mInsetsComputer);
            if (this.mWindowAdded) {
                this.mWindow.dismiss();
                this.mWindowAdded = false;
            }
            this.mInitialized = false;
        }
    }

    void ensureWindowCreated() {
        if (this.mInitialized) {
            return;
        }
        if (!this.mUiEnabled) {
            throw new IllegalStateException("setUiEnabled is false");
        }
        this.mInitialized = true;
        this.mInflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        this.mWindow = new SoftInputWindow(this.mContext, TAG, this.mTheme, this.mCallbacks, this, this.mDispatcherState, 2031, 80, true);
        this.mWindow.getWindow().addFlags(0x1010100);
        this.mThemeAttrs = this.mContext.obtainStyledAttributes(R.styleable.VoiceInteractionSession);
        this.mRootView = this.mInflater.inflate(17367319, null);
        this.mRootView.setSystemUiVisibility(1792);
        this.mWindow.setContentView(this.mRootView);
        this.mRootView.getViewTreeObserver().addOnComputeInternalInsetsListener(this.mInsetsComputer);
        this.mContentFrame = (FrameLayout)this.mRootView.findViewById(0x1020002);
        this.mWindow.getWindow().setLayout(-1, -1);
        this.mWindow.setToken(this.mToken);
    }

    void ensureWindowAdded() {
        if (this.mUiEnabled && !this.mWindowAdded) {
            this.mWindowAdded = true;
            this.ensureWindowCreated();
            View v = this.onCreateContentView();
            if (v != null) {
                this.setContentView(v);
            }
        }
    }

    void ensureWindowHidden() {
        if (this.mWindow != null) {
            this.mWindow.hide();
        }
    }

    public void setDisabledShowContext(int flags) {
        try {
            this.mSystemService.setDisabledShowContext(flags);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public int getDisabledShowContext() {
        try {
            return this.mSystemService.getDisabledShowContext();
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    public int getUserDisabledShowContext() {
        try {
            return this.mSystemService.getUserDisabledShowContext();
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    public void show(Bundle args, int flags) {
        if (this.mToken == null) {
            throw new IllegalStateException("Can't call before onCreate()");
        }
        try {
            this.mSystemService.showSessionFromSession(this.mToken, args, flags);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void hide() {
        if (this.mToken == null) {
            throw new IllegalStateException("Can't call before onCreate()");
        }
        try {
            this.mSystemService.hideSessionFromSession(this.mToken);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setUiEnabled(boolean enabled) {
        if (this.mUiEnabled != enabled) {
            this.mUiEnabled = enabled;
            if (this.mWindowVisible) {
                if (enabled) {
                    this.ensureWindowAdded();
                    this.mWindow.show();
                } else {
                    this.ensureWindowHidden();
                }
            }
        }
    }

    public void setTheme(int theme) {
        if (this.mWindow != null) {
            throw new IllegalStateException("Must be called before onCreate()");
        }
        this.mTheme = theme;
    }

    public void startVoiceActivity(Intent intent) {
        if (this.mToken == null) {
            throw new IllegalStateException("Can't call before onCreate()");
        }
        try {
            intent.migrateExtraStreamToClipData();
            intent.prepareToLeaveProcess(this.mContext);
            int res = this.mSystemService.startVoiceActivity(this.mToken, intent, intent.resolveType(this.mContext.getContentResolver()));
            Instrumentation.checkStartActivityResult(res, intent);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void startAssistantActivity(Intent intent) {
        if (this.mToken == null) {
            throw new IllegalStateException("Can't call before onCreate()");
        }
        try {
            intent.migrateExtraStreamToClipData();
            intent.prepareToLeaveProcess(this.mContext);
            int res = this.mSystemService.startAssistantActivity(this.mToken, intent, intent.resolveType(this.mContext.getContentResolver()));
            Instrumentation.checkStartActivityResult(res, intent);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setKeepAwake(boolean keepAwake) {
        if (this.mToken == null) {
            throw new IllegalStateException("Can't call before onCreate()");
        }
        try {
            this.mSystemService.setKeepAwake(this.mToken, keepAwake);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void closeSystemDialogs() {
        if (this.mToken == null) {
            throw new IllegalStateException("Can't call before onCreate()");
        }
        try {
            this.mSystemService.closeSystemDialogs(this.mToken);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public LayoutInflater getLayoutInflater() {
        this.ensureWindowCreated();
        return this.mInflater;
    }

    public Dialog getWindow() {
        this.ensureWindowCreated();
        return this.mWindow;
    }

    public void finish() {
        if (this.mToken == null) {
            throw new IllegalStateException("Can't call before onCreate()");
        }
        try {
            this.mSystemService.finish(this.mToken);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void onCreate() {
        this.doOnCreate();
    }

    private void doOnCreate() {
        this.mTheme = this.mTheme != 0 ? this.mTheme : 16974799;
    }

    public void onPrepareShow(Bundle args, int showFlags) {
    }

    public void onShow(Bundle args, int showFlags) {
    }

    public void onHide() {
    }

    public void onDestroy() {
    }

    public View onCreateContentView() {
        return null;
    }

    public void setContentView(View view) {
        this.ensureWindowCreated();
        this.mContentFrame.removeAllViews();
        this.mContentFrame.addView(view, new FrameLayout.LayoutParams(-1, -1));
        this.mContentFrame.requestApplyInsets();
    }

    void doOnHandleAssist(Bundle data, AssistStructure structure, Throwable failure, AssistContent content) {
        if (failure != null) {
            this.onAssistStructureFailure(failure);
        }
        this.onHandleAssist(data, structure, content);
    }

    void doOnHandleAssistSecondary(Bundle data, AssistStructure structure, Throwable failure, AssistContent content, int index, int count) {
        if (failure != null) {
            this.onAssistStructureFailure(failure);
        }
        this.onHandleAssistSecondary(data, structure, content, index, count);
    }

    public void onAssistStructureFailure(Throwable failure) {
    }

    public void onHandleAssist(Bundle data, AssistStructure structure, AssistContent content) {
    }

    public void onHandleAssistSecondary(Bundle data, AssistStructure structure, AssistContent content, int index, int count) {
    }

    public void onHandleScreenshot(Bitmap screenshot) {
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return false;
    }

    @Override
    public boolean onKeyLongPress(int keyCode, KeyEvent event) {
        return false;
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        return false;
    }

    @Override
    public boolean onKeyMultiple(int keyCode, int count, KeyEvent event) {
        return false;
    }

    public void onBackPressed() {
        this.hide();
    }

    public void onCloseSystemDialogs() {
        this.hide();
    }

    public void onLockscreenShown() {
        this.hide();
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
    }

    @Override
    public void onLowMemory() {
    }

    @Override
    public void onTrimMemory(int level) {
    }

    public void onComputeInsets(Insets outInsets) {
        outInsets.contentInsets.left = 0;
        outInsets.contentInsets.bottom = 0;
        outInsets.contentInsets.right = 0;
        View decor = this.getWindow().getWindow().getDecorView();
        outInsets.contentInsets.top = decor.getHeight();
        outInsets.touchableInsets = 0;
        outInsets.touchableRegion.setEmpty();
    }

    public void onTaskStarted(Intent intent, int taskId) {
    }

    public void onTaskFinished(Intent intent, int taskId) {
        this.hide();
    }

    public boolean[] onGetSupportedCommands(String[] commands) {
        return new boolean[commands.length];
    }

    public void onRequestConfirmation(ConfirmationRequest request) {
    }

    public void onRequestPickOption(PickOptionRequest request) {
    }

    public void onRequestCompleteVoice(CompleteVoiceRequest request) {
    }

    public void onRequestAbortVoice(AbortVoiceRequest request) {
    }

    public void onRequestCommand(CommandRequest request) {
    }

    public void onCancelRequest(Request request) {
    }

    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        writer.print(prefix);
        writer.print("mToken=");
        writer.println(this.mToken);
        writer.print(prefix);
        writer.print("mTheme=#");
        writer.println(Integer.toHexString(this.mTheme));
        writer.print(prefix);
        writer.print("mUiEnabled=");
        writer.println(this.mUiEnabled);
        writer.print(" mInitialized=");
        writer.println(this.mInitialized);
        writer.print(prefix);
        writer.print("mWindowAdded=");
        writer.print(this.mWindowAdded);
        writer.print(" mWindowVisible=");
        writer.println(this.mWindowVisible);
        writer.print(prefix);
        writer.print("mWindowWasVisible=");
        writer.print(this.mWindowWasVisible);
        writer.print(" mInShowWindow=");
        writer.println(this.mInShowWindow);
        if (this.mActiveRequests.size() > 0) {
            writer.print(prefix);
            writer.println("Active requests:");
            String innerPrefix = prefix + "    ";
            for (int i = 0; i < this.mActiveRequests.size(); ++i) {
                Request req = this.mActiveRequests.valueAt(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(i);
                writer.print(": ");
                writer.println(req);
                req.dump(innerPrefix, fd, writer, args);
            }
        }
    }

    public static final class Insets {
        public final Rect contentInsets = new Rect();
        public final Region touchableRegion = new Region();
        public static final int TOUCHABLE_INSETS_FRAME = 0;
        public static final int TOUCHABLE_INSETS_CONTENT = 1;
        public static final int TOUCHABLE_INSETS_REGION = 3;
        public int touchableInsets;
    }

    class MyCallbacks
    implements HandlerCaller.Callback,
    SoftInputWindow.Callback {
        MyCallbacks() {
        }

        @Override
        public void executeMessage(Message msg) {
            SomeArgs args = null;
            switch (msg.what) {
                case 1: {
                    VoiceInteractionSession.this.onRequestConfirmation((ConfirmationRequest)msg.obj);
                    break;
                }
                case 2: {
                    VoiceInteractionSession.this.onRequestPickOption((PickOptionRequest)msg.obj);
                    break;
                }
                case 3: {
                    VoiceInteractionSession.this.onRequestCompleteVoice((CompleteVoiceRequest)msg.obj);
                    break;
                }
                case 4: {
                    VoiceInteractionSession.this.onRequestAbortVoice((AbortVoiceRequest)msg.obj);
                    break;
                }
                case 5: {
                    VoiceInteractionSession.this.onRequestCommand((CommandRequest)msg.obj);
                    break;
                }
                case 6: {
                    args = (SomeArgs)msg.obj;
                    args.arg1 = VoiceInteractionSession.this.onGetSupportedCommands((String[])args.arg1);
                    args.complete();
                    args = null;
                    break;
                }
                case 7: {
                    VoiceInteractionSession.this.onCancelRequest((Request)msg.obj);
                    break;
                }
                case 100: {
                    VoiceInteractionSession.this.onTaskStarted((Intent)msg.obj, msg.arg1);
                    break;
                }
                case 101: {
                    VoiceInteractionSession.this.onTaskFinished((Intent)msg.obj, msg.arg1);
                    break;
                }
                case 102: {
                    VoiceInteractionSession.this.onCloseSystemDialogs();
                    break;
                }
                case 103: {
                    VoiceInteractionSession.this.doDestroy();
                    break;
                }
                case 104: {
                    args = (SomeArgs)msg.obj;
                    if (args.argi5 == 0) {
                        VoiceInteractionSession.this.doOnHandleAssist((Bundle)args.arg1, (AssistStructure)args.arg2, (Throwable)args.arg3, (AssistContent)args.arg4);
                        break;
                    }
                    VoiceInteractionSession.this.doOnHandleAssistSecondary((Bundle)args.arg1, (AssistStructure)args.arg2, (Throwable)args.arg3, (AssistContent)args.arg4, args.argi5, args.argi6);
                    break;
                }
                case 105: {
                    VoiceInteractionSession.this.onHandleScreenshot((Bitmap)msg.obj);
                    break;
                }
                case 106: {
                    args = (SomeArgs)msg.obj;
                    VoiceInteractionSession.this.doShow((Bundle)args.arg1, msg.arg1, (IVoiceInteractionSessionShowCallback)args.arg2);
                    break;
                }
                case 107: {
                    VoiceInteractionSession.this.doHide();
                    break;
                }
                case 108: {
                    VoiceInteractionSession.this.onLockscreenShown();
                }
            }
            if (args != null) {
                args.recycle();
            }
        }

        @Override
        public void onBackPressed() {
            VoiceInteractionSession.this.onBackPressed();
        }
    }

    public static final class CommandRequest
    extends Request {
        final String mCommand;

        CommandRequest(String packageName, int uid, IVoiceInteractorCallback callback, VoiceInteractionSession session, String command, Bundle extras) {
            super(packageName, uid, callback, session, extras);
            this.mCommand = command;
        }

        public String getCommand() {
            return this.mCommand;
        }

        void sendCommandResult(boolean finished, Bundle result) {
            try {
                if (finished) {
                    this.finishRequest();
                }
                this.mCallback.deliverCommandResult(this.mInterface, finished, result);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public void sendIntermediateResult(Bundle result) {
            this.sendCommandResult(false, result);
        }

        public void sendResult(Bundle result) {
            this.sendCommandResult(true, result);
        }

        @Override
        void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            super.dump(prefix, fd, writer, args);
            writer.print(prefix);
            writer.print("mCommand=");
            writer.println(this.mCommand);
        }
    }

    public static final class AbortVoiceRequest
    extends Request {
        final VoiceInteractor.Prompt mPrompt;

        AbortVoiceRequest(String packageName, int uid, IVoiceInteractorCallback callback, VoiceInteractionSession session, VoiceInteractor.Prompt prompt, Bundle extras) {
            super(packageName, uid, callback, session, extras);
            this.mPrompt = prompt;
        }

        public VoiceInteractor.Prompt getVoicePrompt() {
            return this.mPrompt;
        }

        @Deprecated
        public CharSequence getMessage() {
            return this.mPrompt != null ? this.mPrompt.getVoicePromptAt(0) : null;
        }

        public void sendAbortResult(Bundle result) {
            try {
                this.finishRequest();
                this.mCallback.deliverAbortVoiceResult(this.mInterface, result);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        @Override
        void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            super.dump(prefix, fd, writer, args);
            writer.print(prefix);
            writer.print("mPrompt=");
            writer.println(this.mPrompt);
        }
    }

    public static final class CompleteVoiceRequest
    extends Request {
        final VoiceInteractor.Prompt mPrompt;

        CompleteVoiceRequest(String packageName, int uid, IVoiceInteractorCallback callback, VoiceInteractionSession session, VoiceInteractor.Prompt prompt, Bundle extras) {
            super(packageName, uid, callback, session, extras);
            this.mPrompt = prompt;
        }

        public VoiceInteractor.Prompt getVoicePrompt() {
            return this.mPrompt;
        }

        @Deprecated
        public CharSequence getMessage() {
            return this.mPrompt != null ? this.mPrompt.getVoicePromptAt(0) : null;
        }

        public void sendCompleteResult(Bundle result) {
            try {
                this.finishRequest();
                this.mCallback.deliverCompleteVoiceResult(this.mInterface, result);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        @Override
        void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            super.dump(prefix, fd, writer, args);
            writer.print(prefix);
            writer.print("mPrompt=");
            writer.println(this.mPrompt);
        }
    }

    public static final class PickOptionRequest
    extends Request {
        final VoiceInteractor.Prompt mPrompt;
        final VoiceInteractor.PickOptionRequest.Option[] mOptions;

        PickOptionRequest(String packageName, int uid, IVoiceInteractorCallback callback, VoiceInteractionSession session, VoiceInteractor.Prompt prompt, VoiceInteractor.PickOptionRequest.Option[] options, Bundle extras) {
            super(packageName, uid, callback, session, extras);
            this.mPrompt = prompt;
            this.mOptions = options;
        }

        public VoiceInteractor.Prompt getVoicePrompt() {
            return this.mPrompt;
        }

        @Deprecated
        public CharSequence getPrompt() {
            return this.mPrompt != null ? this.mPrompt.getVoicePromptAt(0) : null;
        }

        public VoiceInteractor.PickOptionRequest.Option[] getOptions() {
            return this.mOptions;
        }

        void sendPickOptionResult(boolean finished, VoiceInteractor.PickOptionRequest.Option[] selections, Bundle result) {
            try {
                if (finished) {
                    this.finishRequest();
                }
                this.mCallback.deliverPickOptionResult(this.mInterface, finished, selections, result);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public void sendIntermediatePickOptionResult(VoiceInteractor.PickOptionRequest.Option[] selections, Bundle result) {
            this.sendPickOptionResult(false, selections, result);
        }

        public void sendPickOptionResult(VoiceInteractor.PickOptionRequest.Option[] selections, Bundle result) {
            this.sendPickOptionResult(true, selections, result);
        }

        @Override
        void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            super.dump(prefix, fd, writer, args);
            writer.print(prefix);
            writer.print("mPrompt=");
            writer.println(this.mPrompt);
            if (this.mOptions != null) {
                writer.print(prefix);
                writer.println("Options:");
                for (int i = 0; i < this.mOptions.length; ++i) {
                    VoiceInteractor.PickOptionRequest.Option op = this.mOptions[i];
                    writer.print(prefix);
                    writer.print("  #");
                    writer.print(i);
                    writer.println(":");
                    writer.print(prefix);
                    writer.print("    mLabel=");
                    writer.println(op.getLabel());
                    writer.print(prefix);
                    writer.print("    mIndex=");
                    writer.println(op.getIndex());
                    if (op.countSynonyms() > 0) {
                        writer.print(prefix);
                        writer.println("    Synonyms:");
                        for (int j = 0; j < op.countSynonyms(); ++j) {
                            writer.print(prefix);
                            writer.print("      #");
                            writer.print(j);
                            writer.print(": ");
                            writer.println(op.getSynonymAt(j));
                        }
                    }
                    if (op.getExtras() == null) continue;
                    writer.print(prefix);
                    writer.print("    mExtras=");
                    writer.println(op.getExtras());
                }
            }
        }
    }

    public static final class ConfirmationRequest
    extends Request {
        final VoiceInteractor.Prompt mPrompt;

        ConfirmationRequest(String packageName, int uid, IVoiceInteractorCallback callback, VoiceInteractionSession session, VoiceInteractor.Prompt prompt, Bundle extras) {
            super(packageName, uid, callback, session, extras);
            this.mPrompt = prompt;
        }

        public VoiceInteractor.Prompt getVoicePrompt() {
            return this.mPrompt;
        }

        @Deprecated
        public CharSequence getPrompt() {
            return this.mPrompt != null ? this.mPrompt.getVoicePromptAt(0) : null;
        }

        public void sendConfirmationResult(boolean confirmed, Bundle result) {
            try {
                this.finishRequest();
                this.mCallback.deliverConfirmationResult(this.mInterface, confirmed, result);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        @Override
        void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            super.dump(prefix, fd, writer, args);
            writer.print(prefix);
            writer.print("mPrompt=");
            writer.println(this.mPrompt);
        }
    }

    public static class Request {
        final IVoiceInteractorRequest mInterface = new IVoiceInteractorRequest.Stub(){

            @Override
            public void cancel() throws RemoteException {
                VoiceInteractionSession session = (VoiceInteractionSession)mSession.get();
                if (session != null) {
                    session.mHandlerCaller.sendMessage(session.mHandlerCaller.obtainMessageO(7, this));
                }
            }
        };
        final String mCallingPackage;
        final int mCallingUid;
        final IVoiceInteractorCallback mCallback;
        final WeakReference<VoiceInteractionSession> mSession;
        final Bundle mExtras;

        Request(String packageName, int uid, IVoiceInteractorCallback callback, VoiceInteractionSession session, Bundle extras) {
            this.mCallingPackage = packageName;
            this.mCallingUid = uid;
            this.mCallback = callback;
            this.mSession = session.mWeakRef;
            this.mExtras = extras;
        }

        public int getCallingUid() {
            return this.mCallingUid;
        }

        public String getCallingPackage() {
            return this.mCallingPackage;
        }

        public Bundle getExtras() {
            return this.mExtras;
        }

        public boolean isActive() {
            VoiceInteractionSession session = (VoiceInteractionSession)this.mSession.get();
            if (session == null) {
                return false;
            }
            return session.isRequestActive(this.mInterface.asBinder());
        }

        void finishRequest() {
            VoiceInteractionSession session = (VoiceInteractionSession)this.mSession.get();
            if (session == null) {
                throw new IllegalStateException("VoiceInteractionSession has been destroyed");
            }
            Request req = session.removeRequest(this.mInterface.asBinder());
            if (req == null) {
                throw new IllegalStateException("Request not active: " + this);
            }
            if (req != this) {
                throw new IllegalStateException("Current active request " + req + " not same as calling request " + this);
            }
        }

        public void cancel() {
            try {
                this.finishRequest();
                this.mCallback.deliverCancel(this.mInterface);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            DebugUtils.buildShortClassTag(this, sb);
            sb.append(" ");
            sb.append(this.mInterface.asBinder());
            sb.append(" pkg=");
            sb.append(this.mCallingPackage);
            sb.append(" uid=");
            UserHandle.formatUid(sb, this.mCallingUid);
            sb.append('}');
            return sb.toString();
        }

        void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            writer.print(prefix);
            writer.print("mInterface=");
            writer.println(this.mInterface.asBinder());
            writer.print(prefix);
            writer.print("mCallingPackage=");
            writer.print(this.mCallingPackage);
            writer.print(" mCallingUid=");
            UserHandle.formatUid(writer, this.mCallingUid);
            writer.println();
            writer.print(prefix);
            writer.print("mCallback=");
            writer.println(this.mCallback.asBinder());
            if (this.mExtras != null) {
                writer.print(prefix);
                writer.print("mExtras=");
                writer.println(this.mExtras);
            }
        }
    }
}

