/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.provider.Settings;
import android.speech.tts.TextToSpeech;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;

public class TtsEngines {
    private static final String TAG = "TtsEngines";
    private static final boolean DBG = false;
    private static final String LOCALE_DELIMITER_OLD = "-";
    private static final String LOCALE_DELIMITER_NEW = "_";
    private final Context mContext;
    private static final Map<String, String> sNormalizeLanguage;
    private static final Map<String, String> sNormalizeCountry;
    private static final String XML_TAG_NAME = "tts-engine";

    public TtsEngines(Context ctx) {
        this.mContext = ctx;
    }

    public String getDefaultEngine() {
        String engine = Settings.Secure.getString(this.mContext.getContentResolver(), "tts_default_synth");
        return this.isEngineInstalled(engine) ? engine : this.getHighestRankedEngineName();
    }

    public String getHighestRankedEngineName() {
        List<TextToSpeech.EngineInfo> engines = this.getEngines();
        if (engines.size() > 0 && engines.get((int)0).system) {
            return engines.get((int)0).name;
        }
        return null;
    }

    public TextToSpeech.EngineInfo getEngineInfo(String packageName) {
        PackageManager pm = this.mContext.getPackageManager();
        Intent intent = new Intent("android.intent.action.TTS_SERVICE");
        intent.setPackage(packageName);
        List<ResolveInfo> resolveInfos = pm.queryIntentServices(intent, 65536);
        if (resolveInfos != null && resolveInfos.size() == 1) {
            return this.getEngineInfo(resolveInfos.get(0), pm);
        }
        return null;
    }

    public List<TextToSpeech.EngineInfo> getEngines() {
        Intent intent;
        PackageManager pm = this.mContext.getPackageManager();
        List<ResolveInfo> resolveInfos = pm.queryIntentServices(intent = new Intent("android.intent.action.TTS_SERVICE"), 65536);
        if (resolveInfos == null) {
            return Collections.emptyList();
        }
        ArrayList<TextToSpeech.EngineInfo> engines = new ArrayList<TextToSpeech.EngineInfo>(resolveInfos.size());
        for (ResolveInfo resolveInfo : resolveInfos) {
            TextToSpeech.EngineInfo engine = this.getEngineInfo(resolveInfo, pm);
            if (engine == null) continue;
            engines.add(engine);
        }
        Collections.sort(engines, EngineInfoComparator.INSTANCE);
        return engines;
    }

    private boolean isSystemEngine(ServiceInfo info) {
        ApplicationInfo appInfo = info.applicationInfo;
        return appInfo != null && (appInfo.flags & 1) != 0;
    }

    public boolean isEngineInstalled(String engine) {
        if (engine == null) {
            return false;
        }
        return this.getEngineInfo(engine) != null;
    }

    public Intent getSettingsIntent(String engine) {
        String settings;
        ServiceInfo service;
        PackageManager pm = this.mContext.getPackageManager();
        Intent intent = new Intent("android.intent.action.TTS_SERVICE");
        intent.setPackage(engine);
        List<ResolveInfo> resolveInfos = pm.queryIntentServices(intent, 65664);
        if (resolveInfos != null && resolveInfos.size() == 1 && (service = resolveInfos.get((int)0).serviceInfo) != null && (settings = this.settingsActivityFromServiceInfo(service, pm)) != null) {
            Intent i = new Intent();
            i.setClassName(engine, settings);
            return i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String settingsActivityFromServiceInfo(ServiceInfo si, PackageManager pm) {
        try (XmlResourceParser parser = null;){
            int type;
            parser = si.loadXmlMetaData(pm, "android.speech.tts");
            if (parser == null) {
                Log.w(TAG, "No meta-data found for :" + si);
                String string2 = null;
                return string2;
            }
            Resources res = pm.getResourcesForApplication(si.applicationInfo);
            while ((type = parser.next()) != 1) {
                if (type != 2) continue;
                if (!XML_TAG_NAME.equals(parser.getName())) {
                    Log.w(TAG, "Package " + si + " uses unknown tag :" + parser.getName());
                    String string3 = null;
                    return string3;
                }
                AttributeSet attrs = Xml.asAttributeSet(parser);
                TypedArray array2 = res.obtainAttributes(attrs, R.styleable.TextToSpeechEngine);
                String settings = array2.getString(0);
                array2.recycle();
                String string4 = settings;
                return string4;
            }
            String string5 = null;
            return string5;
        }
    }

    private TextToSpeech.EngineInfo getEngineInfo(ResolveInfo resolve, PackageManager pm) {
        ServiceInfo service = resolve.serviceInfo;
        if (service != null) {
            TextToSpeech.EngineInfo engine = new TextToSpeech.EngineInfo();
            engine.name = service.packageName;
            CharSequence label = service.loadLabel(pm);
            engine.label = TextUtils.isEmpty(label) ? engine.name : label.toString();
            engine.icon = service.getIconResource();
            engine.priority = resolve.priority;
            engine.system = this.isSystemEngine(service);
            return engine;
        }
        return null;
    }

    public Locale getLocalePrefForEngine(String engineName) {
        return this.getLocalePrefForEngine(engineName, Settings.Secure.getString(this.mContext.getContentResolver(), "tts_default_locale"));
    }

    public Locale getLocalePrefForEngine(String engineName, String prefValue) {
        String localeString = TtsEngines.parseEnginePrefFromList(prefValue, engineName);
        if (TextUtils.isEmpty(localeString)) {
            return Locale.getDefault();
        }
        Locale result = this.parseLocaleString(localeString);
        if (result == null) {
            Log.w(TAG, "Failed to parse locale " + localeString + ", returning en_US instead");
            result = Locale.US;
        }
        return result;
    }

    public boolean isLocaleSetToDefaultForEngine(String engineName) {
        return TextUtils.isEmpty(TtsEngines.parseEnginePrefFromList(Settings.Secure.getString(this.mContext.getContentResolver(), "tts_default_locale"), engineName));
    }

    public Locale parseLocaleString(String localeString) {
        String normalizedCountry;
        String normalizedLanguage;
        String language = "";
        String country = "";
        String variant = "";
        if (!TextUtils.isEmpty(localeString)) {
            String[] split = localeString.split("[-_]");
            language = split[0].toLowerCase();
            if (split.length == 0) {
                Log.w(TAG, "Failed to convert " + localeString + " to a valid Locale object. Only separators");
                return null;
            }
            if (split.length > 3) {
                Log.w(TAG, "Failed to convert " + localeString + " to a valid Locale object. Too many separators");
                return null;
            }
            if (split.length >= 2) {
                country = split[1].toUpperCase();
            }
            if (split.length >= 3) {
                variant = split[2];
            }
        }
        if ((normalizedLanguage = sNormalizeLanguage.get(language)) != null) {
            language = normalizedLanguage;
        }
        if ((normalizedCountry = sNormalizeCountry.get(country)) != null) {
            country = normalizedCountry;
        }
        Locale result = new Locale(language, country, variant);
        try {
            result.getISO3Language();
            result.getISO3Country();
            return result;
        }
        catch (MissingResourceException e) {
            Log.w(TAG, "Failed to convert " + localeString + " to a valid Locale object.");
            return null;
        }
    }

    public static Locale normalizeTTSLocale(Locale ttsLocale) {
        String normalizedCountry;
        String country;
        String normalizedLanguage;
        String language = ttsLocale.getLanguage();
        if (!TextUtils.isEmpty(language) && (normalizedLanguage = sNormalizeLanguage.get(language)) != null) {
            language = normalizedLanguage;
        }
        if (!TextUtils.isEmpty(country = ttsLocale.getCountry()) && (normalizedCountry = sNormalizeCountry.get(country)) != null) {
            country = normalizedCountry;
        }
        return new Locale(language, country, ttsLocale.getVariant());
    }

    public static String[] toOldLocaleStringFormat(Locale locale) {
        String[] ret = new String[]{"", "", ""};
        try {
            ret[0] = locale.getISO3Language();
            ret[1] = locale.getISO3Country();
            ret[2] = locale.getVariant();
            return ret;
        }
        catch (MissingResourceException e) {
            return new String[]{"eng", "USA", ""};
        }
    }

    private static String parseEnginePrefFromList(String prefValue, String engineName) {
        String[] prefValues;
        if (TextUtils.isEmpty(prefValue)) {
            return null;
        }
        for (String value : prefValues = prefValue.split(",")) {
            int delimiter = value.indexOf(58);
            if (delimiter <= 0 || !engineName.equals(value.substring(0, delimiter))) continue;
            return value.substring(delimiter + 1);
        }
        return null;
    }

    public synchronized void updateLocalePrefForEngine(String engineName, Locale newLocale) {
        String prefList = Settings.Secure.getString(this.mContext.getContentResolver(), "tts_default_locale");
        String newPrefList = this.updateValueInCommaSeparatedList(prefList, engineName, newLocale != null ? newLocale.toString() : "");
        Settings.Secure.putString(this.mContext.getContentResolver(), "tts_default_locale", newPrefList.toString());
    }

    private String updateValueInCommaSeparatedList(String list, String key, String newValue) {
        StringBuilder newPrefList = new StringBuilder();
        if (TextUtils.isEmpty(list)) {
            newPrefList.append(key).append(':').append(newValue);
        } else {
            String[] prefValues = list.split(",");
            boolean first = true;
            boolean found = false;
            for (String value : prefValues) {
                int delimiter = value.indexOf(58);
                if (delimiter <= 0) continue;
                if (key.equals(value.substring(0, delimiter))) {
                    if (first) {
                        first = false;
                    } else {
                        newPrefList.append(',');
                    }
                    found = true;
                    newPrefList.append(key).append(':').append(newValue);
                    continue;
                }
                if (first) {
                    first = false;
                } else {
                    newPrefList.append(',');
                }
                newPrefList.append(value);
            }
            if (!found) {
                newPrefList.append(',');
                newPrefList.append(key).append(':').append(newValue);
            }
        }
        return newPrefList.toString();
    }

    static {
        HashMap<String, String> normalizeLanguage = new HashMap<String, String>();
        for (String language : Locale.getISOLanguages()) {
            try {
                normalizeLanguage.put(new Locale(language).getISO3Language(), language);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        sNormalizeLanguage = Collections.unmodifiableMap(normalizeLanguage);
        HashMap<String, String> normalizeCountry = new HashMap<String, String>();
        for (String country : Locale.getISOCountries()) {
            try {
                normalizeCountry.put(new Locale("", country).getISO3Country(), country);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        sNormalizeCountry = Collections.unmodifiableMap(normalizeCountry);
    }

    private static class EngineInfoComparator
    implements Comparator<TextToSpeech.EngineInfo> {
        static EngineInfoComparator INSTANCE = new EngineInfoComparator();

        private EngineInfoComparator() {
        }

        @Override
        public int compare(TextToSpeech.EngineInfo lhs, TextToSpeech.EngineInfo rhs) {
            if (lhs.system && !rhs.system) {
                return -1;
            }
            if (rhs.system && !lhs.system) {
                return 1;
            }
            return rhs.priority - lhs.priority;
        }
    }
}

