/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.telecom.CallAudioState;
import java.util.Locale;

@Deprecated
@SystemApi
public class AudioState
implements Parcelable {
    public static final int ROUTE_EARPIECE = 1;
    public static final int ROUTE_BLUETOOTH = 2;
    public static final int ROUTE_WIRED_HEADSET = 4;
    public static final int ROUTE_SPEAKER = 8;
    public static final int ROUTE_WIRED_OR_EARPIECE = 5;
    private static final int ROUTE_ALL = 15;
    private final boolean isMuted;
    private final int route;
    private final int supportedRouteMask;
    public static final Parcelable.Creator<AudioState> CREATOR = new Parcelable.Creator<AudioState>(){

        @Override
        public AudioState createFromParcel(Parcel source) {
            boolean isMuted = source.readByte() != 0;
            int route = source.readInt();
            int supportedRouteMask = source.readInt();
            return new AudioState(isMuted, route, supportedRouteMask);
        }

        public AudioState[] newArray(int size) {
            return new AudioState[size];
        }
    };

    public AudioState(boolean muted, int route, int supportedRouteMask) {
        this.isMuted = muted;
        this.route = route;
        this.supportedRouteMask = supportedRouteMask;
    }

    public AudioState(AudioState state) {
        this.isMuted = state.isMuted();
        this.route = state.getRoute();
        this.supportedRouteMask = state.getSupportedRouteMask();
    }

    public AudioState(CallAudioState state) {
        this.isMuted = state.isMuted();
        this.route = state.getRoute();
        this.supportedRouteMask = state.getSupportedRouteMask();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioState)) {
            return false;
        }
        AudioState state = (AudioState)obj;
        return this.isMuted() == state.isMuted() && this.getRoute() == state.getRoute() && this.getSupportedRouteMask() == state.getSupportedRouteMask();
    }

    public String toString() {
        return String.format(Locale.US, "[AudioState isMuted: %b, route: %s, supportedRouteMask: %s]", this.isMuted, AudioState.audioRouteToString(this.route), AudioState.audioRouteToString(this.supportedRouteMask));
    }

    public static String audioRouteToString(int route) {
        if (route == 0 || (route & 0xFFFFFFF0) != 0) {
            return "UNKNOWN";
        }
        StringBuffer buffer = new StringBuffer();
        if ((route & 1) == 1) {
            AudioState.listAppend(buffer, "EARPIECE");
        }
        if ((route & 2) == 2) {
            AudioState.listAppend(buffer, "BLUETOOTH");
        }
        if ((route & 4) == 4) {
            AudioState.listAppend(buffer, "WIRED_HEADSET");
        }
        if ((route & 8) == 8) {
            AudioState.listAppend(buffer, "SPEAKER");
        }
        return buffer.toString();
    }

    private static void listAppend(StringBuffer buffer, String str) {
        if (buffer.length() > 0) {
            buffer.append(", ");
        }
        buffer.append(str);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel destination, int flags) {
        destination.writeByte((byte)(this.isMuted ? 1 : 0));
        destination.writeInt(this.route);
        destination.writeInt(this.supportedRouteMask);
    }

    public boolean isMuted() {
        return this.isMuted;
    }

    public int getRoute() {
        return this.route;
    }

    public int getSupportedRouteMask() {
        return this.supportedRouteMask;
    }
}

