/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.annotation.SystemApi;
import android.app.Service;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.telecom.AudioState;
import android.telecom.Call;
import android.telecom.CallAudioState;
import android.telecom.InCallAdapter;
import android.telecom.ParcelableCall;
import android.telecom.Phone;
import android.telecom.VideoProfile;
import android.view.Surface;
import com.android.internal.os.SomeArgs;
import com.android.internal.telecom.IInCallAdapter;
import com.android.internal.telecom.IInCallService;
import java.util.Collections;
import java.util.List;

public abstract class InCallService
extends Service {
    public static final String SERVICE_INTERFACE = "android.telecom.InCallService";
    private static final int MSG_SET_IN_CALL_ADAPTER = 1;
    private static final int MSG_ADD_CALL = 2;
    private static final int MSG_UPDATE_CALL = 3;
    private static final int MSG_SET_POST_DIAL_WAIT = 4;
    private static final int MSG_ON_CALL_AUDIO_STATE_CHANGED = 5;
    private static final int MSG_BRING_TO_FOREGROUND = 6;
    private static final int MSG_ON_CAN_ADD_CALL_CHANGED = 7;
    private static final int MSG_SILENCE_RINGER = 8;
    private static final int MSG_ON_CONNECTION_EVENT = 9;
    private static final int MSG_ON_RTT_UPGRADE_REQUEST = 10;
    private static final int MSG_ON_RTT_INITIATION_FAILURE = 11;
    private static final int MSG_ON_HANDOVER_FAILED = 12;
    private static final int MSG_ON_HANDOVER_COMPLETE = 13;
    private final Handler mHandler = new Handler(Looper.getMainLooper()){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            if (InCallService.this.mPhone == null && msg.what != 1) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    String callingPackage = InCallService.this.getApplicationContext().getOpPackageName();
                    InCallService.this.mPhone = new Phone(new InCallAdapter((IInCallAdapter)msg.obj), callingPackage, InCallService.this.getApplicationContext().getApplicationInfo().targetSdkVersion);
                    InCallService.this.mPhone.addListener(InCallService.this.mPhoneListener);
                    InCallService.this.onPhoneCreated(InCallService.this.mPhone);
                    break;
                }
                case 2: {
                    InCallService.this.mPhone.internalAddCall((ParcelableCall)msg.obj);
                    break;
                }
                case 3: {
                    InCallService.this.mPhone.internalUpdateCall((ParcelableCall)msg.obj);
                    break;
                }
                case 4: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        String callId = (String)args.arg1;
                        String remaining = (String)args.arg2;
                        InCallService.this.mPhone.internalSetPostDialWait(callId, remaining);
                        break;
                    }
                    finally {
                        args.recycle();
                    }
                }
                case 5: {
                    InCallService.this.mPhone.internalCallAudioStateChanged((CallAudioState)msg.obj);
                    break;
                }
                case 6: {
                    InCallService.this.mPhone.internalBringToForeground(msg.arg1 == 1);
                    break;
                }
                case 7: {
                    InCallService.this.mPhone.internalSetCanAddCall(msg.arg1 == 1);
                    break;
                }
                case 8: {
                    InCallService.this.mPhone.internalSilenceRinger();
                    break;
                }
                case 9: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        String callId = (String)args.arg1;
                        String event = (String)args.arg2;
                        Bundle extras = (Bundle)args.arg3;
                        InCallService.this.mPhone.internalOnConnectionEvent(callId, event, extras);
                        break;
                    }
                    finally {
                        args.recycle();
                    }
                }
                case 10: {
                    String callId = (String)msg.obj;
                    int requestId = msg.arg1;
                    InCallService.this.mPhone.internalOnRttUpgradeRequest(callId, requestId);
                    break;
                }
                case 11: {
                    String callId = (String)msg.obj;
                    int reason = msg.arg1;
                    InCallService.this.mPhone.internalOnRttInitiationFailure(callId, reason);
                    break;
                }
                case 12: {
                    String callId = (String)msg.obj;
                    int error = msg.arg1;
                    InCallService.this.mPhone.internalOnHandoverFailed(callId, error);
                    break;
                }
                case 13: {
                    String callId = (String)msg.obj;
                    InCallService.this.mPhone.internalOnHandoverComplete(callId);
                    break;
                }
            }
        }
    };
    private Phone.Listener mPhoneListener = new Phone.Listener(){

        @Override
        public void onAudioStateChanged(Phone phone, AudioState audioState) {
            InCallService.this.onAudioStateChanged(audioState);
        }

        @Override
        public void onCallAudioStateChanged(Phone phone, CallAudioState callAudioState) {
            InCallService.this.onCallAudioStateChanged(callAudioState);
        }

        @Override
        public void onBringToForeground(Phone phone, boolean showDialpad) {
            InCallService.this.onBringToForeground(showDialpad);
        }

        @Override
        public void onCallAdded(Phone phone, Call call) {
            InCallService.this.onCallAdded(call);
        }

        @Override
        public void onCallRemoved(Phone phone, Call call) {
            InCallService.this.onCallRemoved(call);
        }

        @Override
        public void onCanAddCallChanged(Phone phone, boolean canAddCall) {
            InCallService.this.onCanAddCallChanged(canAddCall);
        }

        @Override
        public void onSilenceRinger(Phone phone) {
            InCallService.this.onSilenceRinger();
        }
    };
    private Phone mPhone;

    @Override
    public IBinder onBind(Intent intent) {
        return new InCallServiceBinder();
    }

    @Override
    public boolean onUnbind(Intent intent) {
        if (this.mPhone != null) {
            Phone oldPhone = this.mPhone;
            this.mPhone = null;
            oldPhone.destroy();
            oldPhone.removeListener(this.mPhoneListener);
            this.onPhoneDestroyed(oldPhone);
        }
        return false;
    }

    @SystemApi
    @Deprecated
    public Phone getPhone() {
        return this.mPhone;
    }

    public final List<Call> getCalls() {
        return this.mPhone == null ? Collections.emptyList() : this.mPhone.getCalls();
    }

    public final boolean canAddCall() {
        return this.mPhone == null ? false : this.mPhone.canAddCall();
    }

    @Deprecated
    public final AudioState getAudioState() {
        return this.mPhone == null ? null : this.mPhone.getAudioState();
    }

    public final CallAudioState getCallAudioState() {
        return this.mPhone == null ? null : this.mPhone.getCallAudioState();
    }

    public final void setMuted(boolean state) {
        if (this.mPhone != null) {
            this.mPhone.setMuted(state);
        }
    }

    public final void setAudioRoute(int route) {
        if (this.mPhone != null) {
            this.mPhone.setAudioRoute(route);
        }
    }

    public final void requestBluetoothAudio(String bluetoothAddress) {
        if (this.mPhone != null) {
            this.mPhone.requestBluetoothAudio(bluetoothAddress);
        }
    }

    @SystemApi
    @Deprecated
    public void onPhoneCreated(Phone phone) {
    }

    @SystemApi
    @Deprecated
    public void onPhoneDestroyed(Phone phone) {
    }

    @Deprecated
    public void onAudioStateChanged(AudioState audioState) {
    }

    public void onCallAudioStateChanged(CallAudioState audioState) {
    }

    public void onBringToForeground(boolean showDialpad) {
    }

    public void onCallAdded(Call call) {
    }

    public void onCallRemoved(Call call) {
    }

    public void onCanAddCallChanged(boolean canAddCall) {
    }

    public void onSilenceRinger() {
    }

    public void onConnectionEvent(Call call, String event, Bundle extras) {
    }

    public static abstract class VideoCall {
        public abstract void destroy();

        public abstract void registerCallback(Callback var1);

        public abstract void registerCallback(Callback var1, Handler var2);

        public abstract void unregisterCallback(Callback var1);

        public abstract void setCamera(String var1);

        public abstract void setPreviewSurface(Surface var1);

        public abstract void setDisplaySurface(Surface var1);

        public abstract void setDeviceOrientation(int var1);

        public abstract void setZoom(float var1);

        public abstract void sendSessionModifyRequest(VideoProfile var1);

        public abstract void sendSessionModifyResponse(VideoProfile var1);

        public abstract void requestCameraCapabilities();

        public abstract void requestCallDataUsage();

        public abstract void setPauseImage(Uri var1);

        public static abstract class Callback {
            public abstract void onSessionModifyRequestReceived(VideoProfile var1);

            public abstract void onSessionModifyResponseReceived(int var1, VideoProfile var2, VideoProfile var3);

            public abstract void onCallSessionEvent(int var1);

            public abstract void onPeerDimensionsChanged(int var1, int var2);

            public abstract void onVideoQualityChanged(int var1);

            public abstract void onCallDataUsageChanged(long var1);

            public abstract void onCameraCapabilitiesChanged(VideoProfile.CameraCapabilities var1);
        }
    }

    private final class InCallServiceBinder
    extends IInCallService.Stub {
        private InCallServiceBinder() {
        }

        @Override
        public void setInCallAdapter(IInCallAdapter inCallAdapter) {
            InCallService.this.mHandler.obtainMessage(1, inCallAdapter).sendToTarget();
        }

        @Override
        public void addCall(ParcelableCall call) {
            InCallService.this.mHandler.obtainMessage(2, call).sendToTarget();
        }

        @Override
        public void updateCall(ParcelableCall call) {
            InCallService.this.mHandler.obtainMessage(3, call).sendToTarget();
        }

        @Override
        public void setPostDial(String callId, String remaining) {
        }

        @Override
        public void setPostDialWait(String callId, String remaining) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = callId;
            args.arg2 = remaining;
            InCallService.this.mHandler.obtainMessage(4, args).sendToTarget();
        }

        @Override
        public void onCallAudioStateChanged(CallAudioState callAudioState) {
            InCallService.this.mHandler.obtainMessage(5, callAudioState).sendToTarget();
        }

        @Override
        public void bringToForeground(boolean showDialpad) {
            InCallService.this.mHandler.obtainMessage(6, showDialpad ? 1 : 0, 0).sendToTarget();
        }

        @Override
        public void onCanAddCallChanged(boolean canAddCall) {
            InCallService.this.mHandler.obtainMessage(7, canAddCall ? 1 : 0, 0).sendToTarget();
        }

        @Override
        public void silenceRinger() {
            InCallService.this.mHandler.obtainMessage(8).sendToTarget();
        }

        @Override
        public void onConnectionEvent(String callId, String event, Bundle extras) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = callId;
            args.arg2 = event;
            args.arg3 = extras;
            InCallService.this.mHandler.obtainMessage(9, args).sendToTarget();
        }

        @Override
        public void onRttUpgradeRequest(String callId, int id2) {
            InCallService.this.mHandler.obtainMessage(10, id2, 0, callId).sendToTarget();
        }

        @Override
        public void onRttInitiationFailure(String callId, int reason) {
            InCallService.this.mHandler.obtainMessage(11, reason, 0, callId).sendToTarget();
        }

        @Override
        public void onHandoverFailed(String callId, int error) {
            InCallService.this.mHandler.obtainMessage(12, error, 0, callId).sendToTarget();
        }

        @Override
        public void onHandoverComplete(String callId) {
            InCallService.this.mHandler.obtainMessage(13, callId).sendToTarget();
        }
    }
}

