/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.CellSignalStrength;
import android.telephony.Rlog;
import java.util.Objects;

public final class CellSignalStrengthLte
extends CellSignalStrength
implements Parcelable {
    private static final String LOG_TAG = "CellSignalStrengthLte";
    private static final boolean DBG = false;
    private int mSignalStrength;
    private int mRsrp;
    private int mRsrq;
    private int mRssnr;
    private int mCqi;
    private int mTimingAdvance;
    public static final Parcelable.Creator<CellSignalStrengthLte> CREATOR = new Parcelable.Creator<CellSignalStrengthLte>(){

        @Override
        public CellSignalStrengthLte createFromParcel(Parcel in) {
            return new CellSignalStrengthLte(in);
        }

        public CellSignalStrengthLte[] newArray(int size) {
            return new CellSignalStrengthLte[size];
        }
    };

    public CellSignalStrengthLte() {
        this.setDefaultValues();
    }

    public CellSignalStrengthLte(int signalStrength, int rsrp, int rsrq, int rssnr, int cqi, int timingAdvance) {
        this.mSignalStrength = signalStrength;
        this.mRsrp = rsrp;
        this.mRsrq = rsrq;
        this.mRssnr = rssnr;
        this.mCqi = cqi;
        this.mTimingAdvance = timingAdvance;
    }

    public CellSignalStrengthLte(CellSignalStrengthLte s) {
        this.copyFrom(s);
    }

    protected void copyFrom(CellSignalStrengthLte s) {
        this.mSignalStrength = s.mSignalStrength;
        this.mRsrp = s.mRsrp;
        this.mRsrq = s.mRsrq;
        this.mRssnr = s.mRssnr;
        this.mCqi = s.mCqi;
        this.mTimingAdvance = s.mTimingAdvance;
    }

    @Override
    public CellSignalStrengthLte copy() {
        return new CellSignalStrengthLte(this);
    }

    @Override
    public void setDefaultValues() {
        this.mSignalStrength = Integer.MAX_VALUE;
        this.mRsrp = Integer.MAX_VALUE;
        this.mRsrq = Integer.MAX_VALUE;
        this.mRssnr = Integer.MAX_VALUE;
        this.mCqi = Integer.MAX_VALUE;
        this.mTimingAdvance = Integer.MAX_VALUE;
    }

    @Override
    public int getLevel() {
        int levelRsrp = 0;
        int levelRssnr = 0;
        levelRsrp = this.mRsrp == Integer.MAX_VALUE ? 0 : (this.mRsrp >= -95 ? 4 : (this.mRsrp >= -105 ? 3 : (this.mRsrp >= -115 ? 2 : 1)));
        levelRssnr = this.mRssnr == Integer.MAX_VALUE ? 0 : (this.mRssnr >= 45 ? 4 : (this.mRssnr >= 10 ? 3 : (this.mRssnr >= -30 ? 2 : 1)));
        int level = this.mRsrp == Integer.MAX_VALUE ? levelRssnr : (this.mRssnr == Integer.MAX_VALUE ? levelRsrp : (levelRssnr < levelRsrp ? levelRssnr : levelRsrp));
        return level;
    }

    public int getRsrq() {
        return this.mRsrq;
    }

    public int getRssnr() {
        return this.mRssnr;
    }

    public int getRsrp() {
        return this.mRsrp;
    }

    public int getCqi() {
        return this.mCqi;
    }

    @Override
    public int getDbm() {
        return this.mRsrp;
    }

    @Override
    public int getAsuLevel() {
        int lteAsuLevel = 99;
        int lteDbm = this.getDbm();
        lteAsuLevel = lteDbm == Integer.MAX_VALUE ? 99 : (lteDbm <= -140 ? 0 : (lteDbm >= -43 ? 97 : lteDbm + 140));
        return lteAsuLevel;
    }

    public int getTimingAdvance() {
        return this.mTimingAdvance;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mSignalStrength, this.mRsrp, this.mRsrq, this.mRssnr, this.mCqi, this.mTimingAdvance);
    }

    @Override
    public boolean equals(Object o) {
        CellSignalStrengthLte s;
        try {
            s = (CellSignalStrengthLte)o;
        }
        catch (ClassCastException ex) {
            return false;
        }
        if (o == null) {
            return false;
        }
        return this.mSignalStrength == s.mSignalStrength && this.mRsrp == s.mRsrp && this.mRsrq == s.mRsrq && this.mRssnr == s.mRssnr && this.mCqi == s.mCqi && this.mTimingAdvance == s.mTimingAdvance;
    }

    public String toString() {
        return "CellSignalStrengthLte: ss=" + this.mSignalStrength + " rsrp=" + this.mRsrp + " rsrq=" + this.mRsrq + " rssnr=" + this.mRssnr + " cqi=" + this.mCqi + " ta=" + this.mTimingAdvance;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mSignalStrength);
        dest.writeInt(this.mRsrp * (this.mRsrp != Integer.MAX_VALUE ? -1 : 1));
        dest.writeInt(this.mRsrq * (this.mRsrq != Integer.MAX_VALUE ? -1 : 1));
        dest.writeInt(this.mRssnr);
        dest.writeInt(this.mCqi);
        dest.writeInt(this.mTimingAdvance);
    }

    private CellSignalStrengthLte(Parcel in) {
        this.mSignalStrength = in.readInt();
        this.mRsrp = in.readInt();
        if (this.mRsrp != Integer.MAX_VALUE) {
            this.mRsrp *= -1;
        }
        this.mRsrq = in.readInt();
        if (this.mRsrq != Integer.MAX_VALUE) {
            this.mRsrq *= -1;
        }
        this.mRssnr = in.readInt();
        this.mCqi = in.readInt();
        this.mTimingAdvance = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private static void log(String s) {
        Rlog.w(LOG_TAG, s);
    }
}

