/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.CellSignalStrength;
import android.telephony.Rlog;
import java.util.Objects;

public final class CellSignalStrengthWcdma
extends CellSignalStrength
implements Parcelable {
    private static final String LOG_TAG = "CellSignalStrengthWcdma";
    private static final boolean DBG = false;
    private static final int WCDMA_SIGNAL_STRENGTH_GREAT = 12;
    private static final int WCDMA_SIGNAL_STRENGTH_GOOD = 8;
    private static final int WCDMA_SIGNAL_STRENGTH_MODERATE = 5;
    private int mSignalStrength;
    private int mBitErrorRate;
    public static final Parcelable.Creator<CellSignalStrengthWcdma> CREATOR = new Parcelable.Creator<CellSignalStrengthWcdma>(){

        @Override
        public CellSignalStrengthWcdma createFromParcel(Parcel in) {
            return new CellSignalStrengthWcdma(in);
        }

        public CellSignalStrengthWcdma[] newArray(int size) {
            return new CellSignalStrengthWcdma[size];
        }
    };

    public CellSignalStrengthWcdma() {
        this.setDefaultValues();
    }

    public CellSignalStrengthWcdma(int ss, int ber) {
        this.mSignalStrength = ss;
        this.mBitErrorRate = ber;
    }

    public CellSignalStrengthWcdma(CellSignalStrengthWcdma s) {
        this.copyFrom(s);
    }

    protected void copyFrom(CellSignalStrengthWcdma s) {
        this.mSignalStrength = s.mSignalStrength;
        this.mBitErrorRate = s.mBitErrorRate;
    }

    @Override
    public CellSignalStrengthWcdma copy() {
        return new CellSignalStrengthWcdma(this);
    }

    @Override
    public void setDefaultValues() {
        this.mSignalStrength = Integer.MAX_VALUE;
        this.mBitErrorRate = Integer.MAX_VALUE;
    }

    @Override
    public int getLevel() {
        int asu = this.mSignalStrength;
        int level = asu <= 2 || asu == 99 ? 0 : (asu >= 12 ? 4 : (asu >= 8 ? 3 : (asu >= 5 ? 2 : 1)));
        return level;
    }

    @Override
    public int getDbm() {
        int level = this.mSignalStrength;
        int asu = level == 99 ? Integer.MAX_VALUE : level;
        int dBm = asu != Integer.MAX_VALUE ? -113 + 2 * asu : Integer.MAX_VALUE;
        return dBm;
    }

    @Override
    public int getAsuLevel() {
        int level = this.mSignalStrength;
        return level;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mSignalStrength, this.mBitErrorRate);
    }

    @Override
    public boolean equals(Object o) {
        CellSignalStrengthWcdma s;
        try {
            s = (CellSignalStrengthWcdma)o;
        }
        catch (ClassCastException ex) {
            return false;
        }
        if (o == null) {
            return false;
        }
        return this.mSignalStrength == s.mSignalStrength && this.mBitErrorRate == s.mBitErrorRate;
    }

    public String toString() {
        return "CellSignalStrengthWcdma: ss=" + this.mSignalStrength + " ber=" + this.mBitErrorRate;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mSignalStrength);
        dest.writeInt(this.mBitErrorRate);
    }

    private CellSignalStrengthWcdma(Parcel in) {
        this.mSignalStrength = in.readInt();
        this.mBitErrorRate = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private static void log(String s) {
        Rlog.w(LOG_TAG, s);
    }
}

