/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.app.Service;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.telephony.INetworkService;
import android.telephony.INetworkServiceCallback;
import android.telephony.NetworkServiceCallback;
import android.telephony.Rlog;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;

@SystemApi
public abstract class NetworkService
extends Service {
    private final String TAG = NetworkService.class.getSimpleName();
    public static final String NETWORK_SERVICE_INTERFACE = "android.telephony.NetworkService";
    public static final String NETWORK_SERVICE_EXTRA_SLOT_ID = "android.telephony.extra.SLOT_ID";
    private static final int NETWORK_SERVICE_CREATE_NETWORK_SERVICE_PROVIDER = 1;
    private static final int NETWORK_SERVICE_REMOVE_NETWORK_SERVICE_PROVIDER = 2;
    private static final int NETWORK_SERVICE_REMOVE_ALL_NETWORK_SERVICE_PROVIDERS = 3;
    private static final int NETWORK_SERVICE_GET_REGISTRATION_STATE = 4;
    private static final int NETWORK_SERVICE_REGISTER_FOR_STATE_CHANGE = 5;
    private static final int NETWORK_SERVICE_UNREGISTER_FOR_STATE_CHANGE = 6;
    private static final int NETWORK_SERVICE_INDICATION_NETWORK_STATE_CHANGED = 7;
    private final HandlerThread mHandlerThread;
    private final NetworkServiceHandler mHandler;
    private final SparseArray<NetworkServiceProvider> mServiceMap = new SparseArray();
    @VisibleForTesting
    public final INetworkServiceWrapper mBinder = new INetworkServiceWrapper();

    protected NetworkService() {
        this.mHandlerThread = new HandlerThread(this.TAG);
        this.mHandlerThread.start();
        this.mHandler = new NetworkServiceHandler(this.mHandlerThread.getLooper());
        this.log("network service created");
    }

    protected abstract NetworkServiceProvider createNetworkServiceProvider(int var1);

    @Override
    public IBinder onBind(Intent intent) {
        if (intent == null || !NETWORK_SERVICE_INTERFACE.equals(intent.getAction())) {
            this.loge("Unexpected intent " + intent);
            return null;
        }
        return this.mBinder;
    }

    @Override
    public boolean onUnbind(Intent intent) {
        this.mHandler.obtainMessage(3, 0, 0, null).sendToTarget();
        return false;
    }

    @Override
    public void onDestroy() {
        this.mHandlerThread.quit();
    }

    private final void log(String s) {
        Rlog.d(this.TAG, s);
    }

    private final void loge(String s) {
        Rlog.e(this.TAG, s);
    }

    private class INetworkServiceWrapper
    extends INetworkService.Stub {
        private INetworkServiceWrapper() {
        }

        @Override
        public void createNetworkServiceProvider(int slotId) {
            NetworkService.this.mHandler.obtainMessage(1, slotId, 0, null).sendToTarget();
        }

        @Override
        public void removeNetworkServiceProvider(int slotId) {
            NetworkService.this.mHandler.obtainMessage(2, slotId, 0, null).sendToTarget();
        }

        @Override
        public void getNetworkRegistrationState(int slotId, int domain, INetworkServiceCallback callback) {
            NetworkService.this.mHandler.obtainMessage(4, slotId, domain, callback).sendToTarget();
        }

        @Override
        public void registerForNetworkRegistrationStateChanged(int slotId, INetworkServiceCallback callback) {
            NetworkService.this.mHandler.obtainMessage(5, slotId, 0, callback).sendToTarget();
        }

        @Override
        public void unregisterForNetworkRegistrationStateChanged(int slotId, INetworkServiceCallback callback) {
            NetworkService.this.mHandler.obtainMessage(6, slotId, 0, callback).sendToTarget();
        }
    }

    private class NetworkServiceHandler
    extends Handler {
        NetworkServiceHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message message) {
            int slotId = message.arg1;
            INetworkServiceCallback callback = (INetworkServiceCallback)message.obj;
            NetworkServiceProvider serviceProvider = (NetworkServiceProvider)NetworkService.this.mServiceMap.get(slotId);
            switch (message.what) {
                case 1: {
                    if (serviceProvider != null) break;
                    NetworkService.this.mServiceMap.put(slotId, NetworkService.this.createNetworkServiceProvider(slotId));
                    break;
                }
                case 2: {
                    if (serviceProvider == null) break;
                    serviceProvider.onDestroy();
                    NetworkService.this.mServiceMap.remove(slotId);
                    break;
                }
                case 3: {
                    for (int i = 0; i < NetworkService.this.mServiceMap.size(); ++i) {
                        serviceProvider = (NetworkServiceProvider)NetworkService.this.mServiceMap.get(i);
                        if (serviceProvider == null) continue;
                        serviceProvider.onDestroy();
                    }
                    NetworkService.this.mServiceMap.clear();
                    break;
                }
                case 4: {
                    if (serviceProvider == null) break;
                    int domainId = message.arg2;
                    serviceProvider.getNetworkRegistrationState(domainId, new NetworkServiceCallback(callback));
                    break;
                }
                case 5: {
                    if (serviceProvider == null) break;
                    serviceProvider.registerForStateChanged(callback);
                    break;
                }
                case 6: {
                    if (serviceProvider == null) break;
                    serviceProvider.unregisterForStateChanged(callback);
                    break;
                }
                case 7: {
                    if (serviceProvider == null) break;
                    serviceProvider.notifyStateChangedToCallbacks();
                    break;
                }
            }
        }
    }

    public class NetworkServiceProvider {
        private final int mSlotId;
        private final List<INetworkServiceCallback> mNetworkRegistrationStateChangedCallbacks = new ArrayList<INetworkServiceCallback>();

        public NetworkServiceProvider(int slotId) {
            this.mSlotId = slotId;
        }

        public final int getSlotId() {
            return this.mSlotId;
        }

        public void getNetworkRegistrationState(int domain, NetworkServiceCallback callback) {
            callback.onGetNetworkRegistrationStateComplete(1, null);
        }

        public final void notifyNetworkRegistrationStateChanged() {
            NetworkService.this.mHandler.obtainMessage(7, this.mSlotId, 0, null).sendToTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerForStateChanged(INetworkServiceCallback callback) {
            List<INetworkServiceCallback> list = this.mNetworkRegistrationStateChangedCallbacks;
            synchronized (list) {
                this.mNetworkRegistrationStateChangedCallbacks.add(callback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unregisterForStateChanged(INetworkServiceCallback callback) {
            List<INetworkServiceCallback> list = this.mNetworkRegistrationStateChangedCallbacks;
            synchronized (list) {
                this.mNetworkRegistrationStateChangedCallbacks.remove(callback);
            }
        }

        private void notifyStateChangedToCallbacks() {
            for (INetworkServiceCallback callback : this.mNetworkRegistrationStateChangedCallbacks) {
                try {
                    callback.onNetworkStateChanged();
                }
                catch (RemoteException remoteException) {}
            }
        }

        protected void onDestroy() {
            this.mNetworkRegistrationStateChangedCallbacks.clear();
        }
    }
}

