/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;

@SystemApi
public final class TelephonyHistogram
implements Parcelable {
    private final int mCategory;
    private final int mId;
    private int mMinTimeMs;
    private int mMaxTimeMs;
    private int mAverageTimeMs;
    private int mSampleCount;
    private int[] mInitialTimings;
    private final int mBucketCount;
    private final int[] mBucketEndPoints;
    private final int[] mBucketCounters;
    public static final int TELEPHONY_CATEGORY_RIL = 1;
    private static final int RANGE_CALCULATION_COUNT = 10;
    private static final int ABSENT = 0;
    private static final int PRESENT = 1;
    public static final Parcelable.Creator<TelephonyHistogram> CREATOR = new Parcelable.Creator<TelephonyHistogram>(){

        @Override
        public TelephonyHistogram createFromParcel(Parcel in) {
            return new TelephonyHistogram(in);
        }

        public TelephonyHistogram[] newArray(int size) {
            return new TelephonyHistogram[size];
        }
    };

    public TelephonyHistogram(int category, int id2, int bucketCount) {
        if (bucketCount <= 1) {
            throw new IllegalArgumentException("Invalid number of buckets");
        }
        this.mCategory = category;
        this.mId = id2;
        this.mMinTimeMs = Integer.MAX_VALUE;
        this.mMaxTimeMs = 0;
        this.mAverageTimeMs = 0;
        this.mSampleCount = 0;
        this.mInitialTimings = new int[10];
        this.mBucketCount = bucketCount;
        this.mBucketEndPoints = new int[bucketCount - 1];
        this.mBucketCounters = new int[bucketCount];
    }

    public TelephonyHistogram(TelephonyHistogram th) {
        this.mCategory = th.getCategory();
        this.mId = th.getId();
        this.mMinTimeMs = th.getMinTime();
        this.mMaxTimeMs = th.getMaxTime();
        this.mAverageTimeMs = th.getAverageTime();
        this.mSampleCount = th.getSampleCount();
        this.mInitialTimings = th.getInitialTimings();
        this.mBucketCount = th.getBucketCount();
        this.mBucketEndPoints = th.getBucketEndPoints();
        this.mBucketCounters = th.getBucketCounters();
    }

    public int getCategory() {
        return this.mCategory;
    }

    public int getId() {
        return this.mId;
    }

    public int getMinTime() {
        return this.mMinTimeMs;
    }

    public int getMaxTime() {
        return this.mMaxTimeMs;
    }

    public int getAverageTime() {
        return this.mAverageTimeMs;
    }

    public int getSampleCount() {
        return this.mSampleCount;
    }

    private int[] getInitialTimings() {
        return this.mInitialTimings;
    }

    public int getBucketCount() {
        return this.mBucketCount;
    }

    public int[] getBucketEndPoints() {
        if (this.mSampleCount > 1 && this.mSampleCount < 10) {
            int[] tempEndPoints = new int[this.mBucketCount - 1];
            this.calculateBucketEndPoints(tempEndPoints);
            return tempEndPoints;
        }
        return this.getDeepCopyOfArray(this.mBucketEndPoints);
    }

    public int[] getBucketCounters() {
        if (this.mSampleCount > 1 && this.mSampleCount < 10) {
            int[] tempEndPoints = new int[this.mBucketCount - 1];
            int[] tempBucketCounters = new int[this.mBucketCount];
            this.calculateBucketEndPoints(tempEndPoints);
            for (int j = 0; j < this.mSampleCount; ++j) {
                this.addToBucketCounter(tempEndPoints, tempBucketCounters, this.mInitialTimings[j]);
            }
            return tempBucketCounters;
        }
        return this.getDeepCopyOfArray(this.mBucketCounters);
    }

    private int[] getDeepCopyOfArray(int[] array2) {
        int[] clone = new int[array2.length];
        System.arraycopy((int[])array2, (int)0, (int[])clone, (int)0, (int)array2.length);
        return clone;
    }

    private void addToBucketCounter(int[] bucketEndPoints, int[] bucketCounters, int time) {
        int i;
        for (i = 0; i < bucketEndPoints.length; ++i) {
            if (time > bucketEndPoints[i]) continue;
            int n = i;
            bucketCounters[n] = bucketCounters[n] + 1;
            return;
        }
        int n = i;
        bucketCounters[n] = bucketCounters[n] + 1;
    }

    private void calculateBucketEndPoints(int[] bucketEndPoints) {
        for (int i = 1; i < this.mBucketCount; ++i) {
            int endPt;
            bucketEndPoints[i - 1] = endPt = this.mMinTimeMs + i * (this.mMaxTimeMs - this.mMinTimeMs) / this.mBucketCount;
        }
    }

    public void addTimeTaken(int time) {
        if (this.mSampleCount == 0 || this.mSampleCount == Integer.MAX_VALUE) {
            if (this.mSampleCount == 0) {
                this.mMinTimeMs = time;
                this.mMaxTimeMs = time;
                this.mAverageTimeMs = time;
            } else {
                this.mInitialTimings = new int[10];
            }
            this.mSampleCount = 1;
            Arrays.fill(this.mInitialTimings, 0);
            this.mInitialTimings[0] = time;
            Arrays.fill(this.mBucketEndPoints, 0);
            Arrays.fill(this.mBucketCounters, 0);
        } else {
            if (time < this.mMinTimeMs) {
                this.mMinTimeMs = time;
            }
            if (time > this.mMaxTimeMs) {
                this.mMaxTimeMs = time;
            }
            long totalTime = (long)this.mAverageTimeMs * (long)this.mSampleCount + (long)time;
            this.mAverageTimeMs = (int)(totalTime / (long)(++this.mSampleCount));
            if (this.mSampleCount < 10) {
                this.mInitialTimings[this.mSampleCount - 1] = time;
            } else if (this.mSampleCount == 10) {
                this.mInitialTimings[this.mSampleCount - 1] = time;
                this.calculateBucketEndPoints(this.mBucketEndPoints);
                for (int j = 0; j < 10; ++j) {
                    this.addToBucketCounter(this.mBucketEndPoints, this.mBucketCounters, this.mInitialTimings[j]);
                }
                this.mInitialTimings = null;
            } else {
                this.addToBucketCounter(this.mBucketEndPoints, this.mBucketCounters, time);
            }
        }
    }

    public String toString() {
        int i;
        String basic = " Histogram id = " + this.mId + " Time(ms): min = " + this.mMinTimeMs + " max = " + this.mMaxTimeMs + " avg = " + this.mAverageTimeMs + " Count = " + this.mSampleCount;
        if (this.mSampleCount < 10) {
            return basic;
        }
        StringBuffer intervals = new StringBuffer(" Interval Endpoints:");
        for (i = 0; i < this.mBucketEndPoints.length; ++i) {
            intervals.append(" " + this.mBucketEndPoints[i]);
        }
        intervals.append(" Interval counters:");
        for (i = 0; i < this.mBucketCounters.length; ++i) {
            intervals.append(" " + this.mBucketCounters[i]);
        }
        return basic + intervals;
    }

    public TelephonyHistogram(Parcel in) {
        this.mCategory = in.readInt();
        this.mId = in.readInt();
        this.mMinTimeMs = in.readInt();
        this.mMaxTimeMs = in.readInt();
        this.mAverageTimeMs = in.readInt();
        this.mSampleCount = in.readInt();
        if (in.readInt() == 1) {
            this.mInitialTimings = new int[10];
            in.readIntArray(this.mInitialTimings);
        }
        this.mBucketCount = in.readInt();
        this.mBucketEndPoints = new int[this.mBucketCount - 1];
        in.readIntArray(this.mBucketEndPoints);
        this.mBucketCounters = new int[this.mBucketCount];
        in.readIntArray(this.mBucketCounters);
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mCategory);
        out.writeInt(this.mId);
        out.writeInt(this.mMinTimeMs);
        out.writeInt(this.mMaxTimeMs);
        out.writeInt(this.mAverageTimeMs);
        out.writeInt(this.mSampleCount);
        if (this.mInitialTimings == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            out.writeIntArray(this.mInitialTimings);
        }
        out.writeInt(this.mBucketCount);
        out.writeIntArray(this.mBucketEndPoints);
        out.writeIntArray(this.mBucketCounters);
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

