/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.data;

import android.content.ContentValues;
import android.database.Cursor;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.ServiceState;
import android.text.TextUtils;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ApnSetting
implements Parcelable {
    static final String LOG_TAG = "ApnSetting";
    private static final boolean VDBG = false;
    private final String mEntryName;
    private final String mApnName;
    private final InetAddress mProxy;
    private final int mPort;
    private final URL mMmsc;
    private final InetAddress mMmsProxy;
    private final int mMmsPort;
    private final String mUser;
    private final String mPassword;
    private final int mAuthType;
    private final List<String> mTypes;
    private final int mTypesBitmap;
    private final int mId;
    private final String mOperatorNumeric;
    private final String mProtocol;
    private final String mRoamingProtocol;
    private final int mMtu;
    private final boolean mCarrierEnabled;
    private final int mNetworkTypeBitmask;
    private final int mProfileId;
    private final boolean mModemCognitive;
    private final int mMaxConns;
    private final int mWaitTime;
    private final int mMaxConnsTime;
    private final String mMvnoType;
    private final String mMvnoMatchData;
    private boolean mPermanentFailed = false;
    public static final Parcelable.Creator<ApnSetting> CREATOR = new Parcelable.Creator<ApnSetting>(){

        @Override
        public ApnSetting createFromParcel(Parcel in) {
            return ApnSetting.readFromParcel(in);
        }

        public ApnSetting[] newArray(int size) {
            return new ApnSetting[size];
        }
    };
    public static final String TYPE_ALL = "*";
    public static final String TYPE_DEFAULT = "default";
    public static final String TYPE_MMS = "mms";
    public static final String TYPE_SUPL = "supl";
    public static final String TYPE_DUN = "dun";
    public static final String TYPE_HIPRI = "hipri";
    public static final String TYPE_FOTA = "fota";
    public static final String TYPE_IMS = "ims";
    public static final String TYPE_CBS = "cbs";
    public static final String TYPE_IA = "ia";
    public static final String TYPE_EMERGENCY = "emergency";
    public static final String[] ALL_TYPES = new String[]{"default", "mms", "supl", "dun", "hipri", "fota", "ims", "cbs", "ia", "emergency"};
    public static final int AUTH_TYPE_NONE = 0;
    public static final int AUTH_TYPE_PAP = 1;
    public static final int AUTH_TYPE_CHAP = 2;
    public static final int AUTH_TYPE_PAP_OR_CHAP = 3;
    public static final String PROTOCOL_IP = "IP";
    public static final String PROTOCOL_IPV6 = "IPV6";
    public static final String PROTOCOL_IPV4V6 = "IPV4V6";
    public static final String PROTOCOL_PPP = "PPP";
    public static final String MVNO_TYPE_SPN = "spn";
    public static final String MVNO_TYPE_IMSI = "imsi";
    public static final String MVNO_TYPE_GID = "gid";
    public static final String MVNO_TYPE_ICCID = "iccid";

    public int getTypesBitmap() {
        return this.mTypesBitmap;
    }

    public int getMtu() {
        return this.mMtu;
    }

    public int getProfileId() {
        return this.mProfileId;
    }

    public boolean getModemCognitive() {
        return this.mModemCognitive;
    }

    public int getMaxConns() {
        return this.mMaxConns;
    }

    public int getWaitTime() {
        return this.mWaitTime;
    }

    public int getMaxConnsTime() {
        return this.mMaxConnsTime;
    }

    public String getMvnoMatchData() {
        return this.mMvnoMatchData;
    }

    public boolean getPermanentFailed() {
        return this.mPermanentFailed;
    }

    public void setPermanentFailed(boolean permanentFailed) {
        this.mPermanentFailed = permanentFailed;
    }

    public String getEntryName() {
        return this.mEntryName;
    }

    public String getApnName() {
        return this.mApnName;
    }

    public InetAddress getProxy() {
        return this.mProxy;
    }

    public int getPort() {
        return this.mPort;
    }

    public URL getMmsc() {
        return this.mMmsc;
    }

    public InetAddress getMmsProxy() {
        return this.mMmsProxy;
    }

    public int getMmsPort() {
        return this.mMmsPort;
    }

    public String getUser() {
        return this.mUser;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public int getAuthType() {
        return this.mAuthType;
    }

    public List<String> getTypes() {
        return this.mTypes;
    }

    public int getId() {
        return this.mId;
    }

    public String getOperatorNumeric() {
        return this.mOperatorNumeric;
    }

    public String getProtocol() {
        return this.mProtocol;
    }

    public String getRoamingProtocol() {
        return this.mRoamingProtocol;
    }

    public boolean isEnabled() {
        return this.mCarrierEnabled;
    }

    public int getNetworkTypeBitmask() {
        return this.mNetworkTypeBitmask;
    }

    public String getMvnoType() {
        return this.mMvnoType;
    }

    private ApnSetting(Builder builder) {
        this.mEntryName = builder.mEntryName;
        this.mApnName = builder.mApnName;
        this.mProxy = builder.mProxy;
        this.mPort = builder.mPort;
        this.mMmsc = builder.mMmsc;
        this.mMmsProxy = builder.mMmsProxy;
        this.mMmsPort = builder.mMmsPort;
        this.mUser = builder.mUser;
        this.mPassword = builder.mPassword;
        this.mAuthType = builder.mAuthType;
        this.mTypes = builder.mTypes == null ? new ArrayList() : builder.mTypes;
        this.mTypesBitmap = builder.mTypesBitmap;
        this.mId = builder.mId;
        this.mOperatorNumeric = builder.mOperatorNumeric;
        this.mProtocol = builder.mProtocol;
        this.mRoamingProtocol = builder.mRoamingProtocol;
        this.mMtu = builder.mMtu;
        this.mCarrierEnabled = builder.mCarrierEnabled;
        this.mNetworkTypeBitmask = builder.mNetworkTypeBitmask;
        this.mProfileId = builder.mProfileId;
        this.mModemCognitive = builder.mModemCognitive;
        this.mMaxConns = builder.mMaxConns;
        this.mWaitTime = builder.mWaitTime;
        this.mMaxConnsTime = builder.mMaxConnsTime;
        this.mMvnoType = builder.mMvnoType;
        this.mMvnoMatchData = builder.mMvnoMatchData;
    }

    public static ApnSetting makeApnSetting(int id2, String operatorNumeric, String entryName, String apnName, InetAddress proxy, int port, URL mmsc, InetAddress mmsProxy, int mmsPort, String user, String password, int authType, List<String> types, String protocol, String roamingProtocol, boolean carrierEnabled, int networkTypeBitmask, int profileId, boolean modemCognitive, int maxConns, int waitTime, int maxConnsTime, int mtu, String mvnoType, String mvnoMatchData) {
        return new Builder().setId(id2).setOperatorNumeric(operatorNumeric).setEntryName(entryName).setApnName(apnName).setProxy(proxy).setPort(port).setMmsc(mmsc).setMmsProxy(mmsProxy).setMmsPort(mmsPort).setUser(user).setPassword(password).setAuthType(authType).setTypes(types).setProtocol(protocol).setRoamingProtocol(roamingProtocol).setCarrierEnabled(carrierEnabled).setNetworkTypeBitmask(networkTypeBitmask).setProfileId(profileId).setModemCognitive(modemCognitive).setMaxConns(maxConns).setWaitTime(waitTime).setMaxConnsTime(maxConnsTime).setMtu(mtu).setMvnoType(mvnoType).setMvnoMatchData(mvnoMatchData).build();
    }

    public static ApnSetting makeApnSetting(Cursor cursor) {
        String[] types = ApnSetting.parseTypes(cursor.getString(cursor.getColumnIndexOrThrow("type")));
        int networkTypeBitmask = cursor.getInt(cursor.getColumnIndexOrThrow("network_type_bitmask"));
        if (networkTypeBitmask == 0) {
            int bearerBitmask = cursor.getInt(cursor.getColumnIndexOrThrow("bearer_bitmask"));
            networkTypeBitmask = ServiceState.convertBearerBitmaskToNetworkTypeBitmask(bearerBitmask);
        }
        return ApnSetting.makeApnSetting(cursor.getInt(cursor.getColumnIndexOrThrow("_id")), cursor.getString(cursor.getColumnIndexOrThrow("numeric")), cursor.getString(cursor.getColumnIndexOrThrow("name")), cursor.getString(cursor.getColumnIndexOrThrow("apn")), ApnSetting.inetAddressFromString(cursor.getString(cursor.getColumnIndexOrThrow("proxy"))), ApnSetting.portFromString(cursor.getString(cursor.getColumnIndexOrThrow("port"))), ApnSetting.URLFromString(cursor.getString(cursor.getColumnIndexOrThrow("mmsc"))), ApnSetting.inetAddressFromString(cursor.getString(cursor.getColumnIndexOrThrow("mmsproxy"))), ApnSetting.portFromString(cursor.getString(cursor.getColumnIndexOrThrow("mmsport"))), cursor.getString(cursor.getColumnIndexOrThrow("user")), cursor.getString(cursor.getColumnIndexOrThrow("password")), cursor.getInt(cursor.getColumnIndexOrThrow("authtype")), Arrays.asList(types), cursor.getString(cursor.getColumnIndexOrThrow("protocol")), cursor.getString(cursor.getColumnIndexOrThrow("roaming_protocol")), cursor.getInt(cursor.getColumnIndexOrThrow("carrier_enabled")) == 1, networkTypeBitmask, cursor.getInt(cursor.getColumnIndexOrThrow("profile_id")), cursor.getInt(cursor.getColumnIndexOrThrow("modem_cognitive")) == 1, cursor.getInt(cursor.getColumnIndexOrThrow("max_conns")), cursor.getInt(cursor.getColumnIndexOrThrow("wait_time")), cursor.getInt(cursor.getColumnIndexOrThrow("max_conns_time")), cursor.getInt(cursor.getColumnIndexOrThrow("mtu")), cursor.getString(cursor.getColumnIndexOrThrow("mvno_type")), cursor.getString(cursor.getColumnIndexOrThrow("mvno_match_data")));
    }

    public static ApnSetting makeApnSetting(ApnSetting apn) {
        return ApnSetting.makeApnSetting(apn.mId, apn.mOperatorNumeric, apn.mEntryName, apn.mApnName, apn.mProxy, apn.mPort, apn.mMmsc, apn.mMmsProxy, apn.mMmsPort, apn.mUser, apn.mPassword, apn.mAuthType, apn.mTypes, apn.mProtocol, apn.mRoamingProtocol, apn.mCarrierEnabled, apn.mNetworkTypeBitmask, apn.mProfileId, apn.mModemCognitive, apn.mMaxConns, apn.mWaitTime, apn.mMaxConnsTime, apn.mMtu, apn.mMvnoType, apn.mMvnoMatchData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ApnSettingV4] ").append(this.mEntryName).append(", ").append(this.mId).append(", ").append(this.mOperatorNumeric).append(", ").append(this.mApnName).append(", ").append(ApnSetting.inetAddressToString(this.mProxy)).append(", ").append(ApnSetting.URLToString(this.mMmsc)).append(", ").append(ApnSetting.inetAddressToString(this.mMmsProxy)).append(", ").append(ApnSetting.portToString(this.mMmsPort)).append(", ").append(ApnSetting.portToString(this.mPort)).append(", ").append(this.mAuthType).append(", ");
        for (int i = 0; i < this.mTypes.size(); ++i) {
            sb.append(this.mTypes.get(i));
            if (i >= this.mTypes.size() - 1) continue;
            sb.append(" | ");
        }
        sb.append(", ").append(this.mProtocol);
        sb.append(", ").append(this.mRoamingProtocol);
        sb.append(", ").append(this.mCarrierEnabled);
        sb.append(", ").append(this.mProfileId);
        sb.append(", ").append(this.mModemCognitive);
        sb.append(", ").append(this.mMaxConns);
        sb.append(", ").append(this.mWaitTime);
        sb.append(", ").append(this.mMaxConnsTime);
        sb.append(", ").append(this.mMtu);
        sb.append(", ").append(this.mMvnoType);
        sb.append(", ").append(this.mMvnoMatchData);
        sb.append(", ").append(this.mPermanentFailed);
        sb.append(", ").append(this.mNetworkTypeBitmask);
        return sb.toString();
    }

    public boolean hasMvnoParams() {
        return !TextUtils.isEmpty(this.mMvnoType) && !TextUtils.isEmpty(this.mMvnoMatchData);
    }

    public boolean canHandleType(String type) {
        if (!this.mCarrierEnabled) {
            return false;
        }
        boolean wildcardable = true;
        if (TYPE_IA.equalsIgnoreCase(type)) {
            wildcardable = false;
        }
        for (String t : this.mTypes) {
            if (!t.equalsIgnoreCase(type) && (!wildcardable || !t.equalsIgnoreCase(TYPE_ALL)) && (!t.equalsIgnoreCase(TYPE_DEFAULT) || !type.equalsIgnoreCase(TYPE_HIPRI))) continue;
            return true;
        }
        return false;
    }

    private boolean typeSameAny(ApnSetting first, ApnSetting second) {
        for (int index1 = 0; index1 < first.mTypes.size(); ++index1) {
            for (int index2 = 0; index2 < second.mTypes.size(); ++index2) {
                if (!first.mTypes.get(index1).equals(TYPE_ALL) && !second.mTypes.get(index2).equals(TYPE_ALL) && !first.mTypes.get(index1).equals(second.mTypes.get(index2))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ApnSetting)) {
            return false;
        }
        ApnSetting other = (ApnSetting)o;
        return this.mEntryName.equals(other.mEntryName) && Objects.equals(this.mId, other.mId) && Objects.equals(this.mOperatorNumeric, other.mOperatorNumeric) && Objects.equals(this.mApnName, other.mApnName) && Objects.equals(this.mProxy, other.mProxy) && Objects.equals(this.mMmsc, other.mMmsc) && Objects.equals(this.mMmsProxy, other.mMmsProxy) && Objects.equals(this.mMmsPort, other.mMmsPort) && Objects.equals(this.mPort, other.mPort) && Objects.equals(this.mUser, other.mUser) && Objects.equals(this.mPassword, other.mPassword) && Objects.equals(this.mAuthType, other.mAuthType) && Objects.equals(this.mTypes, other.mTypes) && Objects.equals(this.mTypesBitmap, other.mTypesBitmap) && Objects.equals(this.mProtocol, other.mProtocol) && Objects.equals(this.mRoamingProtocol, other.mRoamingProtocol) && Objects.equals(this.mCarrierEnabled, other.mCarrierEnabled) && Objects.equals(this.mProfileId, other.mProfileId) && Objects.equals(this.mModemCognitive, other.mModemCognitive) && Objects.equals(this.mMaxConns, other.mMaxConns) && Objects.equals(this.mWaitTime, other.mWaitTime) && Objects.equals(this.mMaxConnsTime, other.mMaxConnsTime) && Objects.equals(this.mMtu, other.mMtu) && Objects.equals(this.mMvnoType, other.mMvnoType) && Objects.equals(this.mMvnoMatchData, other.mMvnoMatchData) && Objects.equals(this.mNetworkTypeBitmask, other.mNetworkTypeBitmask);
    }

    public boolean equals(Object o, boolean isDataRoaming) {
        if (!(o instanceof ApnSetting)) {
            return false;
        }
        ApnSetting other = (ApnSetting)o;
        return !(!this.mEntryName.equals(other.mEntryName) || !Objects.equals(this.mOperatorNumeric, other.mOperatorNumeric) || !Objects.equals(this.mApnName, other.mApnName) || !Objects.equals(this.mProxy, other.mProxy) || !Objects.equals(this.mMmsc, other.mMmsc) || !Objects.equals(this.mMmsProxy, other.mMmsProxy) || !Objects.equals(this.mMmsPort, other.mMmsPort) || !Objects.equals(this.mPort, other.mPort) || !Objects.equals(this.mUser, other.mUser) || !Objects.equals(this.mPassword, other.mPassword) || !Objects.equals(this.mAuthType, other.mAuthType) || !Objects.equals(this.mTypes, other.mTypes) || !Objects.equals(this.mTypesBitmap, other.mTypesBitmap) || !isDataRoaming && !Objects.equals(this.mProtocol, other.mProtocol) || isDataRoaming && !Objects.equals(this.mRoamingProtocol, other.mRoamingProtocol) || !Objects.equals(this.mCarrierEnabled, other.mCarrierEnabled) || !Objects.equals(this.mProfileId, other.mProfileId) || !Objects.equals(this.mModemCognitive, other.mModemCognitive) || !Objects.equals(this.mMaxConns, other.mMaxConns) || !Objects.equals(this.mWaitTime, other.mWaitTime) || !Objects.equals(this.mMaxConnsTime, other.mMaxConnsTime) || !Objects.equals(this.mMtu, other.mMtu) || !Objects.equals(this.mMvnoType, other.mMvnoType) || !Objects.equals(this.mMvnoMatchData, other.mMvnoMatchData));
    }

    public boolean similar(ApnSetting other) {
        return !this.canHandleType(TYPE_DUN) && !other.canHandleType(TYPE_DUN) && Objects.equals(this.mApnName, other.mApnName) && !this.typeSameAny(this, other) && this.xorEqualsInetAddress(this.mProxy, other.mProxy) && this.xorEqualsPort(this.mPort, other.mPort) && this.xorEquals(this.mProtocol, other.mProtocol) && this.xorEquals(this.mRoamingProtocol, other.mRoamingProtocol) && Objects.equals(this.mCarrierEnabled, other.mCarrierEnabled) && Objects.equals(this.mProfileId, other.mProfileId) && Objects.equals(this.mMvnoType, other.mMvnoType) && Objects.equals(this.mMvnoMatchData, other.mMvnoMatchData) && this.xorEqualsURL(this.mMmsc, other.mMmsc) && this.xorEqualsInetAddress(this.mMmsProxy, other.mMmsProxy) && this.xorEqualsPort(this.mMmsPort, other.mMmsPort) && Objects.equals(this.mNetworkTypeBitmask, other.mNetworkTypeBitmask);
    }

    private boolean xorEquals(String first, String second) {
        return Objects.equals(first, second) || TextUtils.isEmpty(first) || TextUtils.isEmpty(second);
    }

    private boolean xorEqualsInetAddress(InetAddress first, InetAddress second) {
        return first == null || second == null || first.equals(second);
    }

    private boolean xorEqualsURL(URL first, URL second) {
        return first == null || second == null || first.equals(second);
    }

    private boolean xorEqualsPort(int first, int second) {
        return first == -1 || second == -1 || Objects.equals(first, second);
    }

    private static int getApnBitmask(String apn) {
        switch (apn) {
            case "default": {
                return 1;
            }
            case "mms": {
                return 2;
            }
            case "supl": {
                return 4;
            }
            case "dun": {
                return 8;
            }
            case "hipri": {
                return 16;
            }
            case "fota": {
                return 32;
            }
            case "ims": {
                return 64;
            }
            case "cbs": {
                return 128;
            }
            case "ia": {
                return 256;
            }
            case "emergency": {
                return 512;
            }
            case "*": {
                return 1023;
            }
        }
        return 0;
    }

    private String deParseTypes(List<String> types) {
        if (types == null) {
            return null;
        }
        return TextUtils.join((CharSequence)",", types);
    }

    private String nullToEmpty(String stringValue) {
        return stringValue == null ? "" : stringValue;
    }

    public ContentValues toContentValues() {
        ContentValues apnValue = new ContentValues();
        apnValue.put("numeric", this.nullToEmpty(this.mOperatorNumeric));
        apnValue.put("name", this.nullToEmpty(this.mEntryName));
        apnValue.put("apn", this.nullToEmpty(this.mApnName));
        apnValue.put("proxy", this.mProxy == null ? "" : ApnSetting.inetAddressToString(this.mProxy));
        apnValue.put("port", ApnSetting.portToString(this.mPort));
        apnValue.put("mmsc", this.mMmsc == null ? "" : ApnSetting.URLToString(this.mMmsc));
        apnValue.put("mmsport", ApnSetting.portToString(this.mMmsPort));
        apnValue.put("mmsproxy", this.mMmsProxy == null ? "" : ApnSetting.inetAddressToString(this.mMmsProxy));
        apnValue.put("user", this.nullToEmpty(this.mUser));
        apnValue.put("password", this.nullToEmpty(this.mPassword));
        apnValue.put("authtype", this.mAuthType);
        String apnType = this.deParseTypes(this.mTypes);
        apnValue.put("type", this.nullToEmpty(apnType));
        apnValue.put("protocol", this.nullToEmpty(this.mProtocol));
        apnValue.put("roaming_protocol", this.nullToEmpty(this.mRoamingProtocol));
        apnValue.put("carrier_enabled", this.mCarrierEnabled);
        apnValue.put("mvno_type", this.nullToEmpty(this.mMvnoType));
        apnValue.put("network_type_bitmask", this.mNetworkTypeBitmask);
        return apnValue;
    }

    public static String[] parseTypes(String types) {
        String[] result = TextUtils.isEmpty(types) ? new String[]{TYPE_ALL} : types.split(",");
        return result;
    }

    private static URL URLFromString(String url) {
        try {
            return TextUtils.isEmpty(url) ? null : new URL(url);
        }
        catch (MalformedURLException e) {
            Log.e(LOG_TAG, "Can't parse URL from string.");
            return null;
        }
    }

    private static String URLToString(URL url) {
        return url == null ? "" : url.toString();
    }

    private static InetAddress inetAddressFromString(String inetAddress) {
        if (TextUtils.isEmpty(inetAddress)) {
            return null;
        }
        try {
            return InetAddress.getByName(inetAddress);
        }
        catch (UnknownHostException e) {
            Log.e(LOG_TAG, "Can't parse InetAddress from string: unknown host.");
            return null;
        }
    }

    private static String inetAddressToString(InetAddress inetAddress) {
        if (inetAddress == null) {
            return null;
        }
        String inetAddressString = inetAddress.toString();
        if (TextUtils.isEmpty(inetAddressString)) {
            return null;
        }
        String hostName = inetAddressString.substring(0, inetAddressString.indexOf("/"));
        String address = inetAddressString.substring(inetAddressString.indexOf("/") + 1);
        if (TextUtils.isEmpty(hostName) && TextUtils.isEmpty(address)) {
            return null;
        }
        return TextUtils.isEmpty(hostName) ? address : hostName;
    }

    private static int portFromString(String strPort) {
        int port = -1;
        if (!TextUtils.isEmpty(strPort)) {
            try {
                port = Integer.parseInt(strPort);
            }
            catch (NumberFormatException e) {
                Log.e(LOG_TAG, "Can't parse port from String");
            }
        }
        return port;
    }

    private static String portToString(int port) {
        return port == -1 ? "" : Integer.toString(port);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mId);
        dest.writeString(this.mOperatorNumeric);
        dest.writeString(this.mEntryName);
        dest.writeString(this.mApnName);
        dest.writeValue(this.mProxy);
        dest.writeInt(this.mPort);
        dest.writeValue(this.mMmsc);
        dest.writeValue(this.mMmsProxy);
        dest.writeInt(this.mMmsPort);
        dest.writeString(this.mUser);
        dest.writeString(this.mPassword);
        dest.writeInt(this.mAuthType);
        dest.writeStringArray(this.mTypes.toArray(new String[0]));
        dest.writeString(this.mProtocol);
        dest.writeString(this.mRoamingProtocol);
        dest.writeInt(this.mCarrierEnabled ? 1 : 0);
        dest.writeString(this.mMvnoType);
        dest.writeInt(this.mNetworkTypeBitmask);
    }

    private static ApnSetting readFromParcel(Parcel in) {
        int id2 = in.readInt();
        String operatorNumeric = in.readString();
        String entryName = in.readString();
        String apnName = in.readString();
        InetAddress proxy = (InetAddress)in.readValue(InetAddress.class.getClassLoader());
        int port = in.readInt();
        URL mmsc = (URL)in.readValue(URL.class.getClassLoader());
        InetAddress mmsProxy = (InetAddress)in.readValue(InetAddress.class.getClassLoader());
        int mmsPort = in.readInt();
        String user = in.readString();
        String password = in.readString();
        int authType = in.readInt();
        List<String> types = Arrays.asList(in.readStringArray());
        String protocol = in.readString();
        String roamingProtocol = in.readString();
        boolean carrierEnabled = in.readInt() > 0;
        String mvnoType = in.readString();
        int networkTypeBitmask = in.readInt();
        return ApnSetting.makeApnSetting(id2, operatorNumeric, entryName, apnName, proxy, port, mmsc, mmsProxy, mmsPort, user, password, authType, types, protocol, roamingProtocol, carrierEnabled, networkTypeBitmask, 0, false, 0, 0, 0, 0, mvnoType, null);
    }

    public static class Builder {
        private String mEntryName;
        private String mApnName;
        private InetAddress mProxy;
        private int mPort = -1;
        private URL mMmsc;
        private InetAddress mMmsProxy;
        private int mMmsPort = -1;
        private String mUser;
        private String mPassword;
        private int mAuthType;
        private List<String> mTypes;
        private int mTypesBitmap;
        private int mId;
        private String mOperatorNumeric;
        private String mProtocol;
        private String mRoamingProtocol;
        private int mMtu;
        private int mNetworkTypeBitmask;
        private boolean mCarrierEnabled;
        private int mProfileId;
        private boolean mModemCognitive;
        private int mMaxConns;
        private int mWaitTime;
        private int mMaxConnsTime;
        private String mMvnoType;
        private String mMvnoMatchData;

        private Builder setId(int id2) {
            this.mId = id2;
            return this;
        }

        public Builder setMtu(int mtu) {
            this.mMtu = mtu;
            return this;
        }

        public Builder setProfileId(int profileId) {
            this.mProfileId = profileId;
            return this;
        }

        public Builder setModemCognitive(boolean modemCognitive) {
            this.mModemCognitive = modemCognitive;
            return this;
        }

        public Builder setMaxConns(int maxConns) {
            this.mMaxConns = maxConns;
            return this;
        }

        public Builder setWaitTime(int waitTime) {
            this.mWaitTime = waitTime;
            return this;
        }

        public Builder setMaxConnsTime(int maxConnsTime) {
            this.mMaxConnsTime = maxConnsTime;
            return this;
        }

        public Builder setMvnoMatchData(String mvnoMatchData) {
            this.mMvnoMatchData = mvnoMatchData;
            return this;
        }

        public Builder setEntryName(String entryName) {
            this.mEntryName = entryName;
            return this;
        }

        public Builder setApnName(String apnName) {
            this.mApnName = apnName;
            return this;
        }

        public Builder setProxy(InetAddress proxy) {
            this.mProxy = proxy;
            return this;
        }

        public Builder setPort(int port) {
            this.mPort = port;
            return this;
        }

        public Builder setMmsc(URL mmsc) {
            this.mMmsc = mmsc;
            return this;
        }

        public Builder setMmsProxy(InetAddress mmsProxy) {
            this.mMmsProxy = mmsProxy;
            return this;
        }

        public Builder setMmsPort(int mmsPort) {
            this.mMmsPort = mmsPort;
            return this;
        }

        public Builder setUser(String user) {
            this.mUser = user;
            return this;
        }

        public Builder setPassword(String password) {
            this.mPassword = password;
            return this;
        }

        public Builder setAuthType(int authType) {
            this.mAuthType = authType;
            return this;
        }

        public Builder setTypes(List<String> types) {
            this.mTypes = types;
            int apnBitmap = 0;
            for (int i = 0; i < this.mTypes.size(); ++i) {
                this.mTypes.set(i, this.mTypes.get(i).toLowerCase());
                apnBitmap |= ApnSetting.getApnBitmask(this.mTypes.get(i));
            }
            this.mTypesBitmap = apnBitmap;
            return this;
        }

        public Builder setOperatorNumeric(String operatorNumeric) {
            this.mOperatorNumeric = operatorNumeric;
            return this;
        }

        public Builder setProtocol(String protocol) {
            this.mProtocol = protocol;
            return this;
        }

        public Builder setRoamingProtocol(String roamingProtocol) {
            this.mRoamingProtocol = roamingProtocol;
            return this;
        }

        public Builder setCarrierEnabled(boolean carrierEnabled) {
            this.mCarrierEnabled = carrierEnabled;
            return this;
        }

        public Builder setNetworkTypeBitmask(int networkTypeBitmask) {
            this.mNetworkTypeBitmask = networkTypeBitmask;
            return this;
        }

        public Builder setMvnoType(String mvnoType) {
            this.mMvnoType = mvnoType;
            return this;
        }

        public ApnSetting build() {
            return new ApnSetting(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MvnoType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProtocolType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ApnType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AuthType {
    }
}

