/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.data;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

@SystemApi
public final class DataProfile
implements Parcelable {
    public static final int TYPE_COMMON = 0;
    public static final int TYPE_3GPP = 1;
    public static final int TYPE_3GPP2 = 2;
    private final int mProfileId;
    private final String mApn;
    private final String mProtocol;
    private final int mAuthType;
    private final String mUserName;
    private final String mPassword;
    private final int mType;
    private final int mMaxConnsTime;
    private final int mMaxConns;
    private final int mWaitTime;
    private final boolean mEnabled;
    private final int mSupportedApnTypesBitmap;
    private final String mRoamingProtocol;
    private final int mBearerBitmap;
    private final int mMtu;
    private final String mMvnoType;
    private final String mMvnoMatchData;
    private final boolean mModemCognitive;
    public static final Parcelable.Creator<DataProfile> CREATOR = new Parcelable.Creator<DataProfile>(){

        @Override
        public DataProfile createFromParcel(Parcel source) {
            return new DataProfile(source);
        }

        public DataProfile[] newArray(int size) {
            return new DataProfile[size];
        }
    };

    public DataProfile(int profileId, String apn, String protocol, int authType, String userName, String password, int type, int maxConnsTime, int maxConns, int waitTime, boolean enabled, int supportedApnTypesBitmap, String roamingProtocol, int bearerBitmap, int mtu, String mvnoType, String mvnoMatchData, boolean modemCognitive) {
        this.mProfileId = profileId;
        this.mApn = apn;
        this.mProtocol = protocol;
        if (authType == -1) {
            authType = TextUtils.isEmpty(userName) ? 0 : 3;
        }
        this.mAuthType = authType;
        this.mUserName = userName;
        this.mPassword = password;
        this.mType = type;
        this.mMaxConnsTime = maxConnsTime;
        this.mMaxConns = maxConns;
        this.mWaitTime = waitTime;
        this.mEnabled = enabled;
        this.mSupportedApnTypesBitmap = supportedApnTypesBitmap;
        this.mRoamingProtocol = roamingProtocol;
        this.mBearerBitmap = bearerBitmap;
        this.mMtu = mtu;
        this.mMvnoType = mvnoType;
        this.mMvnoMatchData = mvnoMatchData;
        this.mModemCognitive = modemCognitive;
    }

    public DataProfile(Parcel source) {
        this.mProfileId = source.readInt();
        this.mApn = source.readString();
        this.mProtocol = source.readString();
        this.mAuthType = source.readInt();
        this.mUserName = source.readString();
        this.mPassword = source.readString();
        this.mType = source.readInt();
        this.mMaxConnsTime = source.readInt();
        this.mMaxConns = source.readInt();
        this.mWaitTime = source.readInt();
        this.mEnabled = source.readBoolean();
        this.mSupportedApnTypesBitmap = source.readInt();
        this.mRoamingProtocol = source.readString();
        this.mBearerBitmap = source.readInt();
        this.mMtu = source.readInt();
        this.mMvnoType = source.readString();
        this.mMvnoMatchData = source.readString();
        this.mModemCognitive = source.readBoolean();
    }

    public int getProfileId() {
        return this.mProfileId;
    }

    public String getApn() {
        return this.mApn;
    }

    public String getProtocol() {
        return this.mProtocol;
    }

    public int getAuthType() {
        return this.mAuthType;
    }

    public String getUserName() {
        return this.mUserName;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public int getType() {
        return this.mType;
    }

    public int getMaxConnsTime() {
        return this.mMaxConnsTime;
    }

    public int getMaxConns() {
        return this.mMaxConns;
    }

    public int getWaitTime() {
        return this.mWaitTime;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public int getSupportedApnTypesBitmap() {
        return this.mSupportedApnTypesBitmap;
    }

    public String getRoamingProtocol() {
        return this.mRoamingProtocol;
    }

    public int getBearerBitmap() {
        return this.mBearerBitmap;
    }

    public int getMtu() {
        return this.mMtu;
    }

    public String getMvnoType() {
        return this.mMvnoType;
    }

    public String getMvnoMatchData() {
        return this.mMvnoMatchData;
    }

    public boolean isModemCognitive() {
        return this.mModemCognitive;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "DataProfile=" + this.mProfileId + "/" + this.mApn + "/" + this.mProtocol + "/" + this.mAuthType + "/" + this.mUserName + "/" + this.mPassword + "/" + this.mType + "/" + this.mMaxConnsTime + "/" + this.mMaxConns + "/" + this.mWaitTime + "/" + this.mEnabled + "/" + this.mSupportedApnTypesBitmap + "/" + this.mRoamingProtocol + "/" + this.mBearerBitmap + "/" + this.mMtu + "/" + this.mMvnoType + "/" + this.mMvnoMatchData + "/" + this.mModemCognitive;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DataProfile)) {
            return false;
        }
        return o == this || this.toString().equals(o.toString());
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mProfileId);
        dest.writeString(this.mApn);
        dest.writeString(this.mProtocol);
        dest.writeInt(this.mAuthType);
        dest.writeString(this.mUserName);
        dest.writeString(this.mPassword);
        dest.writeInt(this.mType);
        dest.writeInt(this.mMaxConnsTime);
        dest.writeInt(this.mMaxConns);
        dest.writeInt(this.mWaitTime);
        dest.writeBoolean(this.mEnabled);
        dest.writeInt(this.mSupportedApnTypesBitmap);
        dest.writeString(this.mRoamingProtocol);
        dest.writeInt(this.mBearerBitmap);
        dest.writeInt(this.mMtu);
        dest.writeString(this.mMvnoType);
        dest.writeString(this.mMvnoMatchData);
        dest.writeBoolean(this.mModemCognitive);
    }
}

