/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.data;

import android.net.LinkProperties;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.data.DataProfile;
import android.telephony.data.IDataServiceCallback;
import java.util.ArrayList;
import java.util.List;

public interface IDataService
extends IInterface {
    public void createDataServiceProvider(int var1) throws RemoteException;

    public void removeDataServiceProvider(int var1) throws RemoteException;

    public void setupDataCall(int var1, int var2, DataProfile var3, boolean var4, boolean var5, int var6, LinkProperties var7, IDataServiceCallback var8) throws RemoteException;

    public void deactivateDataCall(int var1, int var2, int var3, IDataServiceCallback var4) throws RemoteException;

    public void setInitialAttachApn(int var1, DataProfile var2, boolean var3, IDataServiceCallback var4) throws RemoteException;

    public void setDataProfile(int var1, List<DataProfile> var2, boolean var3, IDataServiceCallback var4) throws RemoteException;

    public void getDataCallList(int var1, IDataServiceCallback var2) throws RemoteException;

    public void registerForDataCallListChanged(int var1, IDataServiceCallback var2) throws RemoteException;

    public void unregisterForDataCallListChanged(int var1, IDataServiceCallback var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDataService {
        private static final String DESCRIPTOR = "android.telephony.data.IDataService";
        static final int TRANSACTION_createDataServiceProvider = 1;
        static final int TRANSACTION_removeDataServiceProvider = 2;
        static final int TRANSACTION_setupDataCall = 3;
        static final int TRANSACTION_deactivateDataCall = 4;
        static final int TRANSACTION_setInitialAttachApn = 5;
        static final int TRANSACTION_setDataProfile = 6;
        static final int TRANSACTION_getDataCallList = 7;
        static final int TRANSACTION_registerForDataCallListChanged = 8;
        static final int TRANSACTION_unregisterForDataCallListChanged = 9;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IDataService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IDataService) {
                return (IDataService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.createDataServiceProvider(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.removeDataServiceProvider(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    DataProfile _arg2 = 0 != data.readInt() ? DataProfile.CREATOR.createFromParcel(data) : null;
                    boolean _arg3 = 0 != data.readInt();
                    boolean _arg4 = 0 != data.readInt();
                    int _arg5 = data.readInt();
                    LinkProperties _arg6 = 0 != data.readInt() ? LinkProperties.CREATOR.createFromParcel(data) : null;
                    IDataServiceCallback _arg7 = IDataServiceCallback.Stub.asInterface(data.readStrongBinder());
                    this.setupDataCall(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    IDataServiceCallback _arg3 = IDataServiceCallback.Stub.asInterface(data.readStrongBinder());
                    this.deactivateDataCall(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    DataProfile _arg1 = 0 != data.readInt() ? DataProfile.CREATOR.createFromParcel(data) : null;
                    boolean _arg2 = 0 != data.readInt();
                    IDataServiceCallback _arg3 = IDataServiceCallback.Stub.asInterface(data.readStrongBinder());
                    this.setInitialAttachApn(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    ArrayList<DataProfile> _arg1 = data.createTypedArrayList(DataProfile.CREATOR);
                    boolean _arg2 = 0 != data.readInt();
                    IDataServiceCallback _arg3 = IDataServiceCallback.Stub.asInterface(data.readStrongBinder());
                    this.setDataProfile(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    IDataServiceCallback _arg1 = IDataServiceCallback.Stub.asInterface(data.readStrongBinder());
                    this.getDataCallList(_arg0, _arg1);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    IDataServiceCallback _arg1 = IDataServiceCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerForDataCallListChanged(_arg0, _arg1);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    IDataServiceCallback _arg1 = IDataServiceCallback.Stub.asInterface(data.readStrongBinder());
                    this.unregisterForDataCallListChanged(_arg0, _arg1);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IDataService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void createDataServiceProvider(int slotId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(slotId);
                    this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void removeDataServiceProvider(int slotId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(slotId);
                    this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setupDataCall(int slotId, int accessNetwork, DataProfile dataProfile, boolean isRoaming, boolean allowRoaming, int reason, LinkProperties linkProperties, IDataServiceCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(slotId);
                    _data.writeInt(accessNetwork);
                    if (dataProfile != null) {
                        _data.writeInt(1);
                        dataProfile.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(isRoaming ? 1 : 0);
                    _data.writeInt(allowRoaming ? 1 : 0);
                    _data.writeInt(reason);
                    if (linkProperties != null) {
                        _data.writeInt(1);
                        linkProperties.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deactivateDataCall(int slotId, int cid, int reason, IDataServiceCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(slotId);
                    _data.writeInt(cid);
                    _data.writeInt(reason);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInitialAttachApn(int slotId, DataProfile dataProfile, boolean isRoaming, IDataServiceCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(slotId);
                    if (dataProfile != null) {
                        _data.writeInt(1);
                        dataProfile.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(isRoaming ? 1 : 0);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDataProfile(int slotId, List<DataProfile> dps, boolean isRoaming, IDataServiceCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(slotId);
                    _data.writeTypedList(dps);
                    _data.writeInt(isRoaming ? 1 : 0);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getDataCallList(int slotId, IDataServiceCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(slotId);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerForDataCallListChanged(int slotId, IDataServiceCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(slotId);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterForDataCallListChanged(int slotId, IDataServiceCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(slotId);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }
}

