/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.compat.stub;

import android.content.Context;
import android.content.Intent;
import android.os.RemoteException;
import android.util.Log;
import com.android.ims.ImsConfigListener;
import com.android.ims.internal.IImsConfig;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class ImsConfigImplBase {
    private static final String TAG = "ImsConfigImplBase";
    ImsConfigStub mImsConfigStub;

    public ImsConfigImplBase(Context context) {
        this.mImsConfigStub = new ImsConfigStub(this, context);
    }

    public int getProvisionedValue(int item) throws RemoteException {
        return -1;
    }

    public String getProvisionedStringValue(int item) throws RemoteException {
        return null;
    }

    public int setProvisionedValue(int item, int value) throws RemoteException {
        return 1;
    }

    public int setProvisionedStringValue(int item, String value) throws RemoteException {
        return 1;
    }

    public void getFeatureValue(int feature, int network, ImsConfigListener listener) throws RemoteException {
    }

    public void setFeatureValue(int feature, int network, int value, ImsConfigListener listener) throws RemoteException {
    }

    public boolean getVolteProvisioned() throws RemoteException {
        return false;
    }

    public void getVideoQuality(ImsConfigListener listener) throws RemoteException {
    }

    public void setVideoQuality(int quality, ImsConfigListener listener) throws RemoteException {
    }

    public IImsConfig getIImsConfig() {
        return this.mImsConfigStub;
    }

    public final void notifyProvisionedValueChanged(int item, int value) {
        this.mImsConfigStub.updateCachedValue(item, value, true);
    }

    public final void notifyProvisionedValueChanged(int item, String value) {
        this.mImsConfigStub.updateCachedValue(item, value, true);
    }

    @VisibleForTesting
    public static class ImsConfigStub
    extends IImsConfig.Stub {
        Context mContext;
        WeakReference<ImsConfigImplBase> mImsConfigImplBaseWeakReference;
        private HashMap<Integer, Integer> mProvisionedIntValue = new HashMap();
        private HashMap<Integer, String> mProvisionedStringValue = new HashMap();

        @VisibleForTesting
        public ImsConfigStub(ImsConfigImplBase imsConfigImplBase, Context context) {
            this.mContext = context;
            this.mImsConfigImplBaseWeakReference = new WeakReference<ImsConfigImplBase>(imsConfigImplBase);
        }

        @Override
        public synchronized int getProvisionedValue(int item) throws RemoteException {
            if (this.mProvisionedIntValue.containsKey(item)) {
                return this.mProvisionedIntValue.get(item);
            }
            int retVal = this.getImsConfigImpl().getProvisionedValue(item);
            if (retVal != -1) {
                this.updateCachedValue(item, retVal, false);
            }
            return retVal;
        }

        @Override
        public synchronized String getProvisionedStringValue(int item) throws RemoteException {
            if (this.mProvisionedIntValue.containsKey(item)) {
                return this.mProvisionedStringValue.get(item);
            }
            String retVal = this.getImsConfigImpl().getProvisionedStringValue(item);
            if (retVal != null) {
                this.updateCachedValue(item, retVal, false);
            }
            return retVal;
        }

        @Override
        public synchronized int setProvisionedValue(int item, int value) throws RemoteException {
            this.mProvisionedIntValue.remove(item);
            int retVal = this.getImsConfigImpl().setProvisionedValue(item, value);
            if (retVal == 0) {
                this.updateCachedValue(item, value, true);
            } else {
                Log.d(ImsConfigImplBase.TAG, "Set provision value of " + item + " to " + value + " failed with error code " + retVal);
            }
            return retVal;
        }

        @Override
        public synchronized int setProvisionedStringValue(int item, String value) throws RemoteException {
            this.mProvisionedStringValue.remove(item);
            int retVal = this.getImsConfigImpl().setProvisionedStringValue(item, value);
            if (retVal == 0) {
                this.updateCachedValue(item, value, true);
            }
            return retVal;
        }

        @Override
        public void getFeatureValue(int feature, int network, ImsConfigListener listener) throws RemoteException {
            this.getImsConfigImpl().getFeatureValue(feature, network, listener);
        }

        @Override
        public void setFeatureValue(int feature, int network, int value, ImsConfigListener listener) throws RemoteException {
            this.getImsConfigImpl().setFeatureValue(feature, network, value, listener);
        }

        @Override
        public boolean getVolteProvisioned() throws RemoteException {
            return this.getImsConfigImpl().getVolteProvisioned();
        }

        @Override
        public void getVideoQuality(ImsConfigListener listener) throws RemoteException {
            this.getImsConfigImpl().getVideoQuality(listener);
        }

        @Override
        public void setVideoQuality(int quality, ImsConfigListener listener) throws RemoteException {
            this.getImsConfigImpl().setVideoQuality(quality, listener);
        }

        private ImsConfigImplBase getImsConfigImpl() throws RemoteException {
            ImsConfigImplBase ref = (ImsConfigImplBase)this.mImsConfigImplBaseWeakReference.get();
            if (ref == null) {
                throw new RemoteException("Fail to get ImsConfigImpl");
            }
            return ref;
        }

        private void sendImsConfigChangedIntent(int item, int value) {
            this.sendImsConfigChangedIntent(item, Integer.toString(value));
        }

        private void sendImsConfigChangedIntent(int item, String value) {
            Intent configChangedIntent = new Intent("com.android.intent.action.IMS_CONFIG_CHANGED");
            configChangedIntent.putExtra("item", item);
            configChangedIntent.putExtra("value", value);
            if (this.mContext != null) {
                this.mContext.sendBroadcast(configChangedIntent);
            }
        }

        protected synchronized void updateCachedValue(int item, int value, boolean notifyChange) {
            this.mProvisionedIntValue.put(item, value);
            if (notifyChange) {
                this.sendImsConfigChangedIntent(item, value);
            }
        }

        protected synchronized void updateCachedValue(int item, String value, boolean notifyChange) {
            this.mProvisionedStringValue.put(item, value);
            if (notifyChange) {
                this.sendImsConfigChangedIntent(item, value);
            }
        }
    }
}

