/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.feature;

import android.annotation.SystemApi;
import android.content.Context;
import android.content.Intent;
import android.os.IInterface;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.telephony.ims.aidl.IImsCapabilityCallback;
import android.telephony.ims.feature.CapabilityChangeRequest;
import android.util.Log;
import com.android.ims.internal.IImsFeatureStatusCallback;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;

@SystemApi
public abstract class ImsFeature {
    private static final String LOG_TAG = "ImsFeature";
    public static final String ACTION_IMS_SERVICE_UP = "com.android.ims.IMS_SERVICE_UP";
    public static final String ACTION_IMS_SERVICE_DOWN = "com.android.ims.IMS_SERVICE_DOWN";
    public static final String EXTRA_PHONE_ID = "android:phone_id";
    public static final int FEATURE_INVALID = -1;
    public static final int FEATURE_EMERGENCY_MMTEL = 0;
    public static final int FEATURE_MMTEL = 1;
    public static final int FEATURE_RCS = 2;
    public static final int FEATURE_MAX = 3;
    public static final int STATE_UNAVAILABLE = 0;
    public static final int STATE_INITIALIZING = 1;
    public static final int STATE_READY = 2;
    public static final int CAPABILITY_ERROR_GENERIC = -1;
    public static final int CAPABILITY_SUCCESS = 0;
    private final Set<IImsFeatureStatusCallback> mStatusCallbacks = Collections.newSetFromMap(new WeakHashMap());
    private int mState = 0;
    private int mSlotId = -1;
    protected Context mContext;
    private final Object mLock = new Object();
    private final RemoteCallbackList<IImsCapabilityCallback> mCapabilityCallbacks = new RemoteCallbackList();
    private Capabilities mCapabilityStatus = new Capabilities();

    public final void initialize(Context context, int slotId) {
        this.mContext = context;
        this.mSlotId = slotId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFeatureState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setFeatureState(int state) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mState != state) {
                this.mState = state;
                this.notifyFeatureState(state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void addImsFeatureStatusCallback(IImsFeatureStatusCallback c) {
        try {
            c.notifyImsFeatureStatus(this.getFeatureState());
            Object object = this.mLock;
            synchronized (object) {
                this.mStatusCallbacks.add(c);
            }
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "Couldn't notify feature state: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void removeImsFeatureStatusCallback(IImsFeatureStatusCallback c) {
        Object object = this.mLock;
        synchronized (object) {
            this.mStatusCallbacks.remove(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFeatureState(int state) {
        Object object = this.mLock;
        synchronized (object) {
            Iterator<IImsFeatureStatusCallback> iter = this.mStatusCallbacks.iterator();
            while (iter.hasNext()) {
                IImsFeatureStatusCallback callback = iter.next();
                try {
                    Log.i(LOG_TAG, "notifying ImsFeatureState=" + state);
                    callback.notifyImsFeatureStatus(state);
                }
                catch (RemoteException e) {
                    iter.remove();
                    Log.w(LOG_TAG, "Couldn't notify feature state: " + e.getMessage());
                }
            }
        }
        this.sendImsServiceIntent(state);
    }

    private void sendImsServiceIntent(int state) {
        Intent intent;
        if (this.mContext == null || this.mSlotId == -1) {
            return;
        }
        switch (state) {
            case 0: 
            case 1: {
                intent = new Intent(ACTION_IMS_SERVICE_DOWN);
                break;
            }
            case 2: {
                intent = new Intent(ACTION_IMS_SERVICE_UP);
                break;
            }
            default: {
                intent = new Intent(ACTION_IMS_SERVICE_DOWN);
            }
        }
        intent.putExtra(EXTRA_PHONE_ID, this.mSlotId);
        this.mContext.sendBroadcast(intent);
    }

    public final void addCapabilityCallback(IImsCapabilityCallback c) {
        this.mCapabilityCallbacks.register(c);
    }

    public final void removeCapabilityCallback(IImsCapabilityCallback c) {
        this.mCapabilityCallbacks.unregister(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public Capabilities queryCapabilityStatus() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCapabilityStatus.copy();
        }
    }

    @VisibleForTesting
    public final void requestChangeEnabledCapabilities(CapabilityChangeRequest request, IImsCapabilityCallback c) {
        if (request == null) {
            throw new IllegalArgumentException("ImsFeature#requestChangeEnabledCapabilities called with invalid params.");
        }
        this.changeEnabledCapabilities(request, new CapabilityCallbackProxy(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyCapabilitiesStatusChanged(Capabilities c) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCapabilityStatus = c.copy();
        }
        int count = this.mCapabilityCallbacks.beginBroadcast();
        try {
            for (int i = 0; i < count; ++i) {
                try {
                    this.mCapabilityCallbacks.getBroadcastItem(i).onCapabilitiesStatusChanged(c.mCapabilities);
                    continue;
                }
                catch (RemoteException e) {
                    Log.w(LOG_TAG, e + " notifyCapabilitiesStatusChanged() - Skipping callback.");
                }
            }
        }
        finally {
            this.mCapabilityCallbacks.finishBroadcast();
        }
    }

    public abstract void changeEnabledCapabilities(CapabilityChangeRequest var1, CapabilityCallbackProxy var2);

    public abstract void onFeatureRemoved();

    public abstract void onFeatureReady();

    protected abstract IInterface getBinder();

    public static class Capabilities {
        protected int mCapabilities = 0;

        public Capabilities() {
        }

        protected Capabilities(int capabilities) {
            this.mCapabilities = capabilities;
        }

        public void addCapabilities(int capabilities) {
            this.mCapabilities |= capabilities;
        }

        public void removeCapabilities(int capabilities) {
            this.mCapabilities &= ~capabilities;
        }

        public boolean isCapable(int capabilities) {
            return (this.mCapabilities & capabilities) == capabilities;
        }

        public Capabilities copy() {
            return new Capabilities(this.mCapabilities);
        }

        public int getMask() {
            return this.mCapabilities;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Capabilities)) {
                return false;
            }
            Capabilities that = (Capabilities)o;
            return this.mCapabilities == that.mCapabilities;
        }

        public int hashCode() {
            return this.mCapabilities;
        }

        public String toString() {
            return "Capabilities: " + Integer.toBinaryString(this.mCapabilities);
        }
    }

    protected static class CapabilityCallbackProxy {
        private final IImsCapabilityCallback mCallback;

        public CapabilityCallbackProxy(IImsCapabilityCallback c) {
            this.mCallback = c;
        }

        public void onChangeCapabilityConfigurationError(int capability, int radioTech, int reason) {
            if (this.mCallback == null) {
                return;
            }
            try {
                this.mCallback.onChangeCapabilityConfigurationError(capability, radioTech, reason);
            }
            catch (RemoteException e) {
                Log.e(ImsFeature.LOG_TAG, "onChangeCapabilityConfigurationError called on dead binder.");
            }
        }
    }

    public static class CapabilityCallback
    extends IImsCapabilityCallback.Stub {
        @Override
        public final void onCapabilitiesStatusChanged(int config) throws RemoteException {
            this.onCapabilitiesStatusChanged(new Capabilities(config));
        }

        @Override
        public void onQueryCapabilityConfiguration(int capability, int radioTech, boolean isEnabled) {
        }

        @Override
        public void onChangeCapabilityConfigurationError(int capability, int radioTech, int reason) {
        }

        public void onCapabilitiesStatusChanged(Capabilities config) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ImsCapabilityError {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ImsState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FeatureType {
    }
}

