/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.stub;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import java.util.Set;

@SystemApi
public final class ImsFeatureConfiguration
implements Parcelable {
    private final Set<Integer> mFeatures;
    public static final Parcelable.Creator<ImsFeatureConfiguration> CREATOR = new Parcelable.Creator<ImsFeatureConfiguration>(){

        @Override
        public ImsFeatureConfiguration createFromParcel(Parcel in) {
            return new ImsFeatureConfiguration(in);
        }

        public ImsFeatureConfiguration[] newArray(int size) {
            return new ImsFeatureConfiguration[size];
        }
    };

    public ImsFeatureConfiguration() {
        this.mFeatures = new ArraySet<Integer>();
    }

    public ImsFeatureConfiguration(int[] features) {
        this.mFeatures = new ArraySet<Integer>();
        if (features != null) {
            for (int i : features) {
                this.mFeatures.add(i);
            }
        }
    }

    public int[] getServiceFeatures() {
        return this.mFeatures.stream().mapToInt(i -> i).toArray();
    }

    void addFeature(int feature) {
        this.mFeatures.add(feature);
    }

    protected ImsFeatureConfiguration(Parcel in) {
        int[] features = in.createIntArray();
        if (features != null) {
            this.mFeatures = new ArraySet<Integer>(features.length);
            int[] nArray = features;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer i2 = nArray[i];
                this.mFeatures.add(i2);
            }
        } else {
            this.mFeatures = new ArraySet<Integer>();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeIntArray(this.mFeatures.stream().mapToInt(i -> i).toArray());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImsFeatureConfiguration)) {
            return false;
        }
        ImsFeatureConfiguration that = (ImsFeatureConfiguration)o;
        return this.mFeatures.equals(that.mFeatures);
    }

    public int hashCode() {
        return this.mFeatures.hashCode();
    }

    public static class Builder {
        ImsFeatureConfiguration mConfig = new ImsFeatureConfiguration();

        public Builder addFeature(int feature) {
            this.mConfig.addFeature(feature);
            return this;
        }

        public ImsFeatureConfiguration build() {
            return this.mConfig;
        }
    }
}

