/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.mbms;

import android.os.Handler;
import android.os.RemoteException;
import android.telephony.mbms.IMbmsStreamingSessionCallback;
import android.telephony.mbms.MbmsStreamingSessionCallback;
import android.telephony.mbms.StreamingServiceInfo;
import java.util.List;

public class InternalStreamingSessionCallback
extends IMbmsStreamingSessionCallback.Stub {
    private final Handler mHandler;
    private final MbmsStreamingSessionCallback mAppCallback;
    private volatile boolean mIsStopped = false;

    public InternalStreamingSessionCallback(MbmsStreamingSessionCallback appCallback, Handler handler) {
        this.mAppCallback = appCallback;
        this.mHandler = handler;
    }

    @Override
    public void onError(final int errorCode, final String message) throws RemoteException {
        if (this.mIsStopped) {
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                InternalStreamingSessionCallback.this.mAppCallback.onError(errorCode, message);
            }
        });
    }

    @Override
    public void onStreamingServicesUpdated(final List<StreamingServiceInfo> services) throws RemoteException {
        if (this.mIsStopped) {
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                InternalStreamingSessionCallback.this.mAppCallback.onStreamingServicesUpdated(services);
            }
        });
    }

    @Override
    public void onMiddlewareReady() throws RemoteException {
        if (this.mIsStopped) {
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                InternalStreamingSessionCallback.this.mAppCallback.onMiddlewareReady();
            }
        });
    }

    public Handler getHandler() {
        return this.mHandler;
    }

    public void stop() {
        this.mIsStopped = true;
    }
}

