/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import com.android.internal.util.ArrayUtils;
import libcore.util.EmptyArray;

public final class AutoGrowArray {
    private static final int MIN_CAPACITY_INCREMENT = 12;
    private static final int MAX_CAPACITY_TO_BE_KEPT = 10000;

    private static int computeNewCapacity(int currentSize, int requested) {
        int targetCapacity = currentSize + (currentSize < 6 ? 12 : currentSize >> 1);
        return targetCapacity > requested ? targetCapacity : requested;
    }

    public static class FloatArray {
        private float[] mValues;
        private int mSize;

        public FloatArray() {
            this(10);
        }

        public FloatArray(int initialCapacity) {
            this.mValues = initialCapacity == 0 ? EmptyArray.FLOAT : ArrayUtils.newUnpaddedFloatArray(initialCapacity);
            this.mSize = 0;
        }

        public void resize(int newSize) {
            if (newSize > this.mValues.length) {
                this.ensureCapacity(newSize - this.mSize);
            }
            this.mSize = newSize;
        }

        public void append(float value) {
            this.ensureCapacity(1);
            this.mValues[this.mSize++] = value;
        }

        private void ensureCapacity(int count) {
            int requestedSize = this.mSize + count;
            if (requestedSize >= this.mValues.length) {
                int newCapacity = AutoGrowArray.computeNewCapacity(this.mSize, requestedSize);
                float[] newValues = ArrayUtils.newUnpaddedFloatArray(newCapacity);
                System.arraycopy((float[])this.mValues, (int)0, (float[])newValues, (int)0, (int)this.mSize);
                this.mValues = newValues;
            }
        }

        public void clear() {
            this.mSize = 0;
        }

        public void clearWithReleasingLargeArray() {
            this.clear();
            if (this.mValues.length > 10000) {
                this.mValues = EmptyArray.FLOAT;
            }
        }

        public float get(int index) {
            return this.mValues[index];
        }

        public void set(int index, float value) {
            this.mValues[index] = value;
        }

        public int size() {
            return this.mSize;
        }

        public float[] getRawArray() {
            return this.mValues;
        }
    }

    public static class IntArray {
        private int[] mValues;
        private int mSize;

        public IntArray() {
            this(10);
        }

        public IntArray(int initialCapacity) {
            this.mValues = initialCapacity == 0 ? EmptyArray.INT : ArrayUtils.newUnpaddedIntArray(initialCapacity);
            this.mSize = 0;
        }

        public void resize(int newSize) {
            if (newSize > this.mValues.length) {
                this.ensureCapacity(newSize - this.mSize);
            }
            this.mSize = newSize;
        }

        public void append(int value) {
            this.ensureCapacity(1);
            this.mValues[this.mSize++] = value;
        }

        private void ensureCapacity(int count) {
            int requestedSize = this.mSize + count;
            if (requestedSize >= this.mValues.length) {
                int newCapacity = AutoGrowArray.computeNewCapacity(this.mSize, requestedSize);
                int[] newValues = ArrayUtils.newUnpaddedIntArray(newCapacity);
                System.arraycopy((int[])this.mValues, (int)0, (int[])newValues, (int)0, (int)this.mSize);
                this.mValues = newValues;
            }
        }

        public void clear() {
            this.mSize = 0;
        }

        public void clearWithReleasingLargeArray() {
            this.clear();
            if (this.mValues.length > 10000) {
                this.mValues = EmptyArray.INT;
            }
        }

        public int get(int index) {
            return this.mValues[index];
        }

        public void set(int index, int value) {
            this.mValues[index] = value;
        }

        public int size() {
            return this.mSize;
        }

        public int[] getRawArray() {
            return this.mValues;
        }
    }

    public static class ByteArray {
        private byte[] mValues;
        private int mSize;

        public ByteArray() {
            this(10);
        }

        public ByteArray(int initialCapacity) {
            this.mValues = initialCapacity == 0 ? EmptyArray.BYTE : ArrayUtils.newUnpaddedByteArray(initialCapacity);
            this.mSize = 0;
        }

        public void resize(int newSize) {
            if (newSize > this.mValues.length) {
                this.ensureCapacity(newSize - this.mSize);
            }
            this.mSize = newSize;
        }

        public void append(byte value) {
            this.ensureCapacity(1);
            this.mValues[this.mSize++] = value;
        }

        private void ensureCapacity(int count) {
            int requestedSize = this.mSize + count;
            if (requestedSize >= this.mValues.length) {
                int newCapacity = AutoGrowArray.computeNewCapacity(this.mSize, requestedSize);
                byte[] newValues = ArrayUtils.newUnpaddedByteArray(newCapacity);
                System.arraycopy((byte[])this.mValues, (int)0, (byte[])newValues, (int)0, (int)this.mSize);
                this.mValues = newValues;
            }
        }

        public void clear() {
            this.mSize = 0;
        }

        public void clearWithReleasingLargeArray() {
            this.clear();
            if (this.mValues.length > 10000) {
                this.mValues = EmptyArray.BYTE;
            }
        }

        public byte get(int index) {
            return this.mValues[index];
        }

        public void set(int index, byte value) {
            this.mValues[index] = value;
        }

        public int size() {
            return this.mSize;
        }

        public byte[] getRawArray() {
            return this.mValues;
        }
    }
}

